/*
 * Decompiled with CFR 0.152.
 */
package btree4j.utils.collections;

import java.io.Serializable;

public final class IntStack
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1717535876231216483L;
    public static final int DEFAULT_CAPACITY = 12;
    private int size;
    private int[] data;

    public IntStack() {
        this(12);
    }

    public IntStack(int initSize) {
        this.data = new int[initSize];
    }

    private IntStack(int[] data) {
        this.data = data;
        this.size = data.length;
    }

    public void push(int value) {
        this.ensureCapacity(this.size + 1);
        this.data[this.size++] = value;
    }

    public int pop() {
        return this.data[--this.size];
    }

    public int peek() {
        return this.data[this.size - 1];
    }

    public int elementAt(int depth) {
        return this.data[depth];
    }

    public void clear() {
        this.size = 0;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    private void ensureCapacity(int size) {
        while (this.data.length < size) {
            int len = this.data.length;
            int[] newArray = new int[len * 2];
            System.arraycopy(this.data, 0, newArray, 0, len);
            this.data = newArray;
        }
    }

    public int[] toArray() {
        int[] newArray = new int[this.size];
        System.arraycopy(this.data, 0, newArray, 0, this.size);
        return newArray;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        for (int i = 0; i < this.size; ++i) {
            if (i != 0) {
                buf.append(", ");
            }
            buf.append(this.data[i]);
        }
        buf.append(']');
        return buf.toString();
    }

    public IntStack clone() {
        IntStack cloned = new IntStack((int[])this.data.clone());
        cloned.size = this.size;
        return cloned;
    }
}

