/*
 * Decompiled with CFR 0.152.
 */
package btree4j.utils.collections;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.LinkedHashMap;
import java.util.Map;

public class LRUMap<K, V>
extends LinkedHashMap<K, V> {
    private static final long serialVersionUID = 1L;
    protected final int maxCapacity;

    public LRUMap(int maxCapacity) {
        super(maxCapacity, 1.0f, true);
        this.maxCapacity = maxCapacity;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return this.size() > this.maxCapacity;
    }

    public void writeTo(ObjectOutput out) throws IOException {
        out.writeInt(this.maxCapacity);
        int size = this.size();
        out.writeInt(size);
        for (Map.Entry e : this.entrySet()) {
            out.writeObject(e.getKey());
            out.writeObject(e.getValue());
        }
    }

    public static <K, V> LRUMap<K, V> readFrom(ObjectInput in) throws IOException, ClassNotFoundException {
        int cap = in.readInt();
        LRUMap<Object, Object> map = new LRUMap<Object, Object>(cap);
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            Object key = in.readObject();
            Object value = in.readObject();
            map.put(key, value);
        }
        return map;
    }
}

