/*
 * Decompiled with CFR 0.152.
 */
package btree4j.utils.collections;

import btree4j.utils.collections.LRUMap;
import java.util.Map;
import javax.annotation.Nullable;

public final class ObservableLRUMap<K, V>
extends LRUMap<K, V> {
    private static final long serialVersionUID = 8089714061811479021L;
    @Nullable
    private transient Cleaner<K, V> cleaner;

    public ObservableLRUMap(int limit) {
        super(limit);
    }

    public ObservableLRUMap(int limit, Cleaner<K, V> cleaner) {
        super(limit);
        this.cleaner = cleaner;
    }

    public void setCleaner(Cleaner<K, V> cleaner) {
        this.cleaner = cleaner;
    }

    @Override
    public void clear() {
        if (this.cleaner != null) {
            for (Map.Entry e : this.entrySet()) {
                this.cleaner.cleanup(e.getKey(), e.getValue());
            }
        }
        super.clear();
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        if (this.size() > this.maxCapacity) {
            if (this.cleaner != null) {
                this.cleaner.cleanup(eldest.getKey(), eldest.getValue());
            }
            return true;
        }
        return false;
    }

    public static interface Cleaner<K, V> {
        public void cleanup(K var1, V var2);
    }
}

