/*
 * Decompiled with CFR 0.152.
 */
package btree4j.utils.collections.longs;

import java.io.Serializable;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public final class LongArrayList
implements Serializable {
    private static final long serialVersionUID = -3522471296182738673L;
    public static final int DEFAULT_CAPACITY = 12;
    @Nonnull
    private long[] data;
    private int used;

    public LongArrayList() {
        this(12);
    }

    public LongArrayList(int size) {
        this.data = new long[size];
        this.used = 0;
    }

    public LongArrayList(@CheckForNull long[] initValues, int used) {
        this.data = Objects.requireNonNull(initValues);
        this.used = used;
    }

    public void add(long value) {
        if (this.used >= this.data.length) {
            this.expand(this.used + 1);
        }
        this.data[this.used++] = value;
    }

    public void add(long[] values) {
        int needs = this.used + values.length;
        if (needs >= this.data.length) {
            this.expand(needs);
        }
        System.arraycopy(values, 0, this.data, this.used, values.length);
        this.used = needs;
    }

    private void expand(int minimumCapacity) {
        while (this.data.length < minimumCapacity) {
            int oldLen = this.data.length;
            int newLen = (int)Math.max((long)minimumCapacity, Math.min((long)oldLen * 2L, Integer.MAX_VALUE));
            long[] newArray = new long[newLen];
            System.arraycopy(this.data, 0, newArray, 0, oldLen);
            this.data = newArray;
        }
    }

    public long remove() {
        if (this.used == 0) {
            throw new NoSuchElementException("No elements to remove");
        }
        return this.data[--this.used];
    }

    public long remove(int index) {
        long ret;
        if (index >= this.used) {
            throw new IndexOutOfBoundsException();
        }
        if (index == this.used) {
            ret = this.data[index];
            --this.used;
        } else {
            ret = this.data[index];
            System.arraycopy(this.data, index + 1, this.data, index, this.used - index - 1);
            --this.used;
        }
        return ret;
    }

    public void set(int index, long value) {
        if (index > this.used) {
            throw new IllegalArgumentException("Index MUST be less than \"size()\".");
        }
        if (index == this.used) {
            ++this.used;
        }
        this.data[index] = value;
    }

    public long get(int index) {
        if (index >= this.used) {
            throw new IndexOutOfBoundsException();
        }
        return this.data[index];
    }

    public long indexOf(int key) {
        return Arrays.binarySearch(this.data, (long)key);
    }

    public int size() {
        return this.used;
    }

    public void clear() {
        this.used = 0;
    }

    public long[] toArray() {
        long[] newArray = new long[this.used];
        System.arraycopy(this.data, 0, newArray, 0, this.used);
        return newArray;
    }

    public long[] array() {
        return this.data;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof LongArrayList) {
            LongArrayList other = (LongArrayList)obj;
            if (other.size() != this.used) {
                return false;
            }
            return Arrays.equals(this.toArray(), other.toArray());
        }
        return false;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        for (int i = 0; i < this.used; ++i) {
            if (i != 0) {
                buf.append(", ");
            }
            buf.append(this.data[i]);
        }
        buf.append(']');
        return buf.toString();
    }
}

