/*
 * Decompiled with CFR 0.152.
 */
package btree4j.utils.collections.longs;

import btree4j.utils.lang.HashUtils;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class LongHash<V>
implements Externalizable,
Iterable<BucketEntry<V>> {
    private static final long serialVersionUID = 1L;
    private static final float DEFAULT_LOAD_FACTOR = 0.7f;
    private transient float _loadFactor = 0.7f;
    protected BucketEntry<V>[] _buckets;
    private int _mask;
    protected int _threshold;
    protected int _size = 0;

    public LongHash(int size, float loadFactor) {
        int bucketSize = HashUtils.nextPowerOfTwo(size);
        this._buckets = new BucketEntry[bucketSize];
        this._mask = bucketSize - 1;
        this._loadFactor = loadFactor;
        this._threshold = (int)((float)size * loadFactor);
    }

    public LongHash(int size) {
        this(size, 0.7f);
    }

    public LongHash() {
        this(1);
    }

    public int size() {
        return this._size;
    }

    public V put(long key, V value) {
        BucketEntry<V>[] buckets = this._buckets;
        int bucket = LongHash.indexFor(key, this._mask);
        BucketEntry<V> e = buckets[bucket];
        while (e != null) {
            if (key == e.key) {
                Object replaced = e.value;
                e.value = value;
                e.recordAccess(this);
                return replaced;
            }
            e = e.next;
        }
        this.addEntry(bucket, key, value, buckets[bucket]);
        return null;
    }

    public V putIfAbsent(long key, V value) {
        BucketEntry<V>[] buckets = this._buckets;
        int bucket = LongHash.indexFor(key, this._mask);
        BucketEntry<V> e = buckets[bucket];
        while (e != null) {
            if (key == e.key) {
                return e.value;
            }
            e = e.next;
        }
        this.addEntry(bucket, key, value, buckets[bucket]);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final V syncPut(long key, V value) {
        BucketEntry<V>[] buckets = this._buckets;
        int bucket = LongHash.indexFor(key, this._mask);
        BucketEntry<V>[] bucketEntryArray = buckets;
        synchronized (buckets) {
            BucketEntry<V> e = buckets[bucket];
            while (e != null) {
                if (key == e.key) {
                    Object replaced = e.value;
                    e.value = value;
                    e.recordAccess(this);
                    // ** MonitorExit[var6_5] (shouldn't be in output)
                    return replaced;
                }
                e = e.next;
            }
            this.addEntry(bucket, key, value, buckets[bucket]);
            // ** MonitorExit[var6_5] (shouldn't be in output)
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final V syncPutIfAbsent(long key, V value) {
        BucketEntry<V>[] buckets = this._buckets;
        int bucket = LongHash.indexFor(key, this._mask);
        BucketEntry<V>[] bucketEntryArray = buckets;
        synchronized (buckets) {
            BucketEntry<V> e = buckets[bucket];
            while (e != null) {
                if (key == e.key) {
                    // ** MonitorExit[var6_5] (shouldn't be in output)
                    return e.value;
                }
                e = e.next;
            }
            this.addEntry(bucket, key, value, buckets[bucket]);
            // ** MonitorExit[var6_5] (shouldn't be in output)
            return null;
        }
    }

    public final V get(long key) {
        BucketEntry<V>[] buckets = this._buckets;
        int bucket = LongHash.indexFor(key, this._mask);
        BucketEntry<V> e = buckets[bucket];
        while (e != null) {
            if (key == e.key) {
                e.recordAccess(this);
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final V syncGet(long key) {
        BucketEntry<V>[] buckets = this._buckets;
        int bucket = LongHash.indexFor(key, this._mask);
        BucketEntry<V>[] bucketEntryArray = buckets;
        synchronized (buckets) {
            BucketEntry<V> e = buckets[bucket];
            while (e != null) {
                if (key == e.key) {
                    e.recordAccess(this);
                    // ** MonitorExit[var5_4] (shouldn't be in output)
                    return e.value;
                }
                e = e.next;
            }
            // ** MonitorExit[var5_4] (shouldn't be in output)
            return null;
        }
    }

    public boolean contains(long key) {
        BucketEntry<V>[] buckets = this._buckets;
        int bucket = LongHash.indexFor(key, this._mask);
        BucketEntry<V> e = buckets[bucket];
        while (e != null) {
            if (key == e.key) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public synchronized void clear() {
        BucketEntry<V>[] tab = this._buckets;
        int i = tab.length;
        while (--i >= 0) {
            tab[i] = null;
        }
        this._size = 0;
    }

    public V remove(long key) {
        BucketEntry<V>[] buckets = this._buckets;
        int bucket = LongHash.indexFor(key, this._mask);
        BucketEntry<V> prev = null;
        BucketEntry<V> e = buckets[bucket];
        while (e != null) {
            if (key == e.key) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    buckets[bucket] = e.next;
                }
                --this._size;
                e.recordRemoval(this);
                return e.value;
            }
            prev = e;
            e = e.next;
        }
        return null;
    }

    protected void addEntry(int bucket, long key, V value, BucketEntry<V> next) {
        BucketEntry<V> entry = new BucketEntry<V>(key, value, next);
        this._buckets[bucket] = entry;
        if (++this._size > this._threshold) {
            this.resize(2 * this._buckets.length);
        }
    }

    protected void resize(int newCapacity) {
        int cap = HashUtils.nextPowerOfTwo(newCapacity);
        BucketEntry[] newTable = new BucketEntry[cap];
        this.rehash(newTable);
        this._buckets = newTable;
        this._mask = cap - 1;
        this._threshold = (int)((float)newCapacity * this._loadFactor);
    }

    private void rehash(BucketEntry<V>[] newTable) {
        for (BucketEntry<V> oldEntry : this._buckets) {
            while (oldEntry != null) {
                BucketEntry<V> e = oldEntry;
                oldEntry = oldEntry.next;
                int bucket = LongHash.indexFor(e.key, this._mask);
                e.next = newTable[bucket];
                newTable[bucket] = e;
            }
        }
    }

    private static int indexFor(long key, int mask) {
        return (int)(key ^ key >>> 32) & Integer.MAX_VALUE & mask;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._threshold = in.readInt();
        this._size = in.readInt();
        int blen = in.readInt();
        this._buckets = new BucketEntry[blen];
        this._mask = blen - 1;
        for (int i = 0; i < blen; ++i) {
            this._buckets[i] = (BucketEntry)in.readObject();
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this._threshold);
        out.writeInt(this._size);
        out.writeInt(this._buckets.length);
        for (int i = 0; i < this._buckets.length; ++i) {
            out.writeObject(this._buckets[i]);
        }
    }

    @Override
    public Iterator<BucketEntry<V>> iterator() {
        return new LongIterator();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(512);
        for (BucketEntry<V> e : this) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append('{');
            buf.append(e.key);
            buf.append('/');
            buf.append(e.value);
            buf.append('}');
        }
        return buf.toString();
    }

    public static interface Cleaner<V> {
        public void cleanup(long var1, V var3);
    }

    public static class LongLRUMap<V>
    extends LongHash<V> {
        private static final long serialVersionUID = 5136805290014155775L;
        private final int maxCapacity;
        protected final transient ChainedEntry<V> entryChainHeader;

        public LongLRUMap(int limit) {
            super(limit, 1.0f);
            this.maxCapacity = limit;
            ChainedEntry<Object> header = new ChainedEntry<Object>(-1L, null, null);
            this.entryChainHeader = header;
            this.initEntryChain(header);
        }

        private void initEntryChain(ChainedEntry<V> header) {
            header.next = header;
            header.prev = header.next;
        }

        @Override
        protected void addEntry(int bucket, long key, V value, BucketEntry<V> next) {
            ChainedEntry<V> newEntry;
            this._buckets[bucket] = newEntry = new ChainedEntry<V>(key, value, next);
            newEntry.addBefore(this.entryChainHeader);
            ++this._size;
            ChainedEntry eldest = this.entryChainHeader.next;
            if (this.removeEldestEntry()) {
                this.remove(eldest.key);
            } else if (this._size > this._threshold) {
                throw new IllegalStateException("size '" + this._size + "' exceeds threshold '" + this._threshold + '\'');
            }
        }

        protected boolean removeEldestEntry() {
            return this.size() > this.maxCapacity;
        }

        @Override
        public final Iterator<BucketEntry<V>> iterator() {
            return new OrderIterator(this.entryChainHeader);
        }

        @Override
        public synchronized void clear() {
            this.initEntryChain(this.entryChainHeader);
            super.clear();
        }

        private final class OrderIterator
        implements Iterator<BucketEntry<V>> {
            private ChainedEntry<V> entry;

            public OrderIterator(ChainedEntry<V> e) {
                if (e == null) {
                    throw new IllegalArgumentException();
                }
                this.entry = e;
            }

            @Override
            public boolean hasNext() {
                return this.entry.next != LongLRUMap.this.entryChainHeader;
            }

            @Override
            public BucketEntry<V> next() {
                this.entry = this.entry.next;
                if (this.entry == LongLRUMap.this.entryChainHeader) {
                    throw new NoSuchElementException();
                }
                return this.entry;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }

        protected static class ChainedEntry<V>
        extends BucketEntry<V> {
            private static final long serialVersionUID = 8853020653416971039L;
            protected ChainedEntry<V> prev;
            protected ChainedEntry<V> next;

            ChainedEntry(long key, V value, BucketEntry<V> next) {
                super(key, value, next);
            }

            @Override
            protected void recordAccess(LongHash<V> m) {
                this.remove();
                LongLRUMap lm = (LongLRUMap)m;
                this.addBefore(lm.entryChainHeader);
            }

            @Override
            protected void recordRemoval(LongHash<V> m) {
                this.remove();
            }

            protected void remove() {
                if (this.prev != null) {
                    this.prev.next = this.next;
                }
                if (this.next != null) {
                    this.next.prev = this.prev;
                }
                this.prev = null;
                this.next = null;
            }

            protected void addBefore(ChainedEntry<V> existingEntry) {
                this.next = existingEntry;
                this.prev = existingEntry.prev;
                if (this.prev != null) {
                    this.prev.next = this;
                }
                this.next.prev = this;
            }
        }
    }

    private final class LongIterator
    implements Iterator<BucketEntry<V>> {
        private int cursor = 0;
        private int curBucketIndex = 0;
        private BucketEntry<V> curBucket = null;

        LongIterator() {
        }

        @Override
        public boolean hasNext() {
            return LongHash.this._size > this.cursor;
        }

        @Override
        public BucketEntry<V> next() {
            ++this.cursor;
            if (this.curBucket == null) {
                for (int i = this.curBucketIndex; i < LongHash.this._buckets.length; ++i) {
                    BucketEntry e = LongHash.this._buckets[i];
                    if (e == null) continue;
                    this.curBucket = e;
                    this.curBucketIndex = i + 1;
                    break;
                }
            }
            if (this.curBucket != null) {
                BucketEntry e = this.curBucket;
                this.curBucket = e.next;
                return e;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class BucketEntry<V>
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        long key;
        V value;
        BucketEntry<V> next;

        BucketEntry(long key, V value, BucketEntry<V> next) {
            this.key = key;
            this.value = value;
            this.next = next;
        }

        private BucketEntry(long key, V value) {
            this(key, value, null);
        }

        public BucketEntry() {
        }

        public long getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.key = in.readLong();
            this.value = in.readObject();
            boolean hasNext = in.readBoolean();
            BucketEntry<Object> cur = this;
            while (hasNext) {
                long k = in.readLong();
                Object v = in.readObject();
                BucketEntry<Object> n = new BucketEntry<Object>(k, v);
                cur.next = n;
                cur = n;
                hasNext = in.readBoolean();
            }
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            assert (this.value != null);
            BucketEntry<V> cur = this;
            while (true) {
                out.writeLong(cur.key);
                out.writeObject(cur.value);
                if (cur.next == null) break;
                out.writeBoolean(true);
                cur = cur.next;
            }
            out.writeBoolean(false);
        }

        public String toString() {
            return new StringBuilder(64).append(this.key).append('/').append(this.value).toString();
        }

        protected void recordAccess(LongHash<V> m) {
        }

        protected void recordRemoval(LongHash<V> m) {
        }
    }
}

