/*
 * Decompiled with CFR 0.152.
 */
package btree4j.utils.collections.longs;

import btree4j.utils.collections.longs.LongHash;
import java.util.ArrayList;
import java.util.Collections;

public final class PurgeOptObservableLongLRUMap<V extends Comparable<V>>
extends LongHash.LongLRUMap<V> {
    private static final long serialVersionUID = 2481614187542943334L;
    private volatile int purgeUnits;
    private final LongHash.Cleaner<V> cleaner;

    public PurgeOptObservableLongLRUMap(int limit, LongHash.Cleaner<V> cleaner) {
        this(limit, 1, cleaner);
    }

    public PurgeOptObservableLongLRUMap(int limit, int purgeUnits, LongHash.Cleaner<V> cleaner) {
        super(limit);
        if (limit < purgeUnits) {
            throw new IllegalArgumentException("limit '" + limit + "' < pergeUnits '" + purgeUnits + '\'');
        }
        if (purgeUnits < 1) {
            throw new IllegalArgumentException("Illegal purgeUnits: " + purgeUnits);
        }
        this.purgeUnits = purgeUnits;
        this.cleaner = cleaner;
    }

    public void setPurgeUnits(int units) {
        if (units < 1) {
            throw new IllegalArgumentException("Illegal purgeUnits: " + units);
        }
        this.purgeUnits = units;
    }

    @Override
    protected void addEntry(int bucket, long key, V value, LongHash.BucketEntry<V> next) {
        ComparableChainedEntry<V> newEntry;
        this._buckets[bucket] = newEntry = new ComparableChainedEntry<V>(key, value, next);
        newEntry.addBefore(this.entryChainHeader);
        ++this._size;
        if (this.removeEldestEntry()) {
            int purgeSize = this.purgeUnits;
            ArrayList<ComparableChainedEntry> list = new ArrayList<ComparableChainedEntry>(purgeSize);
            for (int i = 0; i < purgeSize; ++i) {
                ComparableChainedEntry eldest = (ComparableChainedEntry)this.entryChainHeader.next;
                Comparable removed = (Comparable)this.remove(eldest.key);
                if (removed == null) continue;
                list.add(eldest);
            }
            Collections.sort(list);
            for (ComparableChainedEntry e : list) {
                this.cleaner.cleanup(e.key, e.value);
            }
        } else if (this._size > this._threshold) {
            this.resize(2 * this._buckets.length);
        }
    }

    public void purgeAll() {
        ArrayList<ComparableChainedEntry> list = new ArrayList<ComparableChainedEntry>(this.size());
        for (ComparableChainedEntry e : this) {
            list.add(e);
        }
        this.clear();
        Collections.sort(list);
        for (ComparableChainedEntry e : list) {
            this.cleaner.cleanup(e.key, e.value);
        }
    }

    private static final class ComparableChainedEntry<V extends Comparable<V>>
    extends LongHash.LongLRUMap.ChainedEntry<V>
    implements Comparable<ComparableChainedEntry<V>> {
        private static final long serialVersionUID = 8853020653416971039L;

        ComparableChainedEntry(long key, V value, LongHash.BucketEntry<V> next) {
            super(key, value, next);
        }

        @Override
        public int compareTo(ComparableChainedEntry<V> o) {
            return ((Comparable)this.value).compareTo(o.value);
        }
    }
}

