/*
 * Decompiled with CFR 0.152.
 */
package btree4j.utils.io;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;

public final class FastByteArrayOutputStream
extends OutputStream {
    private static final int DEFAULT_BLOCK_SIZE = 8192;
    private byte[] buf;
    private int count;

    public FastByteArrayOutputStream() {
        this(8192);
    }

    public FastByteArrayOutputStream(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Negative initial size: " + size);
        }
        this.buf = new byte[size];
    }

    public byte[] getInternalArray() {
        return this.buf;
    }

    public byte[] toByteArray() {
        return Arrays.copyOf(this.buf, this.count);
    }

    @Override
    public void write(int b) {
        int newcount = this.count + 1;
        if (newcount > this.buf.length) {
            this.buf = Arrays.copyOf(this.buf, Math.max(this.buf.length << 1, newcount));
        }
        this.buf[this.count] = (byte)b;
        this.count = newcount;
    }

    @Override
    public void write(byte[] b, int off, int len) {
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int newcount = this.count + len;
        if (newcount > this.buf.length) {
            this.buf = Arrays.copyOf(this.buf, Math.max(this.buf.length << 1, newcount));
        }
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count = newcount;
    }

    public void write(ByteBuffer b) {
        this.write(b, b.remaining());
    }

    public void write(ByteBuffer b, int len) {
        int newcount = this.count + len;
        if (newcount > this.buf.length) {
            this.buf = Arrays.copyOf(this.buf, Math.max(this.buf.length << 1, newcount));
        }
        b.get(this.buf, this.count, len);
        this.count = newcount;
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(this.buf, 0, this.count);
    }

    public void reset() {
        this.count = 0;
    }

    public void reset(int size) {
        this.buf = new byte[size];
        this.count = 0;
    }

    public int size() {
        return this.count;
    }

    @Override
    public void close() throws IOException {
    }

    public void clear() {
        this.buf = null;
    }
}

