/*
 * Decompiled with CFR 0.152.
 */
package btree4j.utils.io;

import btree4j.utils.io.FastByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.LinkedList;

public final class FastMultiByteArrayOutputStream
extends OutputStream {
    private static final int DEFAULT_BLOCK_SIZE = 8192;
    private final int blockSize;
    private byte[] buffer;
    private int size;
    private LinkedList<byte[]> buffers;
    private int index;

    public FastMultiByteArrayOutputStream() {
        this(8192);
    }

    public FastMultiByteArrayOutputStream(int aSize) {
        this.blockSize = aSize;
        this.buffer = new byte[aSize];
    }

    public int size() {
        return this.size + this.index;
    }

    public byte[][] toMultiByteArray() {
        if (this.buffers == null) {
            byte[][] mb = new byte[][]{this.buffer};
            return mb;
        }
        int listsize = this.buffers.size();
        int size = listsize + 1;
        byte[][] mb = new byte[size][];
        this.buffers.toArray((T[])mb);
        mb[listsize] = this.buffer;
        return mb;
    }

    public byte[] toByteArray() {
        byte[] data = new byte[this.size()];
        int pos = 0;
        if (this.buffers != null) {
            for (byte[] bytes : this.buffers) {
                System.arraycopy(bytes, 0, data, pos, this.blockSize);
                pos += this.blockSize;
            }
        }
        System.arraycopy(this.buffer, 0, data, pos, this.index);
        return data;
    }

    public byte[] toByteArray_clear() {
        int size = this.size();
        byte[] data = new byte[size];
        int pos = 0;
        if (this.buffers != null) {
            while (!this.buffers.isEmpty()) {
                byte[] bytes = this.buffers.removeFirst();
                System.arraycopy(bytes, 0, data, pos, this.blockSize);
                pos += this.blockSize;
            }
        }
        System.arraycopy(this.buffer, 0, data, pos, this.index);
        return data;
    }

    public String toString() {
        return new String(this.toByteArray());
    }

    public String toString(String enc) throws UnsupportedEncodingException {
        return new String(this.toByteArray(), enc);
    }

    @Override
    public void write(int datum) {
        if (this.index >= this.blockSize) {
            this.addBuffer();
        }
        this.buffer[this.index++] = (byte)datum;
    }

    @Override
    public void write(byte[] data, int offset, int length) {
        if (data == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || offset + length > data.length || length < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.index + length >= this.blockSize) {
            int copyLength;
            do {
                if (this.index == this.blockSize) {
                    this.addBuffer();
                }
                if (length < (copyLength = this.blockSize - this.index)) {
                    copyLength = length;
                }
                System.arraycopy(data, offset, this.buffer, this.index, copyLength);
                offset += copyLength;
                this.index += copyLength;
            } while ((length -= copyLength) > 0);
        } else {
            System.arraycopy(data, offset, this.buffer, this.index, length);
            this.index += length;
        }
    }

    public void writeInt(int v) throws IOException {
        if (this.index + 3 >= this.blockSize) {
            this.addBuffer();
        }
        this.buffer[this.index++] = (byte)(v >>> 24);
        this.buffer[this.index++] = (byte)(v >>> 16);
        this.buffer[this.index++] = (byte)(v >>> 8);
        this.buffer[this.index++] = (byte)(v >>> 0);
    }

    public void writeLong(long v) throws IOException {
        if (this.index + 7 >= this.blockSize) {
            this.addBuffer();
        }
        this.buffer[this.index++] = (byte)(v >>> 56);
        this.buffer[this.index++] = (byte)(v >>> 48);
        this.buffer[this.index++] = (byte)(v >>> 40);
        this.buffer[this.index++] = (byte)(v >>> 32);
        this.buffer[this.index++] = (byte)(v >>> 24);
        this.buffer[this.index++] = (byte)(v >>> 16);
        this.buffer[this.index++] = (byte)(v >>> 8);
        this.buffer[this.index++] = (byte)(v >>> 0);
    }

    public void writeInts(int[] v, int off, int len) throws IOException {
        int endoff = off + len;
        for (int i = off; i < endoff; ++i) {
            this.writeInt(v[i]);
        }
    }

    public void writeLongs(long[] v, int off, int len) throws IOException {
        int endoff = off + len;
        for (int i = off; i < endoff; ++i) {
            this.writeLong(v[i]);
        }
    }

    public void reset() {
        this.buffer = new byte[this.blockSize];
        this.buffers = null;
        this.size = 0;
        this.index = 0;
    }

    public void writeTo(OutputStream out) throws IOException {
        if (this.buffers != null) {
            for (byte[] bytes : this.buffers) {
                out.write(bytes, 0, this.blockSize);
            }
        }
        out.write(this.buffer, 0, this.index);
    }

    public InputStream getInputStream() {
        return new FastByteArrayInputStream(this.toByteArray());
    }

    private void addBuffer() {
        if (this.buffers == null) {
            this.buffers = new LinkedList();
        }
        this.buffers.addLast(this.buffer);
        this.buffer = new byte[this.blockSize];
        this.size += this.index;
        this.index = 0;
    }

    @Override
    public void close() throws IOException {
    }

    public void clear() {
        this.buffer = null;
        this.buffers = null;
    }
}

