/*
 * Decompiled with CFR 0.152.
 */
package btree4j.utils.io;

import btree4j.utils.io.IOUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class FileUtils {
    private FileUtils() {
    }

    public static File getTempDir() {
        String tmpdir = System.getProperty("java.io.tmpdir");
        return new File(tmpdir);
    }

    public static long getFileSize(File file) {
        if (!file.exists()) {
            return -1L;
        }
        long size = 0L;
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files != null && files.length > 0) {
                for (File f : files) {
                    size += FileUtils.getFileSize(f);
                }
            }
        } else {
            size += file.length();
        }
        return size;
    }

    public static List<File> listFiles(File directory, IOFileFilter fileFilter, IOFileFilter dirFilter) {
        if (fileFilter == null) {
            throw new NullPointerException("Parameter 'fileFilter' is null");
        }
        AndFileFilter effFileFilter = new AndFileFilter(fileFilter, new NotFileFilter(DirectoryFileFilter.INSTANCE));
        IOFileFilter effDirFilter = dirFilter == null ? FalseFileFilter.INSTANCE : new AndFileFilter(dirFilter, DirectoryFileFilter.INSTANCE);
        ArrayList<File> files = new ArrayList<File>(12);
        FileUtils.innerListFiles(files, directory, new OrFileFilter(effFileFilter, effDirFilter));
        return files;
    }

    private static void innerListFiles(Collection<File> files, File directory, IOFileFilter filter) {
        File[] found = directory.listFiles(filter);
        if (found != null) {
            for (int i = 0; i < found.length; ++i) {
                if (found[i].isDirectory()) {
                    FileUtils.innerListFiles(files, found[i], filter);
                    continue;
                }
                files.add(found[i]);
            }
        }
    }

    public static List<File> listFiles(File directory, boolean recursive) {
        return FileUtils.listFiles(directory, TrueFileFilter.INSTANCE, recursive ? TrueFileFilter.INSTANCE : FalseFileFilter.INSTANCE);
    }

    public static List<File> listFiles(File directory, String suffix, boolean recursive) {
        return FileUtils.listFiles(directory, new String[]{suffix}, recursive);
    }

    public static List<File> listFiles(File directory, String[] suffixes, boolean recursive) {
        IOFileFilter filter = suffixes == null || suffixes.length == 0 ? TrueFileFilter.INSTANCE : new SuffixFileFilter(suffixes);
        return FileUtils.listFiles(directory, filter, recursive ? TrueFileFilter.INSTANCE : FalseFileFilter.INSTANCE);
    }

    public static List<File> listFiles(File directory, String[] prefixes, String[] suffixes, boolean recursive) {
        IOFileFilter fileFiler = null;
        if (prefixes != null && prefixes.length > 0) {
            fileFiler = new PrefixFileFilter(prefixes);
        }
        if (suffixes != null && suffixes.length > 0) {
            fileFiler = new AndFileFilter(fileFiler, new SuffixFileFilter(suffixes));
        }
        return FileUtils.listFiles(directory, fileFiler == null ? TrueFileFilter.INSTANCE : fileFiler, recursive ? TrueFileFilter.INSTANCE : FalseFileFilter.INSTANCE);
    }

    public static void cleanDirectory(File dir) throws IOException {
        if (!dir.exists()) {
            throw new IllegalArgumentException(dir + " does not exist");
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException(dir + " is not a directory");
        }
        File[] files = dir.listFiles();
        if (files == null) {
            throw new IOException("Failed to list contents of " + dir);
        }
        for (int i = 0; i < files.length; ++i) {
            if (files[i].delete()) continue;
            throw new IOException("Unable to delete file: " + files[i].getAbsolutePath());
        }
    }

    public static String getFileName(File file) {
        assert (file != null);
        if (!file.exists()) {
            return null;
        }
        String filepath = file.getName();
        int i = filepath.lastIndexOf(File.separator);
        return i >= 0 ? filepath.substring(i + 1) : filepath;
    }

    public static String basename(String filepath) {
        int index = filepath.lastIndexOf(File.separatorChar);
        if (-1 == index) {
            return filepath;
        }
        return filepath.substring(index + 1);
    }

    public static String basename(String filepath, char separator) {
        int index = filepath.lastIndexOf(separator);
        if (-1 == index) {
            return filepath;
        }
        return filepath.substring(index + 1);
    }

    public static String dirName(String filepath, char separatorChar) {
        int index = filepath.lastIndexOf(separatorChar);
        if (-1 == index) {
            return new String(new char[]{separatorChar});
        }
        return filepath.substring(0, index);
    }

    public static void truncateFile(File file) {
        RandomAccessFile raf;
        try {
            raf = new RandomAccessFile(file, "rw");
        }
        catch (FileNotFoundException fnfe) {
            throw new IllegalStateException(fnfe);
        }
        try {
            raf.setLength(0L);
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
        finally {
            IOUtils.closeQuietly((Closeable)raf);
        }
    }

    public static String toString(File file) {
        try {
            FileInputStream fis = new FileInputStream(file);
            return IOUtils.toString(fis);
        }
        catch (IOException e) {
            throw new IllegalStateException("failed reading a file: " + file.getAbsolutePath(), e);
        }
    }

    public static File resolvePath(File base, String path) {
        File f = new File(path);
        return f.isAbsolute() ? f : new File(base, path);
    }

    public static final class NameFileFilter
    implements IOFileFilter {
        private final String[] names;

        public NameFileFilter(String ... names) {
            if (names == null) {
                throw new IllegalArgumentException("The array of names must not be null");
            }
            this.names = names;
        }

        @Override
        public boolean accept(File file) {
            String name = file.getName();
            for (int i = 0; i < this.names.length; ++i) {
                if (!name.equals(this.names[i])) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean accept(File file, String name) {
            for (int i = 0; i < this.names.length; ++i) {
                if (!name.equals(this.names[i])) continue;
                return true;
            }
            return false;
        }
    }

    public static final class DirectoryFileFilter
    implements IOFileFilter {
        public static final DirectoryFileFilter INSTANCE = new DirectoryFileFilter();

        private DirectoryFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            return file.isDirectory();
        }

        @Override
        public boolean accept(File dir, String name) {
            return this.accept(new File(dir, name));
        }
    }

    public static final class NotFileFilter
    implements IOFileFilter {
        private final IOFileFilter filter;

        public NotFileFilter(IOFileFilter filter) {
            if (filter == null) {
                throw new IllegalArgumentException("The filter must not be null");
            }
            this.filter = filter;
        }

        @Override
        public boolean accept(File file) {
            return !this.filter.accept(file);
        }

        @Override
        public boolean accept(File file, String name) {
            return !this.filter.accept(file, name);
        }
    }

    public static final class OrFileFilter
    implements IOFileFilter {
        private final IOFileFilter[] fileFilters;

        public OrFileFilter(IOFileFilter ... filter) {
            assert (filter != null);
            this.fileFilters = filter;
        }

        @Override
        public boolean accept(File file) {
            for (IOFileFilter fileFilter : this.fileFilters) {
                if (!fileFilter.accept(file)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean accept(File file, String name) {
            for (IOFileFilter fileFilter : this.fileFilters) {
                if (!fileFilter.accept(file, name)) continue;
                return true;
            }
            return false;
        }
    }

    public static final class AndFileFilter
    implements IOFileFilter {
        private final IOFileFilter[] fileFilters;

        public AndFileFilter(IOFileFilter ... filter) {
            assert (filter != null);
            this.fileFilters = filter;
        }

        @Override
        public boolean accept(File file) {
            if (this.fileFilters.length == 0) {
                return false;
            }
            for (IOFileFilter fileFilter : this.fileFilters) {
                if (fileFilter.accept(file)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean accept(File file, String name) {
            if (this.fileFilters.length == 0) {
                return false;
            }
            for (IOFileFilter fileFilter : this.fileFilters) {
                if (fileFilter.accept(file, name)) continue;
                return false;
            }
            return true;
        }
    }

    public static final class SuffixFileFilter
    implements IOFileFilter {
        private final String[] suffixes;

        public SuffixFileFilter(String ... suffixes) {
            if (suffixes == null) {
                throw new IllegalArgumentException("The array of suffixes must not be null");
            }
            this.suffixes = suffixes;
        }

        @Override
        public boolean accept(File file) {
            String name = file.getName();
            for (int i = 0; i < this.suffixes.length; ++i) {
                if (!name.endsWith(this.suffixes[i])) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean accept(File file, String name) {
            for (int i = 0; i < this.suffixes.length; ++i) {
                if (!name.endsWith(this.suffixes[i])) continue;
                return true;
            }
            return false;
        }
    }

    public static final class PrefixFileFilter
    implements IOFileFilter {
        private final String[] prefixes;

        public PrefixFileFilter(String ... prefixes) {
            if (prefixes == null) {
                throw new IllegalArgumentException("The array of prefixes must not be null");
            }
            this.prefixes = prefixes;
        }

        @Override
        public boolean accept(File file) {
            String name = file.getName();
            for (int i = 0; i < this.prefixes.length; ++i) {
                if (!name.startsWith(this.prefixes[i])) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean accept(File file, String name) {
            for (int i = 0; i < this.prefixes.length; ++i) {
                if (!name.startsWith(this.prefixes[i])) continue;
                return true;
            }
            return false;
        }
    }

    public static final class FalseFileFilter
    implements IOFileFilter {
        static final FalseFileFilter INSTANCE = new FalseFileFilter();

        private FalseFileFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            return false;
        }

        @Override
        public boolean accept(File dir, String name) {
            return false;
        }
    }

    public static final class TrueFileFilter
    implements IOFileFilter {
        static final TrueFileFilter INSTANCE = new TrueFileFilter();

        private TrueFileFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            return true;
        }

        @Override
        public boolean accept(File dir, String name) {
            return true;
        }
    }

    public static interface IOFileFilter
    extends FileFilter,
    FilenameFilter {
    }
}

