/*
 * Decompiled with CFR 0.152.
 */
package btree4j.utils.io;

import btree4j.utils.io.FastBufferedInputStream;
import btree4j.utils.io.FastBufferedOutputStream;
import btree4j.utils.io.FastByteArrayOutputStream;
import btree4j.utils.io.FastMultiByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class IOUtils {
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    private IOUtils() {
    }

    public static void writeInt(int v, OutputStream out) throws IOException {
        out.write(v >>> 24 & 0xFF);
        out.write(v >>> 16 & 0xFF);
        out.write(v >>> 8 & 0xFF);
        out.write(v >>> 0 & 0xFF);
    }

    public static int readInt(InputStream in) throws IOException {
        int ch1 = in.read();
        int ch2 = in.read();
        int ch3 = in.read();
        int ch4 = in.read();
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public static int readUnsignedIntOrEOF(InputStream in) throws IOException {
        int ch1 = in.read();
        if (ch1 == -1) {
            return -1;
        }
        int ch2 = in.read();
        int ch3 = in.read();
        int ch4 = in.read();
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public static void writeChar(char v, OutputStream out) throws IOException {
        out.write(0xFF & v >> 8);
        out.write(0xFF & v);
    }

    public static void writeChar(char v, FastByteArrayOutputStream out) {
        out.write(0xFF & v >> 8);
        out.write(0xFF & v);
    }

    public static char readChar(InputStream in) throws IOException {
        int a = in.read();
        int b = in.read();
        return (char)(a << 8 | b & 0xFF);
    }

    public static void readFully(InputStream in, byte[] b, int offset, int len) throws IOException {
        int bytesRead;
        do {
            if ((bytesRead = in.read(b, offset, len)) < 0) {
                throw new EOFException();
            }
            offset += bytesRead;
        } while ((len -= bytesRead) != 0);
    }

    public static void readFully(InputStream in, byte[] b) throws IOException {
        IOUtils.readFully(in, b, 0, b.length);
    }

    public static int readLoop(InputStream in, byte[] b, int off, int len) throws IOException {
        int got;
        int total = 0;
        do {
            if ((got = in.read(b, off + total, len - total)) >= 0) continue;
            return total == 0 ? -1 : total;
        } while ((total += got) != len);
        return total;
    }

    public static int copy(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[4096];
        int count = 0;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += n;
        }
        return count;
    }

    public static int copy(Reader input, Writer output) throws IOException {
        char[] buffer = new char[4096];
        int count = 0;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += n;
        }
        return count;
    }

    public static void copy(String input, OutputStream output) throws IOException {
        StringReader in = new StringReader(input);
        OutputStreamWriter out = new OutputStreamWriter(output);
        IOUtils.copy(in, out);
        out.flush();
    }

    public static String toString(InputStream input) throws IOException {
        FastMultiByteArrayOutputStream output = new FastMultiByteArrayOutputStream();
        IOUtils.copy(input, (OutputStream)output);
        return output.toString();
    }

    public static String toString(InputStream input, String cs) throws IOException {
        FastMultiByteArrayOutputStream output = new FastMultiByteArrayOutputStream();
        IOUtils.copy(input, (OutputStream)output);
        return output.toString(cs);
    }

    public static String toString(Reader input) throws IOException {
        StringWriter sw = new StringWriter();
        IOUtils.copy(input, sw);
        return sw.toString();
    }

    @Deprecated
    public static void getBytes(List<byte[]> srcLst, byte[] dest) {
        int pos = 0;
        for (byte[] bytes : srcLst) {
            int len = bytes.length;
            System.arraycopy(bytes, 0, dest, pos, len);
            pos += len;
        }
    }

    public static byte[] getBytes(InputStream in) throws IOException {
        FastByteArrayOutputStream out = new FastByteArrayOutputStream(4096);
        IOUtils.copy(in, (OutputStream)out);
        return out.toByteArray();
    }

    public static void closeQuietly(Closeable channel) {
        if (channel != null) {
            try {
                channel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(Closeable ... channels) {
        for (Closeable c : channels) {
            if (c == null) continue;
            try {
                c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeAndRethrow(Exception e, Closeable ... channels) throws IllegalStateException {
        IOUtils.closeQuietly(channels);
        throw new IllegalStateException(e);
    }

    public static void schduleCloseQuietly(Timer timer, long delay, final Closeable ... channels) {
        if (delay == 0L) {
            IOUtils.closeQuietly(channels);
            return;
        }
        TimerTask cancel = new TimerTask(){

            @Override
            public void run() {
                IOUtils.closeQuietly(channels);
            }
        };
        timer.schedule(cancel, delay);
    }

    public static void schduleCloseQuietly(ScheduledExecutorService sched, int delay, final AtomicInteger activeCount, final Closeable ... channels) {
        if (delay == 0) {
            IOUtils.closeQuietly(channels);
            return;
        }
        Runnable cancel = new Runnable(){

            @Override
            public void run() {
                if (activeCount.get() < 1) {
                    IOUtils.closeQuietly(channels);
                }
            }
        };
        sched.schedule(cancel, (long)delay, TimeUnit.MILLISECONDS);
    }

    public static void writeBytes(@Nullable byte[] b, DataOutput out) throws IOException {
        if (b == null) {
            out.writeInt(-1);
            return;
        }
        int len = b.length;
        out.writeInt(len);
        out.write(b, 0, len);
    }

    public static void writeBytes(@Nullable byte[] b, FastBufferedOutputStream out) throws IOException {
        if (b == null) {
            IOUtils.writeInt(-1, out);
            return;
        }
        int len = b.length;
        IOUtils.writeInt(len, out);
        out.write(b, 0, len);
    }

    @Nullable
    public static byte[] readBytes(DataInput in) throws IOException {
        int len = in.readInt();
        if (len == -1) {
            return null;
        }
        byte[] b = new byte[len];
        in.readFully(b, 0, len);
        return b;
    }

    @Nullable
    public static byte[] readBytes(FastBufferedInputStream in) throws IOException {
        int len = IOUtils.readInt(in);
        if (len == -1) {
            return null;
        }
        byte[] b = new byte[len];
        in.read(b, 0, len);
        return b;
    }

    public static void writeString(@Nullable String s, ObjectOutputStream out) throws IOException {
        IOUtils.writeString(s, (DataOutput)out);
    }

    public static void writeString(@Nullable String s, DataOutputStream out) throws IOException {
        IOUtils.writeString(s, (DataOutput)out);
    }

    public static void writeString(@Nullable String s, DataOutput out) throws IOException {
        if (s == null) {
            out.writeInt(-1);
            return;
        }
        int len = s.length();
        out.writeInt(len);
        for (int i = 0; i < len; ++i) {
            char v = s.charAt(i);
            out.writeChar(v);
        }
    }

    public static void writeString(@Nullable String s, OutputStream out) throws IOException {
        if (s == null) {
            IOUtils.writeInt(-1, out);
            return;
        }
        int len = s.length();
        IOUtils.writeInt(len, out);
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            IOUtils.writeChar(c, out);
        }
    }

    @Nullable
    public static String readString(@Nonnull ObjectInputStream in) throws IOException {
        return IOUtils.readString((DataInput)in);
    }

    @Nullable
    public static String readString(@Nonnull DataInputStream in) throws IOException {
        return IOUtils.readString((DataInput)in);
    }

    @Nullable
    public static String readString(@Nonnull DataInput in) throws IOException {
        int len = in.readInt();
        if (len == -1) {
            return null;
        }
        char[] ch = new char[len];
        for (int i = 0; i < len; ++i) {
            ch[i] = in.readChar();
        }
        return new String(ch);
    }

    @Nullable
    public static String readString(@Nonnull InputStream in) throws IOException {
        int len = IOUtils.readInt(in);
        if (len == -1) {
            return null;
        }
        char[] ch = new char[len];
        for (int i = 0; i < len; ++i) {
            ch[i] = IOUtils.readChar(in);
        }
        return new String(ch);
    }
}

