/*
 * Decompiled with CFR 0.152.
 */
package btree4j.utils.lang;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Random;

public final class ArrayUtils {
    public static final int INDEX_NOT_FOUND = -1;

    private ArrayUtils() {
    }

    public static int getLength(Object array) {
        if (array == null) {
            return 0;
        }
        return Array.getLength(array);
    }

    public static <T> int indexOf(T[] array, T value) {
        int alen = array.length;
        for (int i = 0; i < alen; ++i) {
            if (!value.equals(array[i])) continue;
            return i;
        }
        return -1;
    }

    public static <T> int indexOf(T[] array, T value, int startIndex) {
        int alen = array.length;
        for (int i = startIndex; i < alen; ++i) {
            if (!value.equals(array[i])) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(int[] array, int value) {
        int alen = array.length;
        for (int i = 0; i < alen; ++i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(int[] array, int valueToFind, int startIndex, int endIndex) {
        if (array == null) {
            return -1;
        }
        int til = Math.min(endIndex, array.length);
        if (startIndex < 0 || startIndex > til) {
            throw new IllegalArgumentException("Illegal startIndex: " + startIndex);
        }
        for (int i = startIndex; i < til; ++i) {
            if (valueToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(byte[] array, byte valueToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        for (int i = startIndex; i < array.length; ++i) {
            if (valueToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndex(Object array) {
        return ArrayUtils.getLength(array) - 1;
    }

    public static <T> T[] insert(Object array, int index, Object element) {
        if (array == null) {
            if (index != 0) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Length: 0");
            }
            Object joinedArray = Array.newInstance(element != null ? element.getClass() : Object.class, 1);
            Array.set(joinedArray, 0, element);
            return (Object[])joinedArray;
        }
        int length = ArrayUtils.getLength(array);
        if (index > length || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + length);
        }
        Object result = Array.newInstance(array.getClass().getComponentType(), length + 1);
        System.arraycopy(array, 0, result, 0, index);
        Array.set(result, index, element);
        if (index < length) {
            System.arraycopy(array, index, result, index + 1, length - index);
        }
        return (Object[])result;
    }

    public static long[] insert(long[] array, long element) {
        long[] newArray = (long[])ArrayUtils.copyArrayGrow1(array, Long.TYPE);
        newArray[ArrayUtils.lastIndex((Object)newArray)] = element;
        return newArray;
    }

    public static long[] insert(long[] vals, int idx, long val) {
        long[] newVals = new long[vals.length + 1];
        if (idx > 0) {
            System.arraycopy(vals, 0, newVals, 0, idx);
        }
        newVals[idx] = val;
        if (idx < vals.length) {
            System.arraycopy(vals, idx, newVals, idx + 1, vals.length - idx);
        }
        return newVals;
    }

    public static byte[][] insert(byte[][] vals, int idx, byte[] val) {
        byte[][] newVals = new byte[vals.length + 1][];
        if (idx > 0) {
            System.arraycopy(vals, 0, newVals, 0, idx);
        }
        newVals[idx] = val;
        if (idx < vals.length) {
            System.arraycopy(vals, idx, newVals, idx + 1, vals.length - idx);
        }
        return newVals;
    }

    public static byte[] append(byte[] b1, byte[] b2) {
        byte[] nb = new byte[b1.length + b2.length];
        if (b1.length > 0) {
            System.arraycopy(b1, 0, nb, 0, b1.length);
        }
        if (b2.length > 0) {
            System.arraycopy(b2, 0, nb, b1.length, b2.length);
        }
        return nb;
    }

    public static int[] append(int[] left, int[] right) {
        int[] n = new int[left.length + right.length];
        if (left.length > 0) {
            System.arraycopy(left, 0, n, 0, left.length);
        }
        if (right.length > 0) {
            System.arraycopy(right, 0, n, left.length, right.length);
        }
        return n;
    }

    public static <T> T[] remove(T[] array, int index) {
        int length = ArrayUtils.getLength(array);
        if (index < 0 || index >= length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + length);
        }
        Object result = Array.newInstance(array.getClass().getComponentType(), length - 1);
        System.arraycopy(array, 0, result, 0, index);
        if (index < length - 1) {
            System.arraycopy(array, index + 1, result, index, length - index - 1);
        }
        return (Object[])result;
    }

    public static <T> T[] remove(T[] array, int from, int to) {
        assert (to >= from) : to + " - " + from;
        int length = ArrayUtils.getLength(array);
        if (from < 0 || to >= length) {
            throw new IndexOutOfBoundsException("from: " + from + ", to: " + to + ", Length: " + length);
        }
        int remsize = to - from + 1;
        Object result = Array.newInstance(array.getClass().getComponentType(), length - remsize);
        System.arraycopy(array, 0, result, 0, from);
        if (to < length - 1) {
            System.arraycopy(array, to + 1, result, from, length - to - 1);
        }
        return (Object[])result;
    }

    public static long[] remove(long[] vals, int idx) {
        long[] newVals = new long[vals.length - 1];
        if (idx > 0) {
            System.arraycopy(vals, 0, newVals, 0, idx);
        }
        if (idx < newVals.length) {
            System.arraycopy(vals, idx + 1, newVals, idx, newVals.length - idx);
        }
        return newVals;
    }

    public static long[] remove(long[] vals, int from, int to) {
        int remsize = to - from + 1;
        long[] newVals = new long[vals.length - remsize];
        if (from > 0) {
            System.arraycopy(vals, 0, newVals, 0, from);
        }
        if (to < newVals.length) {
            System.arraycopy(vals, to + 1, newVals, from, newVals.length - to);
        }
        return newVals;
    }

    private static Object copyArrayGrow1(Object array, Class<?> newArrayComponentType) {
        if (array != null) {
            int arrayLength = Array.getLength(array);
            Object newArray = Array.newInstance(array.getClass().getComponentType(), arrayLength + 1);
            System.arraycopy(array, 0, newArray, 0, arrayLength);
            return newArray;
        }
        return Array.newInstance(newArrayComponentType, 1);
    }

    public static boolean equals(char[] a, char[] a2, int off, int len) {
        if (a == a2) {
            return true;
        }
        if (a == null || a2 == null) {
            return false;
        }
        int length = a.length;
        if (len != length) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (a[i] == a2[off + i]) continue;
            return false;
        }
        return true;
    }

    public static <T extends Comparable<T>> int binarySearch(T[] a, int fromIndex, int toIndex, T key) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            T midVal = a[mid];
            int cmp = midVal.compareTo(key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static void reverse(int[] ary) {
        if (ary == null) {
            return;
        }
        int i = 0;
        for (int j = ary.length - 1; j > i; --j, ++i) {
            int tmp = ary[j];
            ary[j] = ary[i];
            ary[i] = tmp;
        }
    }

    public static int[] reverseTo(int[] ary) {
        if (ary == null) {
            return null;
        }
        int[] b = new int[ary.length];
        for (int i = 0; i < ary.length; ++i) {
            b[ary.length - i - 1] = ary[i];
        }
        return b;
    }

    public static Object resize(Object[] ary, int length) {
        Object newary = Array.newInstance(ary.getClass().getComponentType(), length);
        int copysize = length > ary.length ? length : ary.length;
        System.arraycopy(ary, 0, newary, 0, copysize);
        return newary;
    }

    public static byte[] resize(byte[] ary, int length) {
        byte[] newary = new byte[length];
        int copysize = length > ary.length ? ary.length : length;
        System.arraycopy(ary, 0, newary, 0, copysize);
        return newary;
    }

    public static boolean startsWith(byte[] target, byte[] prefix) {
        int testlen = prefix.length;
        if (target.length < testlen) {
            return false;
        }
        for (int i = 0; i < testlen; ++i) {
            if (target[i] == prefix[i]) continue;
            return false;
        }
        return true;
    }

    public static int compareTo(byte[] lhs, byte[] rhs) {
        if (lhs == rhs) {
            return 0;
        }
        int len = Math.min(lhs.length, rhs.length);
        for (int i = 0; i < len; ++i) {
            if (lhs[i] == rhs[i]) continue;
            return (lhs[i] & 0xFF) - (rhs[i] & 0xFF);
        }
        return lhs.length - rhs.length;
    }

    public static int compareTo(byte[] lhs, byte[] rhs, int offset) {
        int len = Math.min(lhs.length, rhs.length);
        for (int i = offset; i < len; ++i) {
            if (lhs[i] == rhs[i]) continue;
            return (lhs[i] & 0xFF) - (rhs[i] & 0xFF);
        }
        return lhs.length - rhs.length;
    }

    public static int compareTo(byte[] lhs, byte[] rhs, int offset, int length) {
        int tolen = offset + length;
        int limit = Math.min(Math.min(lhs.length, rhs.length), tolen);
        for (int i = offset; i < limit; ++i) {
            if (lhs[i] == rhs[i]) continue;
            return (lhs[i] & 0xFF) - (rhs[i] & 0xFF);
        }
        return 0;
    }

    public static int compareTo(byte[] b1, int off1, int len1, byte[] b2, int off2, int len2) {
        for (int i = 0; i < len1 && i < len2; ++i) {
            int d = (b1[off1 + i] & 0xFF) - (b2[off2 + i] & 0xFF);
            if (d == 0) continue;
            return d;
        }
        return len1 - len2;
    }

    public static int compareTo(int[] lhs, int[] rhs) {
        if (lhs == rhs) {
            return 0;
        }
        int len = Math.min(lhs.length, rhs.length);
        for (int i = 0; i < len; ++i) {
            if (lhs[i] == rhs[i]) continue;
            return lhs[i] - rhs[i];
        }
        return lhs.length - rhs.length;
    }

    public static <T> boolean contains(T[] array, T value) {
        int len = array.length;
        for (int i = 0; i < len; ++i) {
            if (!array[i].equals(value)) continue;
            return true;
        }
        return false;
    }

    public static int longestCommonPrefix(byte[] ary, byte[] root) {
        int limit = Math.min(ary.length, root.length);
        for (int i = 0; i < limit; ++i) {
            if (ary[i] == root[i]) continue;
            return i;
        }
        return limit;
    }

    public static void shuffle(Object[] array) {
        Random r = new Random();
        int limit = array.length;
        for (int i = 0; i < limit; ++i) {
            ArrayUtils.swap(array, i, r.nextInt(limit));
        }
    }

    public static void shuffle(int[] array) {
        Random r = new Random();
        int limit = array.length;
        for (int i = 0; i < limit; ++i) {
            ArrayUtils.swap(array, i, r.nextInt(limit));
        }
    }

    public static void shuffle(Object[] array, long seed) {
        Random r = new Random(seed);
        int limit = array.length;
        for (int i = 0; i < limit; ++i) {
            ArrayUtils.swap(array, i, r.nextInt(limit));
        }
    }

    public static void swap(Object[] array, int i, int j) {
        Object o = array[i];
        array[i] = array[j];
        array[j] = o;
    }

    public static void swap(int[] array, int i, int j) {
        int o = array[i];
        array[i] = array[j];
        array[j] = o;
    }

    public static double max(double[] array) {
        double d = Double.MIN_VALUE;
        for (int i = 0; i < array.length; ++i) {
            d = Math.max(array[i], d);
        }
        return d;
    }

    public static <T> T max(T[] array, double[] scores) {
        if (array.length != scores.length) {
            throw new IllegalArgumentException("array.length(" + array.length + ") != scores.length(" + scores.length + ")");
        }
        T obj = null;
        double d = Double.MIN_VALUE;
        for (int i = 0; i < scores.length; ++i) {
            double score = scores[i];
            if (!(score > d)) continue;
            d = score;
            obj = array[i];
        }
        return obj;
    }

    public static int minIndex(float[] scores) {
        int index = -1;
        float min = Float.MAX_VALUE;
        for (int i = 0; i < scores.length; ++i) {
            float f = scores[i];
            if (!(f < min)) continue;
            min = f;
            index = i;
        }
        return index;
    }

    public static <T> Class<T[]> getArrayClass(Class<T> clazz) {
        Object array = Array.newInstance(clazz, 0);
        return array.getClass();
    }

    public static <T> T[] toArray(Collection<T> c, Class<? extends T[]> newType) {
        int length = c.size();
        Object[] array = (Object[])Array.newInstance(newType.getComponentType(), length);
        if (length > 0) {
            int i = 0;
            for (T elem : c) {
                array[i++] = elem;
            }
        }
        return array;
    }

    public static byte[][] toArray(Collection<byte[]> c) {
        int length = c.size();
        byte[][] array = new byte[length][];
        if (length > 0) {
            int i = 0;
            for (byte[] b : c) {
                array[i++] = b;
            }
        }
        return array;
    }
}

