/*
 * Decompiled with CFR 0.152.
 */
package btree4j.utils.lang;

import javax.annotation.Nonnegative;

public final class HashUtils {
    private HashUtils() {
    }

    public static boolean isPowerOfTwo(int x) {
        if (x < 1) {
            return false;
        }
        return (x & x - 1) == 0;
    }

    public static boolean isPowerOfTwo(long x) {
        if (x < 1L) {
            return false;
        }
        return (x & x - 1L) == 0L;
    }

    public static int nextPowerOfTwo(int targetSize) {
        return HashUtils.nextPowerOfTwo(1, targetSize);
    }

    public static int nextPowerOfTwo(int minSizeLog, int targetSize) {
        int i = minSizeLog;
        while (1 << i < targetSize) {
            ++i;
        }
        return 1 << i;
    }

    public static int shiftsForNextPowerOfTwo(int targetSize) {
        int i = 0;
        while (1 << i < targetSize) {
            ++i;
        }
        return i;
    }

    public static int hashCode(long l) {
        return (int)(l ^ l >>> 32);
    }

    public static int hashCode(char[] ch, int offset, int length) {
        if (ch == null) {
            return 0;
        }
        int result = 1;
        int limit = offset + length;
        for (int i = offset; i < limit; ++i) {
            result = 31 * result + ch[i];
        }
        return result;
    }

    public static int hashCode(byte[] b) {
        return HashUtils.hashCode(b, 0, b.length);
    }

    public static int hashCode(byte[] b, int offset, int length) {
        if (b == null) {
            return 0;
        }
        int result = 1;
        int limit = offset + length;
        for (int i = offset; i < limit; ++i) {
            result = 31 * result + b[i];
        }
        return result;
    }

    public static final int hash(Thread thrd, int max) {
        int index;
        long id = thrd.getId();
        int hash = ((int)(id ^ id >>> 32) ^ 0x811C9DC5) * 16777619;
        int nbits = -1024 >> max & 4 | 504 >>> max & 2 | -65294 >>> max & 1;
        while ((index = hash & (1 << nbits) - 1) > max) {
            hash = hash >>> nbits | hash << 33 - nbits;
        }
        return index;
    }

    public static final int hash(Thread thrd) {
        int h = System.identityHashCode(thrd);
        h ^= h >>> 20 ^ h >>> 12;
        h ^= h >>> 7 ^ h >>> 4;
        return h << 2;
    }

    public static final int xorFolding32(long hash) {
        return (int)(hash >>> 32) ^ (int)hash;
    }

    public static long xorFolding32(long hash, int shift) {
        long mask = (1L << shift) - 1L;
        return hash >> shift ^ hash & mask;
    }

    public static long xorFolding(long hash, int shift) {
        long mask = (1L << shift) - 1L;
        if (shift < 16) {
            return (hash >> shift ^ hash) & mask;
        }
        return hash >> shift ^ hash & mask;
    }

    @Nonnegative
    public static int positiveXorFolding(int hash, int shift) {
        if (shift > 31) {
            throw new IllegalArgumentException("Illegal shift for 32-bits value: " + shift);
        }
        int mask = (1 << shift) - 1;
        if (shift < 16) {
            return (hash >> shift ^ hash) & mask;
        }
        return hash >>> shift ^ hash & mask;
    }
}

