/*
 * Decompiled with CFR 0.152.
 */
package btree4j.utils.lang;

import btree4j.utils.io.FileUtils;
import java.io.File;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.Date;

public final class PrintUtils {
    private static final int TRACE_CAUSE_DEPTH = 5;
    private static boolean E_ALL_ON_FATAL = true;

    private PrintUtils() {
    }

    public static void prettyPrintStackTrace(Throwable throwable, PrintStream out) {
        String s = PrintUtils.prettyPrintStackTrace(throwable);
        out.print(s);
    }

    public static String prettyPrintStackTrace(Throwable throwable) {
        return PrintUtils.prettyPrintStackTrace(throwable, 5);
    }

    public static String prettyPrintStackTrace(Throwable throwable, int traceDepth) {
        StringBuilder out = new StringBuilder(512);
        out.append(PrintUtils.getMessage(throwable));
        out.append("\n\n---- Debugging information ----");
        int tracedepth = E_ALL_ON_FATAL && (throwable instanceof RuntimeException || throwable instanceof Error) ? -1 : traceDepth;
        String captured = PrintUtils.captureThrownWithStrackTrace(throwable, "trace-exception", tracedepth);
        out.append(captured);
        Throwable cause = throwable.getCause();
        if (cause != null) {
            Throwable rootCause = PrintUtils.getRootCause(cause);
            captured = PrintUtils.captureThrownWithStrackTrace(rootCause, "trace-cause", 5);
            out.append(captured);
        }
        out.append("\n------------------------------- \n");
        return out.toString();
    }

    private static String captureThrownWithStrackTrace(Throwable throwable, String label, int traceDepth) {
        int at;
        assert (traceDepth >= 1 || traceDepth == -1);
        StringBuilder out = new StringBuilder(255);
        String clazz = throwable.getClass().getName();
        out.append(String.format("\n%-20s: %s \n", "* " + label, clazz));
        StackTraceElement[] st = throwable.getStackTrace();
        int limit = traceDepth == -1 ? st.length - 1 : traceDepth;
        for (at = 0; at < st.length; ++at) {
            if (at >= limit) {
                out.append("\t...\n");
                break;
            }
            out.append("\tat " + st[at] + '\n');
        }
        if (st.length == 0) {
            out.append("\t no stack traces...");
        } else if (at != st.length - 1) {
            out.append("\tat " + st[st.length - 1]);
        }
        String errmsg = throwable.getMessage();
        if (errmsg != null) {
            out.append(String.format("\n%-20s: \n", "* " + label + "-error-msg"));
            String[] line = errmsg.split("\n");
            int maxlines = Math.min(line.length, Math.max(1, 3));
            for (int i = 0; i < maxlines; ++i) {
                out.append('\t');
                out.append(line[i]);
                if (i == maxlines - 1) continue;
                out.append('\n');
            }
        }
        return out.toString();
    }

    public static String getMessage(Throwable throwable) {
        assert (throwable != null);
        String errMsg = throwable.getMessage();
        String clazz = throwable.getClass().getName();
        return errMsg != null ? clazz + ": " + errMsg : clazz;
    }

    public static String getOneLineMessage(Throwable throwable) {
        String lines = PrintUtils.getMessage(throwable);
        int last = lines.indexOf(10);
        if (last == -1) {
            last = lines.length();
        }
        return lines.substring(0, last);
    }

    private static Throwable getRootCause(Throwable throwable) {
        Throwable parent;
        assert (throwable != null);
        Throwable top = throwable;
        while (top != null && (parent = top.getCause()) != null) {
            top = parent;
        }
        return top;
    }

    public static void printClassHierarchy(PrintStream out, Class<?> clazz) {
        StringBuilder sbuf = new StringBuilder(64);
        for (Class<?> sc = clazz; sc != null; sc = sc.getSuperclass()) {
            String space = sbuf.toString();
            out.println(space + sc.getName());
            Class<?>[] ifs = sc.getInterfaces();
            for (int i = 0; i < ifs.length; ++i) {
                out.println(space + "  implements: " + ifs[i].getName());
            }
            sbuf.append(' ');
        }
    }

    public static void printClassLoaderHierarchy(PrintStream out, Class<?> clazz) {
        StringBuilder sbuf = new StringBuilder(32);
        for (ClassLoader curr_cl = clazz.getClass().getClassLoader(); curr_cl != null; curr_cl = curr_cl.getParent()) {
            out.println(sbuf.toString() + curr_cl.getClass().getName());
            sbuf.append(' ');
        }
    }

    public static void printMemoryUsage(PrintStream out) {
        out.println("[MemoryUsage] " + new Date(System.currentTimeMillis()).toString() + " - Total: " + Runtime.getRuntime().totalMemory() + "byte , Free: " + Runtime.getRuntime().freeMemory() + "byte");
    }

    public static String prettyFileSize(long size) {
        if (size < 0L) {
            return "N/A";
        }
        if (size < 1024L) {
            return size + " bytes";
        }
        float kb = (float)size / 1024.0f;
        if (kb < 1024.0f) {
            return String.format("%.1f KB", Float.valueOf(kb));
        }
        float mb = kb / 1024.0f;
        if (mb < 1024.0f) {
            return String.format("%.1f MB", Float.valueOf(mb));
        }
        float gb = mb / 1024.0f;
        return String.format("%.2f GB", Float.valueOf(gb));
    }

    public static String prettyFileSize(File file) {
        return PrintUtils.prettyFileSize(FileUtils.getFileSize(file));
    }

    public static float toPercent(double v) {
        return (float)(v * 100.0);
    }

    public static String toPercentString(float v) {
        String p = String.valueOf(v * 100.0f);
        int ix = p.indexOf(46) + 1;
        String percent = p.substring(0, ix) + p.substring(ix, ix + 1);
        return percent + '%';
    }

    public static String toPercentString(double v) {
        String p = String.valueOf(v * 100.0);
        int ix = p.indexOf(46) + 1;
        String percent = p.substring(0, ix) + p.substring(ix, ix + 1);
        return percent + '%';
    }

    public static String toString(StackTraceElement[] trace) {
        int depth = trace.length;
        if (depth == 0) {
            return "\t no stack traces...";
        }
        StringBuilder buf = new StringBuilder(512);
        for (int i = 0; i < depth; ++i) {
            buf.append("\tat ");
            buf.append(trace[i]);
            buf.append('\n');
        }
        return buf.toString();
    }

    public static String toString(StackTraceElement[] trace, int maxDepth) {
        if (trace.length == 0) {
            return "\t no stack traces...";
        }
        StringBuilder buf = new StringBuilder(512);
        int depth = Math.min(trace.length, maxDepth);
        for (int i = 0; i < depth; ++i) {
            buf.append("\tat ");
            buf.append(trace[i]);
            buf.append('\n');
        }
        return buf.toString();
    }

    public static String formatNumber(long number) {
        DecimalFormat f = new DecimalFormat("#,###");
        return f.format(number);
    }

    public static String formatNumber(double number) {
        return PrintUtils.formatNumber(number, true);
    }

    public static String formatNumber(double number, boolean commaSep) {
        DecimalFormat f = new DecimalFormat(commaSep ? "#,###.###" : "###.###");
        f.setDecimalSeparatorAlwaysShown(false);
        return f.format(number);
    }
}

