/*
 * Decompiled with CFR 0.152.
 */
package btree4j.utils.lang;

import btree4j.utils.lang.Primitives;

public final class StringUtils {
    private static final float KBYTES = 1024.0f;
    private static final float MBYTES = 1048576.0f;
    private static final float GBYTES = 1.0737418E9f;
    private static final char[] HEX_DIGITS = "0123456789ABCDEF".toCharArray();
    private static final int UPPER_NIBBLE_MASK = 240;
    private static final int LOWER_NIBBLE_MASK = 15;

    public static String toBitString(double d) {
        char[] bit = new char[64];
        long dd = Double.doubleToLongBits(d);
        long mask = 1L;
        for (int i = 0; i < 64; ++i) {
            long bitval = dd & mask;
            bit[63 - i] = bitval == 0L ? 48 : 49;
            mask <<= 1;
        }
        return String.valueOf(bit);
    }

    public static String toBitString(float f) {
        char[] bit = new char[32];
        int ff = Float.floatToIntBits(f);
        int mask = 1;
        for (int i = 0; i < 32; ++i) {
            int bitval = ff & mask;
            bit[31 - i] = bitval == 0 ? 48 : 49;
            mask <<= 1;
        }
        return String.valueOf(bit);
    }

    public static String toBitString(long n) {
        char[] bit = new char[64];
        long mask = 1L;
        for (int i = 0; i < 64; ++i) {
            long bitval = n & mask;
            bit[63 - i] = bitval == 0L ? 48 : 49;
            mask <<= 1;
        }
        return String.valueOf(bit);
    }

    public static String toBitString(int n) {
        char[] bit = new char[32];
        int mask = 1;
        for (int i = 0; i < 32; ++i) {
            int bitval = n & mask;
            bit[31 - i] = bitval == 0 ? 48 : 49;
            mask <<= 1;
        }
        return String.valueOf(bit);
    }

    public static String toBitString(byte[] b) {
        char[] bits = new char[8 * b.length];
        for (int i = 0; i < b.length; ++i) {
            byte byteval = b[i];
            int bytei = i << 3;
            int mask = 1;
            for (int j = 7; j >= 0; --j) {
                int bitval = byteval & mask;
                bits[bytei + j] = bitval == 0 ? 48 : 49;
                mask <<= 1;
            }
        }
        return String.valueOf(bits);
    }

    public static String strip(String src, String stripChars) {
        return (String)StringUtils.strip((CharSequence)src, stripChars);
    }

    public static CharSequence strip(CharSequence src, String stripChars) {
        if (src == null || src.length() == 0) {
            return src;
        }
        CharSequence striped = StringUtils.stripStart(src, stripChars);
        return StringUtils.stripEnd(striped, stripChars);
    }

    public static CharSequence stripStart(CharSequence src, String stripChars) {
        int start;
        int srclen;
        if (src == null || (srclen = src.length()) == 0) {
            return src;
        }
        if (stripChars == null) {
            for (start = 0; start != srclen && Character.isWhitespace(src.charAt(start)); ++start) {
            }
        } else {
            if (stripChars.length() == 0) {
                return src;
            }
            while (start != srclen && stripChars.indexOf(src.charAt(start)) != -1) {
                ++start;
            }
        }
        return src.subSequence(start, srclen);
    }

    public static CharSequence stripEnd(CharSequence src, String stripChars) {
        int end;
        if (src == null || (end = src.length()) == 0) {
            return src;
        }
        if (stripChars == null) {
            while (end != 0 && Character.isWhitespace(src.charAt(end - 1))) {
                --end;
            }
        } else {
            if (stripChars.length() == 0) {
                return src;
            }
            while (end != 0 && stripChars.indexOf(src.charAt(end - 1)) != -1) {
                --end;
            }
        }
        return src.subSequence(0, end);
    }

    public static boolean isNumber(String str) {
        int i;
        int start;
        if (str == null || str.length() == 0) {
            return false;
        }
        char[] chars = str.toCharArray();
        int sz = chars.length;
        boolean hasExp = false;
        boolean hasDecPoint = false;
        boolean allowSigns = false;
        boolean foundDigit = false;
        int n = start = chars[0] == '-' ? 1 : 0;
        if (sz > start + 1 && chars[start] == '0' && chars[start + 1] == 'x') {
            int i2 = start + 2;
            if (i2 == sz) {
                return false;
            }
            while (i2 < chars.length) {
                if (!(chars[i2] >= '0' && chars[i2] <= '9' || chars[i2] >= 'a' && chars[i2] <= 'f' || chars[i2] >= 'A' && chars[i2] <= 'F')) {
                    return false;
                }
                ++i2;
            }
            return true;
        }
        --sz;
        for (i = start; i < sz || i < sz + 1 && allowSigns && !foundDigit; ++i) {
            if (chars[i] >= '0' && chars[i] <= '9') {
                foundDigit = true;
                allowSigns = false;
                continue;
            }
            if (chars[i] == '.') {
                if (hasDecPoint || hasExp) {
                    return false;
                }
                hasDecPoint = true;
                continue;
            }
            if (chars[i] == 'e' || chars[i] == 'E') {
                if (hasExp) {
                    return false;
                }
                if (!foundDigit) {
                    return false;
                }
                hasExp = true;
                allowSigns = true;
                continue;
            }
            if (chars[i] == '+' || chars[i] == '-') {
                if (!allowSigns) {
                    return false;
                }
                allowSigns = false;
                foundDigit = false;
                continue;
            }
            return false;
        }
        if (i < chars.length) {
            if (chars[i] >= '0' && chars[i] <= '9') {
                return true;
            }
            if (chars[i] == 'e' || chars[i] == 'E') {
                return false;
            }
            if (!(allowSigns || chars[i] != 'd' && chars[i] != 'D' && chars[i] != 'f' && chars[i] != 'F')) {
                return foundDigit;
            }
            if (chars[i] == 'l' || chars[i] == 'L') {
                return foundDigit && !hasExp;
            }
            return false;
        }
        return !allowSigns && foundDigit;
    }

    public static boolean equals(String trg, char[] ch, int offset, int length) {
        assert (trg != null && ch != null);
        int trglen = trg.length();
        if (trglen != length) {
            return false;
        }
        for (int i = offset; i < length; ++i) {
            char tc = trg.charAt(0);
            if (tc == ch[offset + 1]) continue;
            return false;
        }
        return true;
    }

    public static char[] getChars(String s) {
        int len = s.length();
        char[] dst = new char[len];
        s.getChars(0, len, dst, 0);
        return dst;
    }

    public static byte[] getBytes(String s) {
        int len = s.length();
        byte[] b = new byte[len * 2];
        for (int i = 0; i < len; ++i) {
            Primitives.putChar(b, i * 2, s.charAt(i));
        }
        return b;
    }

    public static byte[][] toBytes(String[] args) {
        int len = args.length;
        byte[][] b = new byte[len][];
        for (int i = 0; i < len; ++i) {
            b[i] = StringUtils.getBytes(args[i]);
        }
        return b;
    }

    public static String toString(byte[] b) {
        return StringUtils.toString(b, 0, b.length);
    }

    public static String toString(byte[] b, int off, int len) {
        int clen = len >>> 1;
        char[] c = new char[clen];
        for (int i = 0; i < clen; ++i) {
            int j = off + (i << 1);
            c[i] = (char)((b[j + 1] & 0xFF) + (b[j + 0] << 8));
        }
        return new String(c);
    }

    public static String displayBytesSize(long n) {
        String size;
        long abs = Math.abs(n);
        if ((float)abs < 1024.0f) {
            size = n + " bytes";
        } else if ((float)abs < 1048576.0f) {
            size = String.format("%.2f", Float.valueOf((float)n / 1024.0f)) + " kB";
        } else if ((float)abs < 1.0737418E9f) {
            size = String.format("%.2f", Float.valueOf((float)n / 1048576.0f)) + " MB";
        } else {
            return String.format("%.2f", Float.valueOf((float)n / 1.0737418E9f)) + " GB";
        }
        return size;
    }

    public static void encodeHex(byte b, StringBuilder buf) {
        int upper = (b & 0xF0) >> 4;
        int lower = b & 0xF;
        buf.append(HEX_DIGITS[upper]);
        buf.append(HEX_DIGITS[lower]);
    }

    public static String encodeHex(byte[] buf) {
        int buflen = buf.length;
        char[] ch = new char[buflen * 2];
        int i = 0;
        int j = 0;
        while (i < buf.length) {
            byte b = buf[i];
            int upper = (b & 0xF0) >> 4;
            int lower = b & 0xF;
            ch[j] = HEX_DIGITS[upper];
            ch[j + 1] = HEX_DIGITS[lower];
            ++i;
            j += 2;
        }
        return new String(ch);
    }

    public static byte[] decodeHex(char[] data) {
        int len = data.length;
        if ((len & 1) != 0) {
            throw new IllegalArgumentException("Illegal HexaDecimal character");
        }
        byte[] out = new byte[len >> 1];
        int i = 0;
        int j = 0;
        while (j < len) {
            int f = StringUtils.hexToDigit(data[j], j) << 4;
            f |= StringUtils.hexToDigit(data[++j], j);
            ++j;
            out[i] = (byte)(f & 0xFF);
            ++i;
        }
        return out;
    }

    private static int hexToDigit(char ch, int index) {
        int digit = Character.digit(ch, 16);
        if (digit == -1) {
            throw new IllegalArgumentException("Illegal HexaDecimal character '" + ch + "' at index " + index);
        }
        return digit;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static int countMatches(String str, String sub) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(sub)) {
            return 0;
        }
        int count = 0;
        int idx = 0;
        while ((idx = str.indexOf(sub, idx)) != -1) {
            ++count;
            idx += sub.length();
        }
        return count;
    }

    public static int countMatches(String str, char c) {
        if (StringUtils.isEmpty(str)) {
            return 0;
        }
        int count = 0;
        int size = str.length();
        for (int i = 0; i < size; ++i) {
            if (str.charAt(i) != c) continue;
            ++count;
        }
        return count;
    }

    public static int indexOf(String str, char ch, int nth) {
        if (nth < 1) {
            throw new IllegalArgumentException("nth must be greater than 0: " + nth);
        }
        int startPos = 0;
        for (int i = 0; i < nth; ++i) {
            if ((startPos = str.indexOf(ch, startPos)) != -1) continue;
            return -1;
        }
        return startPos;
    }

    public static String escape(String str) {
        int sz = str.length();
        StringBuilder buffer = new StringBuilder(2 * sz);
        block12: for (int i = 0; i < sz; ++i) {
            char ch = str.charAt(i);
            if (ch > '\u0fff') {
                buffer.append("\\u" + Integer.toHexString(ch));
                continue;
            }
            if (ch > '\u00ff') {
                buffer.append("\\u0" + Integer.toHexString(ch));
                continue;
            }
            if (ch > '\u007f') {
                buffer.append("\\u00" + Integer.toHexString(ch));
                continue;
            }
            if (ch < ' ') {
                switch (ch) {
                    case '\b': {
                        buffer.append('\\');
                        buffer.append('b');
                        break;
                    }
                    case '\n': {
                        buffer.append('\\');
                        buffer.append('n');
                        break;
                    }
                    case '\t': {
                        buffer.append('\\');
                        buffer.append('t');
                        break;
                    }
                    case '\f': {
                        buffer.append('\\');
                        buffer.append('f');
                        break;
                    }
                    case '\r': {
                        buffer.append('\\');
                        buffer.append('r');
                        break;
                    }
                    default: {
                        if (ch > '\u000f') {
                            buffer.append("\\u00" + Integer.toHexString(ch));
                            break;
                        }
                        buffer.append("\\u000" + Integer.toHexString(ch));
                        break;
                    }
                }
                continue;
            }
            switch (ch) {
                case '\'': {
                    buffer.append('\\');
                    buffer.append('\'');
                    continue block12;
                }
                case '\"': {
                    buffer.append('\\');
                    buffer.append('\"');
                    continue block12;
                }
                case '\\': {
                    buffer.append('\\');
                    buffer.append('\\');
                    continue block12;
                }
                default: {
                    buffer.append(ch);
                }
            }
        }
        return buffer.toString();
    }

    public static String escape(char ch) {
        if (ch > '\u0fff') {
            return "\\u" + Integer.toHexString(ch);
        }
        if (ch > '\u00ff') {
            return "\\u0" + Integer.toHexString(ch);
        }
        if (ch > '\u007f') {
            return "\\u00" + Integer.toHexString(ch);
        }
        if (ch < ' ') {
            switch (ch) {
                case '\b': {
                    return "\\b";
                }
                case '\n': {
                    return "\\n";
                }
                case '\t': {
                    return "\\t";
                }
                case '\f': {
                    return "\\f";
                }
                case '\r': {
                    return "\\r";
                }
            }
            if (ch > '\u000f') {
                return "\\u00" + Integer.toHexString(ch);
            }
            return "\\u000" + Integer.toHexString(ch);
        }
        switch (ch) {
            case '\'': {
                return "\\'";
            }
            case '\"': {
                return "\\\"";
            }
            case '\\': {
                return "\\\\";
            }
        }
        return new String(new char[]{ch});
    }

    public static void clear(StringBuilder buf) {
        buf.setLength(0);
    }

    public static StringBuilder deleteLastChar(StringBuilder buf) {
        int len = buf.length();
        if (len > 0) {
            buf.deleteCharAt(len - 1);
        }
        return buf;
    }

    public static StringBuilder replaceLastChar(StringBuilder buf, char ch) {
        int len = buf.length();
        if (len > 0) {
            buf.setCharAt(len - 1, ch);
        }
        return buf;
    }
}

