/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ja.neologd;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.analysis.ja.neologd.JapaneseTokenizer;
import org.apache.lucene.analysis.ja.neologd.dict.UserDictionary;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.apache.lucene.util.AttributeFactory;
import org.apache.lucene.util.IOUtils;

public class JapaneseTokenizerFactory
extends TokenizerFactory
implements ResourceLoaderAware {
    public static final String NAME = "japanese";
    private static final String MODE = "mode";
    private static final String USER_DICT_PATH = "userDictionary";
    private static final String USER_DICT_ENCODING = "userDictionaryEncoding";
    private static final String DISCARD_PUNCTUATION = "discardPunctuation";
    private static final String DISCARD_COMPOUND_TOKEN = "discardCompoundToken";
    private static final String NBEST_COST = "nBestCost";
    private static final String NBEST_EXAMPLES = "nBestExamples";
    private UserDictionary userDictionary;
    private final JapaneseTokenizer.Mode mode;
    private final boolean discardPunctuation;
    private final boolean discardCompoundToken;
    private final String userDictionaryPath;
    private final String userDictionaryEncoding;
    private final String nbestExamples;
    private int nbestCost = -1;

    public JapaneseTokenizerFactory(Map<String, String> args) {
        super(args);
        this.mode = JapaneseTokenizer.Mode.valueOf(this.get(args, MODE, JapaneseTokenizer.DEFAULT_MODE.toString()).toUpperCase(Locale.ROOT));
        this.userDictionaryPath = args.remove(USER_DICT_PATH);
        this.userDictionaryEncoding = args.remove(USER_DICT_ENCODING);
        this.discardPunctuation = this.getBoolean(args, DISCARD_PUNCTUATION, true);
        this.discardCompoundToken = this.getBoolean(args, DISCARD_COMPOUND_TOKEN, false);
        this.nbestCost = this.getInt(args, NBEST_COST, 0);
        this.nbestExamples = args.remove(NBEST_EXAMPLES);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    public void inform(ResourceLoader loader) throws IOException {
        if (this.userDictionaryPath != null) {
            try (InputStream stream = loader.openResource(this.userDictionaryPath);){
                String encoding = this.userDictionaryEncoding;
                if (encoding == null) {
                    encoding = IOUtils.UTF_8;
                }
                CharsetDecoder decoder = Charset.forName(encoding).newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
                InputStreamReader reader = new InputStreamReader(stream, decoder);
                this.userDictionary = UserDictionary.open(reader);
            }
        } else {
            this.userDictionary = null;
        }
    }

    public JapaneseTokenizer create(AttributeFactory factory) {
        JapaneseTokenizer t = new JapaneseTokenizer(factory, this.userDictionary, this.discardPunctuation, this.discardCompoundToken, this.mode);
        if (this.nbestExamples != null) {
            this.nbestCost = Math.max(this.nbestCost, t.calcNBestCost(this.nbestExamples));
        }
        t.setNBestCost(this.nbestCost);
        return t;
    }
}

