/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ja.neologd.util;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import org.apache.lucene.analysis.ja.neologd.dict.CharacterDefinition;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.OutputStreamDataOutput;

final class CharacterDefinitionWriter {
    private final byte[] characterCategoryMap = new byte[65536];
    private final boolean[] invokeMap = new boolean[CharacterDefinition.CLASS_COUNT];
    private final boolean[] groupMap = new boolean[CharacterDefinition.CLASS_COUNT];

    CharacterDefinitionWriter() {
        Arrays.fill(this.characterCategoryMap, CharacterDefinition.DEFAULT);
    }

    void putCharacterCategory(int codePoint, String characterClassName) {
        characterClassName = characterClassName.split(" ")[0];
        if (codePoint == 12539) {
            characterClassName = "SYMBOL";
        }
        this.characterCategoryMap[codePoint] = CharacterDefinition.lookupCharacterClass(characterClassName);
    }

    void putInvokeDefinition(String characterClassName, int invoke, int group, int length) {
        byte characterClass = CharacterDefinition.lookupCharacterClass(characterClassName);
        this.invokeMap[characterClass] = invoke == 1;
        this.groupMap[characterClass] = group == 1;
    }

    public void write(Path baseDir) throws IOException {
        Path path = baseDir.resolve(CharacterDefinition.class.getName().replace('.', '/') + ".dat");
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        try (BufferedOutputStream os = new BufferedOutputStream(Files.newOutputStream(path, new OpenOption[0]));){
            OutputStreamDataOutput out = new OutputStreamDataOutput((OutputStream)os);
            CodecUtil.writeHeader((DataOutput)out, (String)"kuromoji_cd", (int)1);
            out.writeBytes(this.characterCategoryMap, 0, this.characterCategoryMap.length);
            for (int i = 0; i < CharacterDefinition.CLASS_COUNT; ++i) {
                byte b = (byte)((this.invokeMap[i] ? 1 : 0) | (this.groupMap[i] ? 2 : 0));
                out.writeByte(b);
            }
        }
    }
}

