/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ja.neologd.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.lucene.analysis.ja.neologd.util.CSVUtil;
import org.apache.lucene.analysis.ja.neologd.util.DictionaryBuilder;
import org.apache.lucene.analysis.ja.neologd.util.TokenInfoDictionaryWriter;
import org.apache.lucene.util.IntsRefBuilder;
import org.apache.lucene.util.fst.Builder;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.Outputs;
import org.apache.lucene.util.fst.PositiveIntOutputs;

class TokenInfoDictionaryBuilder {
    private final String encoding;
    private final Normalizer.Form normalForm;
    private final DictionaryBuilder.DictionaryFormat format;
    private int offset = 0;

    public TokenInfoDictionaryBuilder(DictionaryBuilder.DictionaryFormat format, String encoding, boolean normalizeEntries) {
        this.format = format;
        this.encoding = encoding;
        this.normalForm = normalizeEntries ? Normalizer.Form.NFKC : null;
    }

    public TokenInfoDictionaryWriter build(Path dir) throws IOException {
        try (Stream<Path> files = Files.list(dir);){
            List<Path> csvFiles = files.filter(path -> path.getFileName().toString().endsWith(".csv")).sorted().collect(Collectors.toList());
            TokenInfoDictionaryWriter tokenInfoDictionaryWriter = this.buildDictionary(csvFiles);
            return tokenInfoDictionaryWriter;
        }
    }

    private TokenInfoDictionaryWriter buildDictionary(List<Path> csvFiles) throws IOException {
        TokenInfoDictionaryWriter dictionary = new TokenInfoDictionaryWriter(0xA00000);
        Charset cs = Charset.forName(this.encoding);
        ArrayList<String[]> lines = new ArrayList<String[]>(400000);
        for (Path path : csvFiles) {
            BufferedReader reader = Files.newBufferedReader(path, cs);
            Throwable throwable = null;
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    String[] entry2 = CSVUtil.parse(line);
                    if (entry2.length < 13) {
                        throw new IllegalArgumentException("Entry in CSV is not valid (13 field values expected): " + line);
                    }
                    lines.add(this.formatEntry(entry2));
                    if (this.normalForm == null || Normalizer.isNormalized(entry2[0], this.normalForm)) continue;
                    String[] normalizedEntry = new String[entry2.length];
                    for (int i = 0; i < entry2.length; ++i) {
                        normalizedEntry[i] = Normalizer.normalize(entry2[i], this.normalForm);
                    }
                    lines.add(this.formatEntry(normalizedEntry));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (reader == null) continue;
                if (throwable != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                reader.close();
            }
        }
        lines.sort(Comparator.comparing(entry -> entry[0]));
        PositiveIntOutputs fstOutput = PositiveIntOutputs.getSingleton();
        Builder fstBuilder = new Builder(FST.INPUT_TYPE.BYTE2, 0, 0, true, true, Integer.MAX_VALUE, (Outputs)fstOutput, true, 15);
        IntsRefBuilder scratch = new IntsRefBuilder();
        long ord = -1L;
        String lastValue = null;
        for (Object[] objectArray : lines) {
            int next = dictionary.put((String[])objectArray);
            if (next == this.offset) {
                throw new IllegalStateException("Failed to process line: " + Arrays.toString(objectArray));
            }
            String token = objectArray[0];
            if (!token.equals(lastValue)) {
                ++ord;
                lastValue = token;
                scratch.grow(token.length());
                scratch.setLength(token.length());
                for (int i = 0; i < token.length(); ++i) {
                    scratch.setIntAt(i, (int)token.charAt(i));
                }
                fstBuilder.add(scratch.get(), (Object)ord);
            }
            dictionary.addMapping((int)ord, this.offset);
            this.offset = next;
        }
        dictionary.setFST((FST<Long>)fstBuilder.finish());
        return dictionary;
    }

    private String[] formatEntry(String[] features) {
        if (this.format == DictionaryBuilder.DictionaryFormat.IPADIC) {
            return features;
        }
        String[] features2 = new String[13];
        features2[0] = features[0];
        features2[1] = features[1];
        features2[2] = features[2];
        features2[3] = features[3];
        features2[4] = features[4];
        features2[5] = features[5];
        features2[6] = features[6];
        features2[7] = features[7];
        features2[8] = features[8];
        features2[9] = features[9];
        features2[10] = features[11];
        if (features[13].length() == 0) {
            features2[11] = features[0];
            features2[12] = features[0];
        } else {
            features2[11] = features[13];
            features2[12] = features[13];
        }
        return features2;
    }
}

