/*
 * Decompiled with CFR 0.152.
 */
package org.natty;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.tree.Tree;
import org.natty.ParseLocation;

public class DateGroup {
    private List<Date> _dates = new ArrayList<Date>();
    private String _text;
    private String _fullText;
    private int _line;
    private int _position;
    private boolean _isRecurring;
    private boolean _isDateInferred = true;
    private boolean _isTimeInferred = true;
    private Date _recurringUntil;
    private Map<String, List<ParseLocation>> _parseLocations;
    private Tree _syntaxTree;

    public void addDate(Date date) {
        this._dates.add(date);
    }

    public int getAbsolutePosition() {
        int lineCount = 1;
        int columnCount = 1;
        for (int i = 0; i < this._fullText.length(); ++i) {
            if (lineCount == this._line && columnCount == this._position) {
                return i;
            }
            if (this._fullText.charAt(i) == '\n') {
                ++lineCount;
                columnCount = 1;
                continue;
            }
            ++columnCount;
        }
        return -1;
    }

    public List<Date> getDates() {
        return this._dates;
    }

    public String getFullText() {
        return this._fullText;
    }

    public int getLine() {
        return this._line;
    }

    public Map<String, List<ParseLocation>> getParseLocations() {
        return this._parseLocations;
    }

    public int getPosition() {
        return this._position;
    }

    public String getPrefix(int length) {
        return this._fullText.substring(Math.max(0, this.getAbsolutePosition() - length), this.getAbsolutePosition());
    }

    public Date getRecursUntil() {
        return this._recurringUntil;
    }

    public String getSuffix(int length) {
        int endPosition = this.getAbsolutePosition() + this._text.length() + 1;
        return this._fullText.substring(Math.min(endPosition - 1, this._fullText.length()), Math.min(endPosition + length - 1, this._fullText.length()));
    }

    public Tree getSyntaxTree() {
        return this._syntaxTree;
    }

    public String getText() {
        return this._text;
    }

    public boolean isDateInferred() {
        return this._isDateInferred;
    }

    public boolean isRecurring() {
        return this._isRecurring;
    }

    public boolean isTimeInferred() {
        return this._isTimeInferred;
    }

    public void setDateInferred(boolean isDateInferred) {
        this._isDateInferred = isDateInferred;
    }

    public void setFullText(String fullText) {
        this._fullText = fullText;
    }

    public void setIsTimeInferred(boolean isTimeInferred) {
        this._isTimeInferred = isTimeInferred;
    }

    public void setLine(int line) {
        this._line = line;
    }

    public void setParseLocations(Map<String, List<ParseLocation>> parseLocations) {
        this._parseLocations = parseLocations;
    }

    public void setPosition(int position) {
        this._position = position;
    }

    public void setRecurring(boolean isRecurring) {
        this._isRecurring = isRecurring;
    }

    public void setRecurringUntil(Date recurringUntil) {
        this._recurringUntil = recurringUntil;
    }

    public void setSyntaxTree(Tree syntaxTree) {
        this._syntaxTree = syntaxTree;
    }

    public void setText(String text) {
        this._text = text;
    }
}

