/*
 * Decompiled with CFR 0.152.
 */
package org.natty;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.debug.DebugEventListener;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.antlr.runtime.tree.Tree;
import org.antlr.runtime.tree.TreeNodeStream;
import org.natty.ANTLRNoCaseInputStream;
import org.natty.DateGroup;
import org.natty.NattyTokenSource;
import org.natty.ParseListener;
import org.natty.ParseLocation;
import org.natty.generated.DateLexer;
import org.natty.generated.DateParser;
import org.natty.generated.DateWalker;
import org.natty.generated.TreeRewrite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Parser {
    private TimeZone _defaultTimeZone;
    private static final Logger _logger = LoggerFactory.getLogger(Parser.class);
    private static final Set<Integer> IGNORED_TRAILING_TOKENS = new HashSet<Integer>(Arrays.asList(28, 18, 21, 24, 235, 28, 217, 230));

    public Parser(TimeZone defaultTimeZone) {
        this._defaultTimeZone = defaultTimeZone;
    }

    public Parser() {
        this._defaultTimeZone = TimeZone.getDefault();
    }

    public List<DateGroup> parse(String value) {
        return this.parse(value, new Date());
    }

    public List<DateGroup> parse(String value, Date referenceDate) {
        ANTLRNoCaseInputStream input = null;
        try {
            input = new ANTLRNoCaseInputStream(new ByteArrayInputStream(value.getBytes()));
        }
        catch (IOException e) {
            _logger.error("could not lex input", (Throwable)e);
        }
        DateLexer lexer = new DateLexer((CharStream)input);
        List<TokenStream> streams = this.collectTokenStreams((TokenStream)new CommonTokenStream((TokenSource)lexer));
        ArrayList<DateGroup> groups = new ArrayList<DateGroup>();
        TokenStream lastStream = null;
        Iterator<TokenStream> iterator = streams.iterator();
        while (iterator.hasNext()) {
            TokenStream stream;
            lastStream = stream = iterator.next();
            List<Token> tokens = ((NattyTokenSource)stream.getTokenSource()).getTokens();
            DateGroup group = this.singleParse(stream, value, referenceDate);
            while ((group == null || group.getDates().size() == 0) && tokens.size() > 0) {
                if (group != null && group.getDates().size() != 0) continue;
                List<Object> endRemovedTokens = new ArrayList<Token>(tokens);
                while ((group == null || group.getDates().isEmpty()) && !endRemovedTokens.isEmpty()) {
                    endRemovedTokens = endRemovedTokens.subList(0, endRemovedTokens.size() - 1);
                    CommonTokenStream newStream = new CommonTokenStream((TokenSource)new NattyTokenSource(endRemovedTokens));
                    group = this.singleParse((TokenStream)newStream, value, referenceDate);
                    lastStream = newStream;
                }
                while ((group == null || group.getDates().isEmpty()) && tokens.size() >= 1) {
                    Token token;
                    tokens = tokens.subList(1, tokens.size());
                    Iterator<Token> iter = tokens.iterator();
                    while (iter.hasNext() && !DateParser.FOLLOW_empty_in_parse186.member((token = iter.next()).getType())) {
                        iter.remove();
                    }
                    CommonTokenStream newStream = new CommonTokenStream((TokenSource)new NattyTokenSource(tokens));
                    group = this.singleParse((TokenStream)newStream, value, referenceDate);
                    lastStream = newStream;
                }
            }
            if (group == null || group.getDates().isEmpty() || streams.size() != 1 && group.isDateInferred() && this.isAllNumeric(lastStream)) continue;
            group.setFullText(value);
            String prefix = group.getPrefix(1);
            String suffix = group.getSuffix(1);
            if (!prefix.isEmpty() && Character.isLetter(prefix.charAt(0)) || !suffix.isEmpty() && Character.isLetter(suffix.charAt(0))) continue;
            groups.add(group);
        }
        return groups;
    }

    private boolean isAllNumeric(TokenStream stream) {
        List<Token> tokens = ((NattyTokenSource)stream.getTokenSource()).getTokens();
        for (Token token : tokens) {
            try {
                Integer.parseInt(token.getText());
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return true;
    }

    private DateGroup singleParse(TokenStream stream, String fullText, Date referenceDate) {
        DateGroup group = null;
        List<Token> tokens = ((NattyTokenSource)stream.getTokenSource()).getTokens();
        if (tokens.isEmpty()) {
            return group;
        }
        StringBuilder tokenString = new StringBuilder();
        for (Token token : tokens) {
            tokenString.append(DateParser.tokenNames[token.getType()]);
            tokenString.append(" ");
        }
        try {
            ParseListener listener = new ParseListener();
            DateParser parser = new DateParser(stream, (DebugEventListener)listener);
            DateParser.parse_return parseReturn = parser.parse();
            Tree tree = (Tree)parseReturn.getTree();
            if (tree.getChildCount() > 0) {
                _logger.info("PARSE: " + tokenString.toString());
                CommonTreeNodeStream nodes = new CommonTreeNodeStream((Object)tree);
                TreeRewrite s = new TreeRewrite((TreeNodeStream)nodes);
                tree = (CommonTree)s.downup(tree);
                nodes = new CommonTreeNodeStream((Object)tree);
                nodes.setTokenStream(stream);
                DateWalker walker = new DateWalker((TreeNodeStream)nodes);
                walker.setReferenceDate(referenceDate);
                walker.getState().setDefaultTimeZone(this._defaultTimeZone);
                walker.parse();
                _logger.info("AST: " + tree.toStringTree());
                group = walker.getState().getDateGroup();
                ParseLocation location = listener.getDateGroupLocation();
                group.setLine(location.getLine());
                group.setText(location.getText());
                group.setPosition(location.getStart());
                group.setSyntaxTree(tree);
                group.setParseLocations(listener.getLocations());
                group.setFullText(fullText);
                String prefix = group.getPrefix(1);
                String suffix = group.getSuffix(1);
                if (!prefix.isEmpty() && Character.isLetter(prefix.charAt(0)) || !suffix.isEmpty() && Character.isLetter(suffix.charAt(0))) {
                    group = null;
                }
            }
        }
        catch (RecognitionException e) {
            _logger.debug("Could not parse input", (Throwable)e);
        }
        return group;
    }

    private List<TokenStream> collectTokenStreams(TokenStream stream) {
        Token currentToken;
        ArrayList<Token> currentGroup = null;
        ArrayList<List<Token>> groups = new ArrayList<List<Token>>();
        StringBuilder tokenString = new StringBuilder();
        while ((currentToken = stream.getTokenSource().nextToken()).getType() != -1) {
            int currentTokenType = currentToken.getType();
            tokenString.append(DateParser.tokenNames[currentTokenType]).append(" ");
            if (currentGroup == null) {
                if (currentTokenType == 278 || !DateParser.FOLLOW_empty_in_parse186.member(currentTokenType)) continue;
                currentGroup = new ArrayList<Token>();
                currentGroup.add(currentToken);
                continue;
            }
            if (currentTokenType == 278) {
                currentGroup.add(currentToken);
                continue;
            }
            if (currentTokenType == 269) {
                this.addGroup((List<Token>)currentGroup, groups);
                currentGroup = null;
                continue;
            }
            currentGroup.add(currentToken);
        }
        if (currentGroup != null) {
            this.addGroup(currentGroup, groups);
        }
        _logger.info("STREAM: " + tokenString.toString());
        ArrayList<TokenStream> streams = new ArrayList<TokenStream>();
        for (List list : groups) {
            if (list.isEmpty()) continue;
            StringBuilder builder = new StringBuilder();
            builder.append("GROUP: ");
            for (Token token : list) {
                builder.append(DateParser.tokenNames[token.getType()]).append(" ");
            }
            _logger.info(builder.toString());
            streams.add((TokenStream)new CommonTokenStream((TokenSource)new NattyTokenSource(list)));
        }
        return streams;
    }

    private void addGroup(List<Token> group, List<List<Token>> groups) {
        if (group.isEmpty()) {
            return;
        }
        while (!group.isEmpty() && IGNORED_TRAILING_TOKENS.contains(group.get(group.size() - 1).getType())) {
            group.remove(group.size() - 1);
        }
        if (!group.isEmpty()) {
            groups.add(group);
        }
    }
}

