/*
 * Decompiled with CFR 0.152.
 */
package io.github.nazarovctrl.telegrambotspring.longpolling;

import io.github.nazarovctrl.telegrambotspring.bot.BotConfig;
import io.github.nazarovctrl.telegrambotspring.bot.TelegramBotAPIOptions;
import io.github.nazarovctrl.telegrambotspring.controller.AbstractUpdateController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.telegram.telegrambots.bots.DefaultBotOptions;
import org.telegram.telegrambots.meta.TelegramBotsApi;
import org.telegram.telegrambots.meta.api.objects.Update;
import org.telegram.telegrambots.meta.exceptions.TelegramApiException;
import org.telegram.telegrambots.meta.generics.LongPollingBot;
import org.telegram.telegrambots.updatesreceivers.DefaultBotSession;

@Component
public class TelegramLongPollingBot
extends org.telegram.telegrambots.bots.TelegramLongPollingBot {
    private static final Logger log = LoggerFactory.getLogger(TelegramLongPollingBot.class);
    private final BotConfig botConfig;
    private final AbstractUpdateController updateController;

    public TelegramLongPollingBot(TelegramBotAPIOptions options, BotConfig botConfig, AbstractUpdateController updateController) throws TelegramApiException {
        super((DefaultBotOptions)options, botConfig.getToken());
        this.botConfig = botConfig;
        this.updateController = updateController;
        TelegramBotsApi telegramBotsApi = new TelegramBotsApi(DefaultBotSession.class);
        telegramBotsApi.registerBot((LongPollingBot)this);
        log.info("Telegram long polling bot initialized");
    }

    public String getBotUsername() {
        return this.botConfig.getName();
    }

    public void onUpdateReceived(Update update) {
        this.updateController.handle(update);
    }
}

