/*
 * Decompiled with CFR 0.152.
 */
package io.github.nazarovctrl.telegrambotspring.webhook;

import io.github.nazarovctrl.telegrambotspring.bot.BotConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.methods.updates.SetWebhook;
import org.telegram.telegrambots.meta.api.objects.Update;
import org.telegram.telegrambots.meta.exceptions.TelegramApiException;
import org.telegram.telegrambots.meta.generics.WebhookBot;
import org.telegram.telegrambots.updatesreceivers.DefaultWebhook;

@Component
public class TelegramWebhookBot
extends org.telegram.telegrambots.bots.TelegramWebhookBot {
    private static final Logger log = LoggerFactory.getLogger(TelegramWebhookBot.class);
    private final BotConfig botConfig;

    public TelegramWebhookBot(BotConfig botConfig) throws TelegramApiException {
        super(botConfig.getToken());
        this.botConfig = botConfig;
        DefaultWebhook webhook = new DefaultWebhook();
        this.onRegister();
        webhook.registerWebhook((WebhookBot)this);
        SetWebhook setWebhook = SetWebhook.builder().url(botConfig.getUri()).build();
        this.setWebhook(setWebhook);
        log.info("Telegram webhook bot initialized");
    }

    public String getBotUsername() {
        return this.botConfig.getName();
    }

    public BotApiMethod<?> onWebhookUpdateReceived(Update update) {
        return null;
    }

    public String getBotPath() {
        return "/update";
    }
}

