/*
 * Decompiled with CFR 0.152.
 */
package io.github.nazarovctrl.telegrambotspring.webhook;

import io.github.nazarovctrl.telegrambotspring.controller.AbstractUpdateController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.telegram.telegrambots.meta.api.objects.Update;

@RestController
public class WebHookController {
    private static final Logger log = LoggerFactory.getLogger(WebHookController.class);
    private final AbstractUpdateController updateController;

    public WebHookController(AbstractUpdateController updateController) {
        this.updateController = updateController;
        log.info("Webhook controller initialized");
    }

    @RequestMapping(value={"/callback/update"}, method={RequestMethod.POST})
    ResponseEntity<?> onUpdateReceived(@RequestBody Update update) {
        this.updateController.handle(update);
        return ResponseEntity.ok().build();
    }
}

