/*
 * Decompiled with CFR 0.152.
 */
package org.paseto4j.commons;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Base64;
import java.util.Locale;
import org.paseto4j.commons.Conditions;
import org.paseto4j.commons.Purpose;
import org.paseto4j.commons.TokenAlgorithm;
import org.paseto4j.commons.Version;

public class Token {
    private final String[] tokenParts;
    private final TokenAlgorithm tokenAlgorithm;
    private final String tokenString;

    Token(String tokenString, TokenAlgorithm tokenAlgorithm, String footer) {
        this.tokenString = tokenString;
        this.tokenParts = tokenString.split("\\.", -1);
        this.tokenAlgorithm = tokenAlgorithm;
        Conditions.verify(tokenString.startsWith(tokenAlgorithm.header()), "Token should start with " + tokenAlgorithm.header());
        if (Conditions.isNullOrEmpty(footer)) {
            Conditions.verify(this.tokenParts.length != 4, "An non-empty footer has been passed, so the token should consist of exactly 4 parts");
        } else {
            Conditions.verify(this.tokenParts.length != 3, "Token should consists of exactly 3 parts");
        }
        this.validateTokenParts();
        this.verifyFooter(footer);
    }

    public Token(String tokenString, Version version, Purpose purpose, String footer) {
        this(tokenString, new TokenAlgorithm(version, purpose), footer);
    }

    private void validateTokenParts() {
        for (int i = 0; i < 3; ++i) {
            Conditions.verify(!Conditions.isNullOrEmpty(this.tokenParts[i]), String.format(Locale.ROOT, "Token part %d cannot be null or empty", i));
        }
    }

    public String getPayload() {
        return this.tokenParts[2];
    }

    private void verifyFooter(String footer) {
        if (!Conditions.isNullOrEmpty(footer)) {
            Conditions.verify(MessageDigest.isEqual(Base64.getUrlDecoder().decode(this.tokenParts[3]), footer.getBytes(StandardCharsets.UTF_8)), "footer does not match");
        }
    }

    public byte[] header() {
        return this.tokenAlgorithm.header().getBytes(StandardCharsets.UTF_8);
    }

    public String toString() {
        return this.tokenString;
    }
}

