/*
 * Decompiled with CFR 0.152.
 */
package org.paseto4j.commons;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.paseto4j.commons.Conditions;
import org.paseto4j.commons.Purpose;
import org.paseto4j.commons.Token;
import org.paseto4j.commons.TokenAlgorithm;
import org.paseto4j.commons.Version;

public class TokenOut {
    private final TokenAlgorithm tokenAlgorithm;
    private String footer;
    private String tokenPayload;

    public TokenOut(Version version, Purpose purpose) {
        this.tokenAlgorithm = new TokenAlgorithm(version, purpose);
    }

    public TokenOut footer(String footer) {
        this.footer = footer;
        return this;
    }

    public TokenOut payload(byte[] tokenPayload) {
        this.tokenPayload = Base64.getUrlEncoder().withoutPadding().encodeToString(tokenPayload);
        return this;
    }

    public String doFinal() {
        String pasetoToken = this.tokenAlgorithm.header() + this.tokenPayload;
        if (!Conditions.isNullOrEmpty(this.footer)) {
            pasetoToken = pasetoToken + "." + Base64.getUrlEncoder().withoutPadding().encodeToString(this.footer.getBytes(StandardCharsets.UTF_8));
        }
        return new Token(pasetoToken, this.tokenAlgorithm, this.footer).toString();
    }

    public byte[] header() {
        return this.tokenAlgorithm.header().getBytes(StandardCharsets.UTF_8);
    }
}

