/*
 * Decompiled with CFR 0.152.
 */
package org.paseto4j.version3;

import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.crypto.DerivationParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA384Digest;
import org.bouncycastle.crypto.generators.HKDFBytesGenerator;
import org.bouncycastle.crypto.params.HKDFParameters;
import org.bouncycastle.util.BigIntegers;
import org.paseto4j.commons.ByteUtils;
import org.paseto4j.commons.Pair;

public class CryptoFunctions {
    private CryptoFunctions() {
    }

    public static byte[] randomBytes() {
        byte[] random = new byte[32];
        new SecureRandom().nextBytes(random);
        return random;
    }

    public static byte[] hmac384(byte[] key, byte[] message) {
        try {
            Mac mac = Mac.getInstance("HMac-SHA384", "BC");
            SecretKeySpec secretKey = new SecretKeySpec(key, "HMac-SHA384");
            mac.init(secretKey);
            mac.reset();
            return mac.doFinal(message);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new IllegalStateException(e);
        }
    }

    public static byte[] encryptAesCtr(byte[] key, byte[] nonce, byte[] message) {
        return CryptoFunctions.encryptDecrypt(true, key, nonce, message);
    }

    public static byte[] decryptAesCtr(byte[] key, byte[] nonce, byte[] message) {
        return CryptoFunctions.encryptDecrypt(false, key, nonce, message);
    }

    private static byte[] encryptDecrypt(boolean encryption, byte[] key, byte[] nonce, byte[] message) {
        try {
            Cipher aes = Cipher.getInstance("AES/CTR/NoPadding", "BC");
            SecretKeySpec secretKeySpec = new SecretKeySpec(key, "AES");
            aes.init(encryption ? 1 : 2, (Key)secretKeySpec, new IvParameterSpec(nonce));
            return aes.doFinal(message);
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException(e);
        }
    }

    public static byte[] hkdfSha384(byte[] key, byte[] info) {
        SHA384Digest digest = new SHA384Digest();
        HKDFBytesGenerator hkdf = new HKDFBytesGenerator((Digest)digest);
        hkdf.init((DerivationParameters)new HKDFParameters(key, null, info));
        byte[] out = new byte[48];
        hkdf.generateBytes(out, 0, out.length);
        return out;
    }

    private static byte[] toUnsignedByteArray(BigInteger n, int length) {
        byte[] bs = BigIntegers.asUnsignedByteArray((BigInteger)n);
        if (bs.length < length) {
            byte[] tmp = new byte[length];
            System.arraycopy(bs, 0, tmp, length - bs.length, bs.length);
            bs = tmp;
        }
        return bs;
    }

    public static byte[] sign(PrivateKey privateKey, byte[] msg) {
        try {
            Signature signature = Signature.getInstance("SHA384withECDDSA", "BC");
            signature.initSign(privateKey);
            signature.update(msg);
            byte[] sig = signature.sign();
            ASN1Sequence seq = ASN1Sequence.getInstance((Object)sig);
            ASN1Integer r = (ASN1Integer)seq.getObjectAt(0);
            ASN1Integer s = (ASN1Integer)seq.getObjectAt(1);
            return ByteUtils.concat((byte[][])new byte[][]{CryptoFunctions.toUnsignedByteArray(r.getValue(), 48), CryptoFunctions.toUnsignedByteArray(s.getValue(), 48)});
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException(e);
        }
    }

    public static boolean verify(PublicKey publicKey, byte[] msg, byte[] signature) {
        try {
            Signature verifier = Signature.getInstance("SHA384withECDDSA", "BC");
            verifier.initVerify(publicKey);
            verifier.update(msg);
            Pair pair = ByteUtils.split((byte[])signature, (int)48);
            DERSequence seq = new DERSequence((ASN1Encodable[])new ASN1Integer[]{new ASN1Integer(new BigInteger(1, (byte[])pair.getFirst())), new ASN1Integer(new BigInteger(1, (byte[])pair.getSecond()))});
            return verifier.verify(seq.getEncoded());
        }
        catch (IOException | GeneralSecurityException e) {
            throw new IllegalStateException(e);
        }
    }
}

