/*
 * Decompiled with CFR 0.152.
 */
package org.paseto4j.version3;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.Base64;
import java.util.Objects;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.paseto4j.commons.ByteUtils;
import org.paseto4j.commons.Conditions;
import org.paseto4j.commons.Pair;
import org.paseto4j.commons.PreAuthenticationEncoder;
import org.paseto4j.commons.Purpose;
import org.paseto4j.commons.SecretKey;
import org.paseto4j.commons.Token;
import org.paseto4j.commons.TokenOut;
import org.paseto4j.commons.Version;
import org.paseto4j.version3.CryptoFunctions;

class PasetoLocal {
    private PasetoLocal() {
    }

    public static String encrypt(SecretKey key, String payload, String footer, String implicit) {
        return PasetoLocal.encrypt(key, CryptoFunctions.randomBytes(), payload, footer, implicit);
    }

    static String encrypt(SecretKey key, byte[] randomKey, String payload, String footer, String implicit) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(payload);
        Conditions.verify((boolean)key.isValidFor(Version.V3, Purpose.PURPOSE_LOCAL), (String)"Key is not valid for purpose and version");
        Conditions.verify((boolean)key.hasLength(32), (String)"Key should be 32 bytes");
        TokenOut token = new TokenOut(Version.V3, Purpose.PURPOSE_LOCAL);
        byte[] nonce = randomKey;
        byte[] tmp = PasetoLocal.encryptionKey(key, nonce);
        Pair split = ByteUtils.split((byte[])tmp, (int)32);
        byte[] ek = (byte[])split.getFirst();
        byte[] n2 = (byte[])split.getSecond();
        byte[] ak = PasetoLocal.authenticationKey(key, nonce);
        byte[] cipherText = CryptoFunctions.encryptAesCtr(ek, n2, payload.getBytes(StandardCharsets.UTF_8));
        byte[] preAuth = PreAuthenticationEncoder.encode((byte[][])new byte[][]{token.header(), nonce, cipherText, footer.getBytes(StandardCharsets.UTF_8), implicit.getBytes(StandardCharsets.UTF_8)});
        byte[] t = CryptoFunctions.hmac384(ak, preAuth);
        return token.payload(ByteUtils.concat((byte[][])new byte[][]{nonce, cipherText, t})).footer(footer).doFinal();
    }

    private static byte[] encryptionKey(SecretKey key, byte[] nonce) {
        return CryptoFunctions.hkdfSha384(key.getMaterial(), ByteUtils.concat((byte[][])new byte[][]{"paseto-encryption-key".getBytes(StandardCharsets.UTF_8), nonce}));
    }

    private static byte[] authenticationKey(SecretKey key, byte[] nonce) {
        return CryptoFunctions.hkdfSha384(key.getMaterial(), ByteUtils.concat((byte[][])new byte[][]{"paseto-auth-key-for-aead".getBytes(StandardCharsets.UTF_8), nonce}));
    }

    public static String decrypt(SecretKey key, String token) {
        return PasetoLocal.decrypt(key, token, "");
    }

    public static String decrypt(SecretKey key, String token, String footer) {
        return PasetoLocal.decrypt(key, token, footer, "");
    }

    static String decrypt(SecretKey key, String token, String footer, String implicitAssertion) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(token);
        Conditions.verify((boolean)key.isValidFor(Version.V3, Purpose.PURPOSE_LOCAL), (String)"Key is not valid for purpose and version");
        Token pasetoToken = new Token(token, Version.V3, Purpose.PURPOSE_LOCAL, footer);
        byte[] ct = Base64.getUrlDecoder().decode(pasetoToken.getPayload());
        byte[] nonce = Arrays.copyOfRange(ct, 0, 32);
        byte[] t = Arrays.copyOfRange(ct, ct.length - 48, ct.length);
        byte[] c = Arrays.copyOfRange(ct, 32, ct.length - 48);
        byte[] tmp = PasetoLocal.encryptionKey(key, nonce);
        Pair split = ByteUtils.split((byte[])tmp, (int)32);
        byte[] ek = (byte[])split.getFirst();
        byte[] n2 = (byte[])split.getSecond();
        byte[] ak = PasetoLocal.authenticationKey(key, nonce);
        byte[] preAuth = PreAuthenticationEncoder.encode((byte[][])new byte[][]{pasetoToken.header(), nonce, c, footer.getBytes(StandardCharsets.UTF_8), implicitAssertion.getBytes(StandardCharsets.UTF_8)});
        byte[] t2 = CryptoFunctions.hmac384(ak, preAuth);
        if (!MessageDigest.isEqual(t, t2)) {
            throw new IllegalStateException("HMAC verification failed");
        }
        byte[] message = CryptoFunctions.decryptAesCtr(ek, n2, c);
        return new String(message, StandardCharsets.UTF_8);
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

