/*
 * Decompiled with CFR 0.152.
 */
package org.paseto4j.version3;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.interfaces.ECPrivateKey;
import java.util.Arrays;
import java.util.Base64;
import java.util.Objects;
import org.bouncycastle.asn1.sec.SECNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.math.ec.ECPoint;
import org.paseto4j.commons.ByteUtils;
import org.paseto4j.commons.Conditions;
import org.paseto4j.commons.PreAuthenticationEncoder;
import org.paseto4j.commons.PrivateKey;
import org.paseto4j.commons.Purpose;
import org.paseto4j.commons.Token;
import org.paseto4j.commons.TokenOut;
import org.paseto4j.commons.Version;
import org.paseto4j.version3.CryptoFunctions;

class PasetoPublic {
    private PasetoPublic() {
    }

    static String sign(PrivateKey privateKey, String payload, String footer, String implicitAssertion) {
        Objects.requireNonNull(privateKey);
        Objects.requireNonNull(payload);
        Conditions.verify((boolean)privateKey.isValidFor(Version.V3, Purpose.PURPOSE_PUBLIC), (String)"Key is not valid for purpose and version");
        TokenOut token = new TokenOut(Version.V3, Purpose.PURPOSE_PUBLIC);
        byte[] pk = PasetoPublic.publicKey(privateKey);
        Conditions.verify((pk.length == 49 ? 1 : 0) != 0, (String)"`pk` **MUST** be 49 bytes long");
        Conditions.verify((pk[0] == 2 || pk[0] == 3 ? 1 : 0) != 0, (String)"The first byte **MUST** be `0x02` or `0x03`");
        byte[] m2 = PreAuthenticationEncoder.encode((byte[][])new byte[][]{pk, token.header(), payload.getBytes(StandardCharsets.UTF_8), footer.getBytes(StandardCharsets.UTF_8), implicitAssertion.getBytes(StandardCharsets.UTF_8)});
        byte[] signature = CryptoFunctions.sign((java.security.PrivateKey)privateKey.getKey(), m2);
        Conditions.verify((signature.length == 96 ? 1 : 0) != 0, (String)"The length of the signature **MUST** be 96 bytes long");
        return token.payload(ByteUtils.concat((byte[][])new byte[][]{payload.getBytes(StandardCharsets.UTF_8), signature})).footer(footer).doFinal();
    }

    static String parse(org.paseto4j.commons.PublicKey publicKey, String signedMessage, String footer, String implicitAssertion) throws SignatureException {
        Objects.requireNonNull(publicKey);
        Objects.requireNonNull(signedMessage);
        Conditions.verify((boolean)publicKey.isValidFor(Version.V3, Purpose.PURPOSE_PUBLIC), (String)"Key is not valid for purpose and version");
        Token token = new Token(signedMessage, Version.V3, Purpose.PURPOSE_PUBLIC, footer);
        byte[] sm = Base64.getUrlDecoder().decode(token.getPayload());
        byte[] signature = Arrays.copyOfRange(sm, sm.length - 96, sm.length);
        byte[] message = Arrays.copyOfRange(sm, 0, sm.length - 96);
        byte[] pk = PasetoPublic.toCompressed(publicKey);
        byte[] m2 = PreAuthenticationEncoder.encode((byte[][])new byte[][]{pk, token.header(), message, footer.getBytes(StandardCharsets.UTF_8), implicitAssertion.getBytes(StandardCharsets.UTF_8)});
        PasetoPublic.verifySignature(publicKey, m2, signature);
        return new String(message, StandardCharsets.UTF_8);
    }

    private static void verifySignature(org.paseto4j.commons.PublicKey key, byte[] m2, byte[] signature) throws SignatureException {
        if (!CryptoFunctions.verify((PublicKey)key.getKey(), m2, signature)) {
            throw new SignatureException("Invalid signature");
        }
    }

    public static byte[] publicKey(PrivateKey key) {
        if (key.getKey() instanceof ECPrivateKey) {
            return PasetoPublic.publicKeyFromPrivate(((ECPrivateKey)key.getKey()).getS());
        }
        throw new IllegalStateException("Only supported for EC");
    }

    private static byte[] publicKeyFromPrivate(BigInteger privKey) {
        X9ECParameters params = SECNamedCurves.getByName((String)"secp384r1");
        ECDomainParameters curve = new ECDomainParameters(params.getCurve(), params.getG(), params.getN(), params.getH());
        ECPoint point = curve.getG().multiply(privKey);
        return point.getEncoded(true);
    }

    private static byte[] toCompressed(org.paseto4j.commons.PublicKey key) {
        if (key.getKey() instanceof ECPublicKey) {
            return ((ECPublicKey)key.getKey()).getQ().getEncoded(true);
        }
        throw new IllegalStateException("Public key is not an EC public key ");
    }
}

