/*
 * Decompiled with CFR 0.152.
 */
package org.paseto4j.version4;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Base64;
import java.util.Objects;
import org.apache.tuweni.bytes.Bytes;
import org.paseto4j.commons.ByteUtils;
import org.paseto4j.commons.Conditions;
import org.paseto4j.commons.PreAuthenticationEncoder;
import org.paseto4j.commons.Purpose;
import org.paseto4j.commons.SecretKey;
import org.paseto4j.commons.Token;
import org.paseto4j.commons.TokenOut;
import org.paseto4j.commons.Version;
import org.paseto4j.version4.CryptoFunctions;

public class PasetoLocal {
    private PasetoLocal() {
    }

    public static String encrypt(SecretKey key, String payload, String footer, String implicit) {
        return PasetoLocal.encrypt(key, Bytes.random((int)32).toArray(), payload, footer, implicit);
    }

    static String encrypt(SecretKey key, byte[] nonce, String payload, String footer, String implicitAssertion) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(payload);
        Conditions.verify((boolean)key.isValidFor(Version.V4, Purpose.PURPOSE_LOCAL), (String)"Key is not valid for purpose and version");
        Conditions.verify((boolean)key.hasLength(32), (String)"key should be 32 bytes");
        Conditions.verify((nonce.length == 32 ? 1 : 0) != 0, (String)"nonce should be 32 bytes");
        TokenOut token = new TokenOut(Version.V4, Purpose.PURPOSE_LOCAL);
        byte[] tmp = PasetoLocal.encryptionKey(key, nonce);
        byte[] ek = Arrays.copyOfRange(tmp, 0, 32);
        byte[] n2 = Arrays.copyOfRange(tmp, 32, 56);
        byte[] ak = PasetoLocal.authenticationKey(key, nonce);
        byte[] c = CryptoFunctions.xchacha20(payload.getBytes(StandardCharsets.UTF_8), n2, ek);
        byte[] preAuth = PreAuthenticationEncoder.encode((byte[][])new byte[][]{token.header(), nonce, c, footer.getBytes(StandardCharsets.UTF_8), implicitAssertion.getBytes(StandardCharsets.UTF_8)});
        byte[] t = CryptoFunctions.blake2b(32, preAuth, ak);
        return token.payload(ByteUtils.concat((byte[][])new byte[][]{nonce, c, t})).footer(footer).doFinal();
    }

    public static String decrypt(SecretKey key, String token, String footer) {
        return PasetoLocal.decrypt(key, token, footer, "");
    }

    static String decrypt(SecretKey key, String token, String footer, String implicitAssertion) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(token);
        Conditions.verify((boolean)key.isValidFor(Version.V4, Purpose.PURPOSE_LOCAL), (String)"Key is not valid for purpose and version");
        Conditions.verify((boolean)key.hasLength(32), (String)"key should be 32 bytes");
        Token pasetoToken = new Token(token, Version.V4, Purpose.PURPOSE_LOCAL, footer);
        byte[] nct = Base64.getUrlDecoder().decode(pasetoToken.getPayload());
        byte[] nonce = Arrays.copyOfRange(nct, 0, 32);
        byte[] t = Arrays.copyOfRange(nct, nct.length - 32, nct.length);
        byte[] c = Arrays.copyOfRange(nct, 32, nct.length - 32);
        byte[] tmp = PasetoLocal.encryptionKey(key, nonce);
        byte[] ek = Arrays.copyOfRange(tmp, 0, 32);
        byte[] n2 = Arrays.copyOfRange(tmp, 32, 56);
        byte[] ak = PasetoLocal.authenticationKey(key, nonce);
        byte[] preAuth = PreAuthenticationEncoder.encode((byte[][])new byte[][]{pasetoToken.header(), nonce, c, footer.getBytes(StandardCharsets.UTF_8), implicitAssertion.getBytes(StandardCharsets.UTF_8)});
        byte[] t2 = CryptoFunctions.blake2b(32, preAuth, ak);
        if (!MessageDigest.isEqual(t, t2)) {
            throw new IllegalStateException("HMAC verification failed");
        }
        byte[] message = CryptoFunctions.xchacha20(c, n2, ek);
        return new String(message, StandardCharsets.UTF_8);
    }

    private static byte[] encryptionKey(SecretKey key, byte[] nonce) {
        return CryptoFunctions.blake2b(56, ByteUtils.concat((byte[][])new byte[][]{"paseto-encryption-key".getBytes(StandardCharsets.UTF_8), nonce}), key.getMaterial());
    }

    private static byte[] authenticationKey(SecretKey key, byte[] nonce) {
        return CryptoFunctions.blake2b(32, ByteUtils.concat((byte[][])new byte[][]{"paseto-auth-key-for-aead".getBytes(StandardCharsets.UTF_8), nonce}), key.getMaterial());
    }
}

