/*
 * Decompiled with CFR 0.152.
 */
package org.paseto4j.version4;

import java.nio.charset.StandardCharsets;
import java.security.SignatureException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Objects;
import org.paseto4j.commons.ByteUtils;
import org.paseto4j.commons.Conditions;
import org.paseto4j.commons.PreAuthenticationEncoder;
import org.paseto4j.commons.PrivateKey;
import org.paseto4j.commons.PublicKey;
import org.paseto4j.commons.Purpose;
import org.paseto4j.commons.Token;
import org.paseto4j.commons.TokenOut;
import org.paseto4j.commons.Version;
import org.paseto4j.version4.CryptoFunctions;

public class PasetoPublic {
    private PasetoPublic() {
    }

    static String sign(PrivateKey privateKey, String payload, String footer, String implicitAssertion) {
        Objects.requireNonNull(privateKey);
        Objects.requireNonNull(payload);
        Conditions.verify((boolean)privateKey.isValidFor(Version.V4, Purpose.PURPOSE_PUBLIC), (String)"Key is not valid for purpose and version");
        TokenOut token = new TokenOut(Version.V4, Purpose.PURPOSE_PUBLIC);
        byte[] m2 = PreAuthenticationEncoder.encode((byte[][])new byte[][]{token.header(), payload.getBytes(StandardCharsets.UTF_8), footer.getBytes(StandardCharsets.UTF_8), implicitAssertion.getBytes(StandardCharsets.UTF_8)});
        byte[] signature = CryptoFunctions.sign((java.security.PrivateKey)privateKey.getKey(), m2);
        return token.payload(ByteUtils.concat((byte[][])new byte[][]{payload.getBytes(StandardCharsets.UTF_8), signature})).footer(footer).doFinal();
    }

    public static String parse(PublicKey publicKey, String signedMessage, String footer, String implicitAssertion) throws SignatureException {
        Objects.requireNonNull(publicKey);
        Objects.requireNonNull(signedMessage);
        Conditions.verify((boolean)publicKey.isValidFor(Version.V4, Purpose.PURPOSE_PUBLIC), (String)"Key is not valid for purpose and version");
        Token token = new Token(signedMessage, Version.V4, Purpose.PURPOSE_PUBLIC, footer);
        byte[] sm = Base64.getUrlDecoder().decode(token.getPayload());
        byte[] signature = Arrays.copyOfRange(sm, sm.length - 64, sm.length);
        byte[] message = Arrays.copyOfRange(sm, 0, sm.length - 64);
        byte[] m2 = PreAuthenticationEncoder.encode((byte[][])new byte[][]{token.header(), message, footer.getBytes(StandardCharsets.UTF_8), implicitAssertion.getBytes(StandardCharsets.UTF_8)});
        PasetoPublic.verifySignature(publicKey, m2, signature);
        return new String(message, StandardCharsets.UTF_8);
    }

    private static void verifySignature(PublicKey key, byte[] m2, byte[] signature) throws SignatureException {
        if (!CryptoFunctions.verify((java.security.PublicKey)key.getKey(), m2, signature)) {
            throw new SignatureException("Invalid signature");
        }
    }
}

