/*
 * Decompiled with CFR 0.152.
 */
package org.paseto4j.version4;

import org.bouncycastle.crypto.engines.ChaChaEngine;
import org.bouncycastle.util.Pack;

public class XChaCha20Engine
extends ChaChaEngine {
    public String getAlgorithmName() {
        return "XChaCha20";
    }

    protected int getNonceSize() {
        return 24;
    }

    protected void setKey(byte[] keyBytes, byte[] ivBytes) {
        if (keyBytes == null) {
            throw new IllegalArgumentException(this.getAlgorithmName() + " doesn't support re-init with null key");
        }
        if (keyBytes.length != 32) {
            throw new IllegalStateException(this.getAlgorithmName() + " requires a 256 bit key");
        }
        int[] subKey = this.hChaChaDeriveSubKey(keyBytes, ivBytes);
        System.arraycopy(subKey, 0, this.engineState, 4, subKey.length);
        Pack.littleEndianToInt((byte[])ivBytes, (int)16, (int[])this.engineState, (int)14, (int)2);
    }

    public int[] hChaChaDeriveSubKey(byte[] keyBytes, byte[] ivBytes) {
        if (keyBytes == null) {
            throw new IllegalArgumentException("HChaCha" + this.rounds + " doesn't support null keys");
        }
        if (keyBytes.length != 32) {
            throw new IllegalStateException("HChaCha" + this.rounds + "  requires a 256 bit key");
        }
        if (ivBytes == null) {
            throw new IllegalArgumentException("HChaCha" + this.rounds + "  needs a non-null IV");
        }
        if (ivBytes.length < 16) {
            throw new IllegalArgumentException("HChaCha" + this.rounds + " needs an at least 128 bit nonce");
        }
        super.setKey(keyBytes, ivBytes);
        Pack.littleEndianToInt((byte[])ivBytes, (int)0, (int[])this.engineState, (int)12, (int)4);
        int[] hchacha20Out = new int[this.engineState.length];
        XChaCha20Engine.chachaCore((int)20, (int[])this.engineState, (int[])hchacha20Out);
        int[] subkey = new int[8];
        System.arraycopy(hchacha20Out, 0, subkey, 0, 4);
        System.arraycopy(hchacha20Out, 12, subkey, 4, 4);
        subkey[0] = subkey[0] - this.engineState[0];
        subkey[1] = subkey[1] - this.engineState[1];
        subkey[2] = subkey[2] - this.engineState[2];
        subkey[3] = subkey[3] - this.engineState[3];
        subkey[4] = subkey[4] - this.engineState[12];
        subkey[5] = subkey[5] - this.engineState[13];
        subkey[6] = subkey[6] - this.engineState[14];
        subkey[7] = subkey[7] - this.engineState[15];
        return subkey;
    }
}

