/*
 * Decompiled with CFR 0.152.
 */
package io.github.netmikey.logunit.log4j2;

import io.github.netmikey.logunit.core.BaseLogProvider;
import io.github.netmikey.logunit.log4j2.LevelMapper;
import io.github.netmikey.logunit.log4j2.ListAppender;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.event.LoggingEvent;

public class Log4j2LogProvider
extends BaseLogProvider {
    private static final Random RAND = new Random();
    private final ListAppender listAppender = ListAppender.create("LogUnitListAppender" + RAND.nextInt());

    public List<LoggingEvent> getEvents() {
        return StreamSupport.stream(this.listAppender.spliterator(), false).collect(Collectors.toList());
    }

    public void beforeTestExecution(ExtensionContext context) {
        this.getLoggerContext().getConfiguration().addAppender((Appender)this.listAppender);
        this.createLoggersAndAddAppender();
        this.listAppender.start();
        this.getLoggerContext().updateLoggers();
    }

    public void afterTestExecution(ExtensionContext context) {
        this.listAppender.stop();
        this.removeLoggers();
        this.getLoggerContext().updateLoggers();
    }

    private LoggerContext getLoggerContext() {
        return (LoggerContext)LogManager.getContext((boolean)false);
    }

    private void createLoggersAndAddAppender() {
        this.getLoggerTypes().forEach((loggerType, level) -> this.createLoggerAndAddAppender(loggerType.getName(), LevelMapper.mapLevel(level)));
        this.getLoggerNames().forEach((loggerName, level) -> this.createLoggerAndAddAppender((String)loggerName, LevelMapper.mapLevel(level)));
    }

    private void removeLoggers() {
        this.getLoggerTypes().keySet().forEach(loggerType -> this.removeLogger(loggerType.getName()));
        this.getLoggerNames().keySet().forEach(this::removeLogger);
    }

    private void createLoggerAndAddAppender(String loggerName, Level level) {
        LoggerContext ctx = this.getLoggerContext();
        Configuration cfg = ctx.getConfiguration();
        AppenderRef ref = AppenderRef.createAppenderRef((String)this.listAppender.getName(), null, null);
        AppenderRef[] refs = new AppenderRef[]{ref};
        LoggerConfig loggerConfig = LoggerConfig.newBuilder().withAdditivity(true).withLevel(level).withLoggerName(loggerName).withIncludeLocation("true").withRefs(refs).withConfig(cfg).build();
        loggerConfig.addAppender((Appender)this.listAppender, level, null);
        cfg.addLogger(loggerConfig.getName(), loggerConfig);
    }

    private void removeLogger(String loggerName) {
        this.getLoggerContext().getConfiguration().removeLogger(loggerName);
    }
}

