/*
 * Decompiled with CFR 0.152.
 */
package io.github.netmikey.logunit.logback;

import ch.qos.logback.classic.Level;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class LevelMapper {
    private static final Map<org.slf4j.event.Level, Level> LEVEL_MAPPING;
    private static final Map<Level, org.slf4j.event.Level> LEVEL_MAPPING_REVERSE;

    public static Level mapLevel(org.slf4j.event.Level level) {
        Level result = LEVEL_MAPPING.get(level);
        if (result == null) {
            throw new IllegalArgumentException("Cannot map log level " + level + " to a Logback log level");
        }
        return result;
    }

    public static org.slf4j.event.Level mapLevel(Level level) {
        org.slf4j.event.Level result = LEVEL_MAPPING_REVERSE.get(level);
        if (result == null) {
            throw new IllegalArgumentException("Cannot map Logback log level " + level + " to an slf4j log level");
        }
        return result;
    }

    static {
        HashMap<org.slf4j.event.Level, Level> levelMapping = new HashMap<org.slf4j.event.Level, Level>();
        levelMapping.put(org.slf4j.event.Level.TRACE, Level.TRACE);
        levelMapping.put(org.slf4j.event.Level.DEBUG, Level.DEBUG);
        levelMapping.put(org.slf4j.event.Level.INFO, Level.INFO);
        levelMapping.put(org.slf4j.event.Level.WARN, Level.WARN);
        levelMapping.put(org.slf4j.event.Level.ERROR, Level.ERROR);
        LEVEL_MAPPING = Collections.unmodifiableMap(levelMapping);
        HashMap<Level, org.slf4j.event.Level> levelMappingReverse = new HashMap<Level, org.slf4j.event.Level>();
        levelMapping.forEach((key, value) -> levelMappingReverse.put((Level)value, (org.slf4j.event.Level)key));
        levelMappingReverse.put(Level.ALL, org.slf4j.event.Level.TRACE);
        levelMappingReverse.put(Level.OFF, org.slf4j.event.Level.ERROR);
        LEVEL_MAPPING_REVERSE = Collections.unmodifiableMap(levelMappingReverse);
    }
}

