/*
 * Decompiled with CFR 0.152.
 */
package io.github.netmikey.logunit.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxy;
import io.github.netmikey.logunit.core.BaseLogProvider;
import io.github.netmikey.logunit.logback.ConcurrentListAppender;
import io.github.netmikey.logunit.logback.LevelMapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.event.LoggingEvent;

public class LogbackLogProvider
extends BaseLogProvider {
    private final ConcurrentListAppender<ILoggingEvent> listAppender = new ConcurrentListAppender();
    private final Map<String, Level> originalLevels = new HashMap<String, Level>();

    public List<LoggingEvent> getEvents() {
        return StreamSupport.stream(this.listAppender.spliterator(), false).map(this::mapEvent).collect(Collectors.toList());
    }

    public void beforeTestExecution(ExtensionContext context) {
        this.addAppenderToLoggingSources();
        this.listAppender.start();
    }

    public void afterTestExecution(ExtensionContext context) {
        this.listAppender.stop();
        this.detachAppenderFromLoggingSources();
    }

    private void addAppenderToLoggingSources() {
        for (Map.Entry logSource : this.getLoggerTypes().entrySet()) {
            this.addAppenderToType((Class)logSource.getKey(), LevelMapper.mapLevel((org.slf4j.event.Level)logSource.getValue()));
        }
        for (Map.Entry logSource : this.getLoggerNames().entrySet()) {
            this.addAppenderToLogger((String)logSource.getKey(), LevelMapper.mapLevel((org.slf4j.event.Level)logSource.getValue()));
        }
    }

    private void detachAppenderFromLoggingSources() {
        for (Map.Entry logSource : this.getLoggerTypes().entrySet()) {
            this.detachAppenderFromType((Class)logSource.getKey());
        }
        for (Map.Entry logSource : this.getLoggerNames().entrySet()) {
            this.detachAppenderFromLogger((String)logSource.getKey());
        }
    }

    private void addAppenderToType(Class<?> type, Level level) {
        this.addAppenderToLogger((Logger)LoggerFactory.getLogger(type), level);
    }

    private void addAppenderToLogger(String name, Level level) {
        this.addAppenderToLogger((Logger)LoggerFactory.getLogger((String)name), level);
    }

    private void addAppenderToLogger(Logger logger, Level level) {
        logger.addAppender(this.listAppender);
        this.originalLevels.put(logger.getName(), logger.getLevel());
        logger.setLevel(level);
    }

    private void detachAppenderFromType(Class<?> type) {
        this.detachAppenderFromLogger((Logger)LoggerFactory.getLogger(type));
    }

    private void detachAppenderFromLogger(String name) {
        this.detachAppenderFromLogger((Logger)LoggerFactory.getLogger((String)name));
    }

    private void detachAppenderFromLogger(Logger logger) {
        logger.detachAppender(this.listAppender);
        Level originalLevel = this.originalLevels.get(logger.getName());
        if (originalLevel != null) {
            logger.setLevel(originalLevel);
        }
    }

    private LoggingEvent mapEvent(final ILoggingEvent iEvent) {
        return new LoggingEvent(){

            public long getTimeStamp() {
                return iEvent.getTimeStamp();
            }

            public Throwable getThrowable() {
                IThrowableProxy throwableProxy = iEvent.getThrowableProxy();
                if (throwableProxy == null) {
                    return null;
                }
                if (throwableProxy instanceof ThrowableProxy) {
                    return ((ThrowableProxy)throwableProxy).getThrowable();
                }
                throw new IllegalStateException("Don't know how to extract the actual Throwable from " + throwableProxy.getClassName());
            }

            public String getThreadName() {
                return iEvent.getThreadName();
            }

            public String getMessage() {
                return iEvent.getFormattedMessage();
            }

            public Marker getMarker() {
                return iEvent.getMarker();
            }

            public String getLoggerName() {
                return iEvent.getLoggerName();
            }

            public org.slf4j.event.Level getLevel() {
                return LevelMapper.mapLevel(iEvent.getLevel());
            }

            public Object[] getArgumentArray() {
                return iEvent.getArgumentArray();
            }
        };
    }
}

