/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.labs;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.newrelic.labs.LogEntry;
import com.newrelic.labs.LowercaseKeyMap;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.zip.GZIPOutputStream;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class LogForwarder {
    private final BlockingQueue<LogEntry> logQueue;
    private final String apiKey;
    private final String apiURL;
    private final OkHttpClient client = new OkHttpClient();
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final long maxMessageSize;

    public LogForwarder(String apiKey, String apiURL, long maxMessageSize, BlockingQueue<LogEntry> logQueue) {
        this.apiKey = apiKey;
        this.apiURL = apiURL;
        this.maxMessageSize = maxMessageSize;
        this.logQueue = logQueue;
    }

    public void addToQueue(List<String> lines, String applicationName, String name, String logtype) {
        for (String line : lines) {
            this.logQueue.add(new LogEntry(line, applicationName, name, logtype, System.currentTimeMillis()));
        }
    }

    public boolean isInitialized() {
        return this.apiKey != null && this.apiURL != null;
    }

    public void flush(List<LogEntry> logEntries) {
        InetAddress localhost = null;
        try {
            localhost = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        String hostname = localhost != null ? localhost.getHostName() : "unknown";
        MediaType mediaType = MediaType.parse((String)"application/json");
        try {
            ArrayList<Map> logEvents = new ArrayList<Map>();
            for (LogEntry entry : logEntries) {
                Map logEvent = (Map)this.objectMapper.convertValue((Object)entry, LowercaseKeyMap.class);
                logEvent.put("hostname", hostname);
                logEvent.put("logtype", entry.getLogType());
                logEvent.put("timestamp", entry.getTimestamp());
                logEvent.put("applicationName", entry.getApplicationName());
                logEvent.put("name", entry.getName());
                logEvent.put("source", "NRBatchingAppender");
                logEvents.add(logEvent);
            }
            String jsonPayload = this.objectMapper.writeValueAsString(logEvents);
            byte[] compressedPayload = this.gzipCompress(jsonPayload);
            if ((long)compressedPayload.length > this.maxMessageSize) {
                System.err.println("Batch size exceeds limit, splitting batch...");
                ArrayList<LogEntry> subBatch = new ArrayList<LogEntry>();
                int currentSize = 0;
                for (LogEntry entry : logEntries) {
                    String entryJson = this.objectMapper.writeValueAsString((Object)entry);
                    int entrySize = this.gzipCompress(entryJson).length;
                    if ((long)(currentSize + entrySize) > this.maxMessageSize) {
                        this.sendLogs(subBatch);
                        subBatch.clear();
                        currentSize = 0;
                    }
                    subBatch.add(entry);
                    currentSize += entrySize;
                }
                if (!subBatch.isEmpty()) {
                    this.sendLogs(subBatch);
                }
            } else {
                this.sendLogs(logEntries);
            }
        }
        catch (IOException e) {
            System.err.println("Error during log forwarding: " + e.getMessage());
        }
    }

    private void sendLogs(List<LogEntry> logEntries) throws IOException {
        InetAddress localhost = InetAddress.getLocalHost();
        String hostname = localhost.getHostName();
        ArrayList<Map> logEvents = new ArrayList<Map>();
        for (LogEntry entry : logEntries) {
            Map logEvent = (Map)this.objectMapper.convertValue((Object)entry, LowercaseKeyMap.class);
            logEvent.put("hostname", hostname);
            logEvent.put("logtype", entry.getLogType());
            logEvent.put("applicationName", entry.getApplicationName());
            logEvent.put("name", entry.getName());
            logEvent.put("timestamp", entry.getTimestamp());
            logEvent.put("source", "NRBatchingAppender");
            logEvents.add(logEvent);
        }
        String jsonPayload = this.objectMapper.writeValueAsString(logEvents);
        byte[] compressedPayload = this.gzipCompress(jsonPayload);
        MediaType mediaType = MediaType.parse((String)"application/json");
        RequestBody requestBody = RequestBody.create((byte[])compressedPayload, (MediaType)mediaType);
        Request request = new Request.Builder().url(this.apiURL).post(requestBody).addHeader("X-License-Key", this.apiKey).addHeader("Content-Type", "application/json").addHeader("Content-Encoding", "gzip").build();
        try (Response response = this.client.newCall(request).execute();){
            if (!response.isSuccessful()) {
                System.err.println("Failed to send logs to New Relic: " + response.code() + " - " + response.message());
                System.err.println("Response body: " + response.body().string());
                this.requeueLogs(logEntries);
            } else {
                LocalDateTime timestamp = LocalDateTime.now();
                System.out.println("Logs sent to New Relic successfully: at " + timestamp + " size: " + compressedPayload.length + " Bytes");
                System.out.println("Response: " + response.body().string());
            }
        }
        catch (IOException e) {
            System.err.println("Error during log forwarding: " + e.getMessage());
            this.requeueLogs(logEntries);
        }
    }

    private void requeueLogs(List<LogEntry> logEntries) {
        for (LogEntry entry : logEntries) {
            try {
                this.logQueue.put(entry);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                System.err.println("Failed to requeue log entry: " + entry.getMessage());
            }
        }
    }

    private byte[] gzipCompress(String input) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (GZIPOutputStream gzipOS = new GZIPOutputStream(bos);){
            gzipOS.write(input.getBytes());
        }
        return bos.toByteArray();
    }

    public void close() {
        ArrayList<LogEntry> remainingLogs = new ArrayList<LogEntry>();
        this.logQueue.drainTo(remainingLogs);
        if (!remainingLogs.isEmpty()) {
            System.out.println("Flushing remaining " + remainingLogs.size() + " log events to New Relic...");
            this.flush(remainingLogs);
        }
    }
}

