/*
 * Decompiled with CFR 0.152.
 */
package io.github.ngyewch.twirp;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.ngyewch.twirp.Meta;
import io.github.ngyewch.twirp.TwirpErrorCode;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class TwirpError {
    private String code;
    private String msg;
    private Map<String, String> meta;

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public Map<String, String> getMeta() {
        return this.meta;
    }

    public void setMeta(Map<String, String> meta) {
        this.meta = meta;
    }

    public static TwirpError from(String code, String msg, Map<String, String> meta) {
        TwirpError error = new TwirpError();
        error.setCode(code);
        error.setMsg(msg);
        error.setMeta(meta);
        return error;
    }

    public static TwirpError from(TwirpErrorCode errorCode, String msg, Map<String, String> meta) {
        return TwirpError.from(errorCode.getCode(), msg, meta);
    }

    public static TwirpError from(TwirpErrorCode errorCode, Throwable t) {
        return TwirpError.from(errorCode, t, false);
    }

    public static TwirpError from(TwirpErrorCode errorCode, Throwable t, boolean withStackTrace) {
        return TwirpError.from(errorCode, t.toString(), withStackTrace ? new Meta().set("stackTrace", ExceptionUtils.getStackTrace((Throwable)t)).get() : null);
    }

    public static TwirpError fromJson(String s) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return (TwirpError)objectMapper.readValue(s, TwirpError.class);
    }

    public static String toJson(TwirpError error) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return objectMapper.writeValueAsString((Object)error);
    }
}

