/*
 * Decompiled with CFR 0.152.
 */
package io.github.ngyewch.twirp;

import io.github.ngyewch.twirp.TwirpError;
import io.github.ngyewch.twirp.TwirpErrorCode;
import java.util.Map;

public class TwirpException
extends RuntimeException {
    private final TwirpError error;

    public TwirpException(TwirpError error) {
        this.error = error;
    }

    public TwirpException(String code, String msg, Map<String, String> meta) {
        this(TwirpError.from(code, msg, meta));
    }

    public TwirpException(TwirpErrorCode errorCode, String msg, Map<String, String> meta) {
        this(TwirpError.from(errorCode, msg, meta));
    }

    public TwirpException(TwirpErrorCode errorCode, Throwable t) {
        this(errorCode, t, false);
    }

    public TwirpException(TwirpErrorCode errorCode, Throwable t, boolean withStackTrace) {
        this(TwirpError.from(errorCode, t, withStackTrace));
    }

    public TwirpError getError() {
        return this.error;
    }

    @Override
    public String getMessage() {
        TwirpErrorCode errorCode = TwirpErrorCode.fromCode(this.error.getCode());
        Object s = "";
        if (errorCode != null) {
            s = (String)s + String.format("%s (%d): ", errorCode.getCode(), errorCode.getHttpStatus());
        } else if (this.error.getCode() != null) {
            s = (String)s + String.format("%s: ", this.error.getCode());
        }
        if (this.error.getMsg() != null) {
            s = (String)s + this.error.getMsg();
        }
        return s;
    }
}

