/*
 * Decompiled with CFR 0.152.
 */
package io.github.ngyewch.twirp.helidon.client;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import io.github.ngyewch.twirp.Meta;
import io.github.ngyewch.twirp.TwirpError;
import io.github.ngyewch.twirp.TwirpErrorCode;
import io.github.ngyewch.twirp.TwirpException;
import io.helidon.common.http.Http;
import io.helidon.common.http.MediaType;
import io.helidon.common.reactive.Single;
import io.helidon.webclient.WebClient;
import io.helidon.webclient.WebClientException;
import io.helidon.webclient.WebClientResponse;
import java.io.IOException;
import java.util.concurrent.ExecutionException;

public abstract class AbstractService {
    protected static final MediaType PROTOBUF_MEDIA_TYPE = MediaType.parse((String)"application/protobuf");
    protected static final MediaType JSON_MEDIA_TYPE = MediaType.parse((String)"application/json");
    private final WebClient webClient;
    private final MediaType contentType;

    protected AbstractService(String baseUri, MediaType contentType) {
        this.webClient = WebClient.builder().baseUri(baseUri).build();
        this.contentType = contentType;
    }

    protected void doRequest(String path, Message input, Message.Builder outputBuilder) {
        Single<Message.Builder> requester;
        if (this.contentType.equals((Object)PROTOBUF_MEDIA_TYPE)) {
            requester = this.doProtobufRequest(path, input, outputBuilder);
        } else if (this.contentType.equals((Object)JSON_MEDIA_TYPE)) {
            requester = this.doJsonRequest(path, input, outputBuilder);
        } else {
            throw new IllegalArgumentException("unsupported content type");
        }
        try {
            requester.get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() != null) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new RuntimeException(e.getCause());
            }
            throw new RuntimeException(e);
        }
    }

    private Single<Message.Builder> doProtobufRequest(String path, Message input, Message.Builder outputBuilder) {
        return this.webClient.post().path(path).contentType(PROTOBUF_MEDIA_TYPE).submit((Object)input.toByteArray()).flatMap(this::handleNonSuccessfulResponse).first().flatMap(webClientResponse -> this.expectMediaType((WebClientResponse)webClientResponse, PROTOBUF_MEDIA_TYPE)).first().flatMap(webClientResponse -> webClientResponse.content().as(byte[].class)).first().map(bytes -> this.mergeProtobuf(outputBuilder, (byte[])bytes));
    }

    private Single<Message.Builder> doJsonRequest(String path, Message input, Message.Builder outputBuilder) {
        try {
            String requestJson = JsonFormat.printer().print((MessageOrBuilder)input);
            return this.webClient.post().path(path).contentType(JSON_MEDIA_TYPE).submit((Object)requestJson).flatMap(this::handleNonSuccessfulResponse).first().flatMap(webClientResponse -> this.expectMediaType((WebClientResponse)webClientResponse, JSON_MEDIA_TYPE)).first().flatMap(webClientResponse -> webClientResponse.content().as(String.class)).first().map(responseJson -> this.mergeProtobufJson(outputBuilder, (String)responseJson));
        }
        catch (InvalidProtocolBufferException e) {
            throw new TwirpException(TwirpErrorCode.INTERNAL, (Throwable)e);
        }
    }

    private Single<WebClientResponse> handleNonSuccessfulResponse(WebClientResponse webClientResponse) {
        if (webClientResponse.status().code() < Http.Status.MOVED_PERMANENTLY_301.code()) {
            return Single.just((Object)webClientResponse);
        }
        MediaType mediaType = webClientResponse.headers().contentType().orElse(null);
        if (mediaType != null && mediaType.equals((Object)JSON_MEDIA_TYPE)) {
            return webClientResponse.content().as(String.class).map(s -> {
                try {
                    throw new TwirpException(TwirpError.fromJson((String)s));
                }
                catch (IOException e) {
                    throw new WebClientException("Request failed with code " + webClientResponse.status().code());
                }
            });
        }
        return Single.error((Throwable)new WebClientException("Request failed with code " + webClientResponse.status().code()));
    }

    private Single<WebClientResponse> expectMediaType(WebClientResponse webClientResponse, MediaType expectedMediaType) {
        MediaType mediaType = webClientResponse.headers().contentType().orElse(null);
        if (mediaType == null || !mediaType.equals((Object)expectedMediaType)) {
            return Single.error((Throwable)new TwirpException(TwirpErrorCode.INVALID_ARGUMENT, "unexpected content type", mediaType != null ? new Meta().set("Content-Type", mediaType.toString()).get() : null));
        }
        return Single.just((Object)webClientResponse);
    }

    private Message.Builder mergeProtobufJson(Message.Builder messageBuilder, String json) {
        try {
            JsonFormat.parser().merge(json, messageBuilder);
            return messageBuilder;
        }
        catch (InvalidProtocolBufferException e) {
            throw new TwirpException(TwirpErrorCode.MALFORMED, (Throwable)e, true);
        }
    }

    private Message.Builder mergeProtobuf(Message.Builder messageBuilder, byte[] data) {
        try {
            return messageBuilder.mergeFrom(data);
        }
        catch (InvalidProtocolBufferException e) {
            throw new TwirpException(TwirpErrorCode.MALFORMED, (Throwable)e, true);
        }
    }
}

