/*
 * Decompiled with CFR 0.152.
 */
package io.github.ngyewch.twirp.helidon.server;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import io.github.ngyewch.twirp.TwirpError;
import io.github.ngyewch.twirp.TwirpErrorCode;
import io.helidon.common.http.MediaType;
import io.helidon.webserver.ServerRequest;
import io.helidon.webserver.ServerResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class Handler {
    private static final MediaType PROTOBUF_MEDIA_TYPE = MediaType.parse((String)"application/protobuf");
    private static final MediaType JSON_MEDIA_TYPE = MediaType.parse((String)"application/json");

    public static void handleTwirp(ServerRequest req, ServerResponse res, Message.Builder messageBuilder, Supplier<Message> serviceInvoker) {
        if (req.headers().contentType().isEmpty()) {
            Handler.sendError(res, TwirpErrorCode.INVALID_ARGUMENT, "Content-Type not specified", null);
            return;
        }
        MediaType contentType = (MediaType)req.headers().contentType().get();
        if (contentType.equals((Object)PROTOBUF_MEDIA_TYPE)) {
            req.content().as(byte[].class).thenAccept(contentBytes -> {
                try {
                    messageBuilder.mergeFrom(contentBytes);
                    Message response = (Message)serviceInvoker.get();
                    res.headers().contentType(contentType);
                    res.send((Object)response.toByteArray());
                }
                catch (InvalidProtocolBufferException e) {
                    Handler.sendError(res, TwirpErrorCode.MALFORMED, "Malformed content", null);
                }
                catch (Exception e) {
                    Handler.sendError(res, TwirpErrorCode.INTERNAL, e.toString(), Collections.singletonMap("stackTrace", ExceptionUtils.getStackTrace((Throwable)e)));
                }
            });
        } else if (contentType.equals((Object)JSON_MEDIA_TYPE)) {
            req.content().as(String.class).thenAccept(contentString -> {
                try {
                    JsonFormat.parser().merge(contentString, messageBuilder);
                    Message response = (Message)serviceInvoker.get();
                    String json = JsonFormat.printer().print((MessageOrBuilder)response);
                    res.headers().contentType(contentType);
                    res.send((Object)json);
                }
                catch (InvalidProtocolBufferException e) {
                    Handler.sendError(res, TwirpErrorCode.MALFORMED, "Malformed content", null);
                }
                catch (Exception e) {
                    Handler.sendError(res, TwirpErrorCode.INTERNAL, e.toString(), Collections.singletonMap("stackTrace", ExceptionUtils.getStackTrace((Throwable)e)));
                }
            });
        } else {
            Handler.sendError(res, TwirpErrorCode.INVALID_ARGUMENT, "Content-Type not supported", null);
        }
    }

    public static void sendError(ServerResponse res, TwirpErrorCode errorCode, String msg, Map<String, String> meta) {
        res.status(errorCode.getHttpStatus());
        try {
            TwirpError error = new TwirpError();
            error.setCode(errorCode.getCode());
            error.setMsg(msg);
            error.setMeta(meta);
            String errorJson = TwirpError.toJson((TwirpError)error);
            res.headers().contentType(JSON_MEDIA_TYPE);
            res.send((Object)errorJson);
        }
        catch (IOException e) {
            res.send();
        }
    }
}

