/*
 * Decompiled with CFR 0.152.
 */
package io.github.nik9000.mapmatcher;

import io.github.nik9000.mapmatcher.ListMatcher;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.StringDescription;
import org.hamcrest.TypeSafeMatcher;

public class MapMatcher
extends TypeSafeMatcher<Map<?, ?>> {
    private static final int INDENT = 2;
    private final Map<Object, Matcher<?>> matchers;
    private final boolean extraOk;

    public static MapMatcher matchesMap() {
        return new MapMatcher(Collections.emptyMap(), false);
    }

    public static MapMatcher matchesMap(Map<?, ?> map) {
        MapMatcher matcher = MapMatcher.matchesMap();
        for (Map.Entry<?, ?> e : map.entrySet()) {
            matcher = matcher.entry(e.getKey(), e.getValue());
        }
        return matcher;
    }

    public static <T> void assertMap(T actual, Matcher<? super T> matcher) {
        MapMatcher.assertMap("", actual, matcher);
    }

    public static <T> void assertMap(String reason, T actual, Matcher<? super T> matcher) {
        if (matcher.matches(actual)) {
            return;
        }
        StringDescription description = new StringDescription();
        description.appendText(reason).appendText("Expected ");
        matcher.describeMismatch(actual, (Description)description);
        throw new AssertionError((Object)description.toString());
    }

    private MapMatcher(Map<Object, Matcher<?>> matchers, boolean extraOk) {
        this.matchers = matchers;
        this.extraOk = extraOk;
    }

    public MapMatcher extraOk() {
        return new MapMatcher(this.matchers, true);
    }

    public MapMatcher entry(Object key, Object value) {
        return this.entry(key, MapMatcher.matcherFor(value));
    }

    public MapMatcher entry(Object key, Matcher<?> valueMatcher) {
        LinkedHashMap matchers;
        Matcher old;
        if (valueMatcher == null) {
            valueMatcher = Matchers.nullValue();
        }
        if ((old = (matchers = new LinkedHashMap(this.matchers)).put(key, valueMatcher)) != null) {
            throw new IllegalArgumentException("Already had an entry for [" + key + "]: " + old);
        }
        return new MapMatcher(matchers, this.extraOk);
    }

    public void describeTo(Description description) {
        this.describeTo(this.keyWidth(Collections.emptyMap()), description);
    }

    int keyWidth(Map<?, ?> item) {
        int max = 0;
        for (Object obj : item.keySet()) {
            max = Math.max(max, obj.toString().length());
        }
        for (Map.Entry entry : this.matchers.entrySet()) {
            max = Math.max(max, entry.getKey().toString().length());
            max = Math.max(max, MapMatcher.maxKeyWidthForMatcher(item.get(entry.getKey()), (Matcher)entry.getValue()));
        }
        return max;
    }

    static int maxKeyWidthForMatcher(Object item, Matcher<?> matcher) {
        if (matcher instanceof MapMatcher) {
            Map longestSubMap = item instanceof Map ? (Map)item : Collections.emptyMap();
            return ((MapMatcher)matcher).keyWidth(longestSubMap) - 2;
        }
        if (matcher instanceof ListMatcher) {
            List longestSubList = item instanceof List ? (List)item : Collections.emptyList();
            return ((ListMatcher)matcher).keyWidth(longestSubList) - 2;
        }
        return 0;
    }

    void describeTo(int keyWidth, Description description) {
        description.appendText(this.matchers.isEmpty() ? "an empty map" : "a map containing");
        for (Map.Entry<Object, Matcher<?>> e : this.matchers.entrySet()) {
            MapMatcher.describeMatcher(keyWidth, e.getKey(), e.getValue(), description);
        }
    }

    static void describeMatcher(int keyWidth, Object key, Matcher<?> matcher, Description description) {
        String keyFormat = "\n%" + keyWidth + "s";
        description.appendText(String.format(Locale.ROOT, keyFormat, key)).appendText(": ");
        if (matcher instanceof MapMatcher) {
            ((MapMatcher)matcher).describeTo(keyWidth + 2, description);
            return;
        }
        if (matcher instanceof ListMatcher) {
            ((ListMatcher)matcher).describeTo(keyWidth + 2, description);
            return;
        }
        description.appendDescriptionOf(matcher);
    }

    protected boolean matchesSafely(Map<?, ?> item) {
        if (this.extraOk ? false == item.keySet().containsAll(this.matchers.keySet()) : false == item.keySet().equals(this.matchers.keySet())) {
            return false;
        }
        for (Map.Entry<Object, Matcher<?>> e : this.matchers.entrySet()) {
            if (!item.containsKey(e.getKey())) {
                return false;
            }
            Object v = item.get(e.getKey());
            if (e.getValue().matches(v)) continue;
            return false;
        }
        return true;
    }

    protected void describeMismatchSafely(Map<?, ?> item, Description description) {
        this.describePotentialMismatch(this.keyWidth(item), item, description);
    }

    void describePotentialMismatch(int keyWidth, Map<?, ?> item, Description description) {
        description.appendText(this.matchers.isEmpty() ? "an empty map" : "a map containing");
        int maxKeyWidth = Stream.concat(this.matchers.keySet().stream(), item.keySet().stream()).mapToInt(k -> k.toString().length()).max().getAsInt();
        String keyFormat = "%" + maxKeyWidth + "s";
        for (Map.Entry<Object, Matcher<?>> entry : this.matchers.entrySet()) {
            MapMatcher.describeEntry(keyWidth, String.format(Locale.ROOT, keyFormat, entry.getKey()), description);
            if (!item.containsKey(entry.getKey())) {
                MapMatcher.describeEntryMissing(entry.getValue(), description);
                continue;
            }
            MapMatcher.describeEntryValue(keyWidth, entry.getValue(), item.get(entry.getKey()), description);
        }
        for (Map.Entry<Object, Object> entry : item.entrySet()) {
            if (this.matchers.containsKey(entry.getKey())) continue;
            MapMatcher.describeEntry(keyWidth, String.format(Locale.ROOT, keyFormat, entry.getKey()), description);
            if (this.extraOk) {
                MapMatcher.describeEntryUnexepectedButOk(entry.getValue(), description);
                continue;
            }
            MapMatcher.describeEntryUnexepected(entry.getValue(), description);
        }
    }

    static Matcher<?> matcherFor(Object value) {
        if (value == null) {
            return Matchers.nullValue();
        }
        if (value instanceof List) {
            return ListMatcher.matchesList((List)value);
        }
        if (value instanceof Map) {
            return MapMatcher.matchesMap((Map)value);
        }
        if (value instanceof Matcher) {
            return (Matcher)value;
        }
        return Matchers.equalTo((Object)value);
    }

    static void describeEntry(int keyWidth, Object key, Description description) {
        String keyFormat = "\n%" + keyWidth + "s";
        description.appendText(String.format(Locale.ROOT, keyFormat, key)).appendText(": ");
    }

    static void describeEntryMissing(Matcher<?> matcher, Description description) {
        description.appendText("expected ");
        if (matcher instanceof MapMatcher) {
            description.appendText("a map");
        } else if (matcher instanceof ListMatcher) {
            description.appendText("a list");
        } else {
            description.appendDescriptionOf(matcher);
        }
        description.appendText(" but was <missing>");
    }

    static void describeEntryUnexepected(Object value, Description description) {
        description.appendText("<unexpected> but was ");
        description.appendValue(value);
    }

    static void describeEntryUnexepectedButOk(Object value, Description description) {
        description.appendValue(value);
        description.appendText(" unexpected but ok");
    }

    static void describeEntryValue(int keyWidth, Matcher<?> matcher, Object v, Description description) {
        if (v instanceof Map && matcher instanceof MapMatcher) {
            ((MapMatcher)matcher).describePotentialMismatch(keyWidth + 2, (Map)v, description);
            return;
        }
        if (v instanceof List && matcher instanceof ListMatcher) {
            ((ListMatcher)matcher).describePotentialMismatch(keyWidth + 2, (List)v, description);
            return;
        }
        if (!matcher.matches(v)) {
            description.appendText("expected ").appendDescriptionOf(matcher).appendText(" but ");
            matcher.describeMismatch(v, description);
            return;
        }
        description.appendValue(v);
    }
}

