/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.axml.parsers;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import pxb.android.axml.AxmlReader;
import pxb.android.axml.AxmlVisitor;
import pxb.android.axml.NodeVisitor;
import pxb.android.axml.ValueWrapper;
import soot.Scene;
import soot.SootClass;
import soot.SootField;
import soot.SootResolver;
import soot.jimple.infoflow.android.axml.AXmlAttribute;
import soot.jimple.infoflow.android.axml.AXmlColorValue;
import soot.jimple.infoflow.android.axml.AXmlComplexValue;
import soot.jimple.infoflow.android.axml.AXmlNamespace;
import soot.jimple.infoflow.android.axml.AXmlNode;
import soot.jimple.infoflow.android.axml.parsers.AbstractBinaryXMLFileParser;
import soot.tagkit.IntegerConstantValueTag;
import soot.tagkit.Tag;

public class AXML20Parser
extends AbstractBinaryXMLFileParser {
    private final Map<Integer, String> idToNameMap = new HashMap<Integer, String>();

    @Override
    public void parseFile(byte[] buffer) throws IOException {
        AxmlReader rdr = new AxmlReader(buffer);
        rdr.accept((AxmlVisitor)new MyNodeVisitor());
    }

    private class MyNodeVisitor
    extends AxmlVisitor {
        public final AXmlNode node;

        public MyNodeVisitor() {
            this.node = new AXmlNode("dummy", "", null);
        }

        public MyNodeVisitor(AXmlNode node) {
            this.node = node;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void attr(String ns, String name, int resourceId, int type, Object obj) {
            AXmlColorValue colorVal;
            AXmlColorValue colorVal2;
            ValueWrapper wrapper;
            if (this.node == null) {
                throw new RuntimeException("NULL nodes cannot have attributes");
            }
            String tname = name;
            if (tname == null || tname.isEmpty()) {
                tname = (String)AXML20Parser.this.idToNameMap.get(resourceId);
                if (tname == null) {
                    block36: {
                        try {
                            SootClass rClass = Scene.v().forceResolve("android.R$attr", 3);
                            if (rClass == null) {
                                return;
                            }
                            block2: for (SootField sf : rClass.getFields()) {
                                for (Tag t : sf.getTags()) {
                                    if (!(t instanceof IntegerConstantValueTag)) continue;
                                    IntegerConstantValueTag cvt = (IntegerConstantValueTag)t;
                                    if (cvt.getIntValue() != resourceId) continue block2;
                                    tname = sf.getName();
                                    AXML20Parser.this.idToNameMap.put(resourceId, tname);
                                    ns = "http://schemas.android.com/apk/res/android";
                                    break block36;
                                }
                            }
                        }
                        catch (SootResolver.SootClassNotFoundException ex) {
                            return;
                        }
                    }
                    if (tname == null) {
                        tname = String.valueOf(resourceId);
                    }
                }
            } else {
                tname = name.trim();
            }
            if (type == 1 || type == 17 || type == 16) {
                if (obj instanceof Integer) {
                    this.node.addAttribute(new AXmlAttribute<Integer>(tname, resourceId, type, (Integer)obj, ns, false));
                } else {
                    if (!(obj instanceof ValueWrapper)) throw new RuntimeException("Unsupported value type");
                    wrapper = (ValueWrapper)obj;
                    if (wrapper.raw != null) {
                        this.node.addAttribute(new AXmlAttribute<String>(tname, resourceId, type, wrapper.raw, ns, false));
                    } else if (wrapper.type == 1) {
                        this.node.addAttribute(new AXmlAttribute<Integer>(tname, resourceId, type, wrapper.ref, ns, false));
                    }
                }
            } else if (type == 3) {
                if (obj instanceof String) {
                    this.node.addAttribute(new AXmlAttribute<String>(tname, resourceId, type, (String)obj, ns, false));
                } else {
                    if (!(obj instanceof ValueWrapper)) throw new RuntimeException("Unsupported value type");
                    wrapper = (ValueWrapper)obj;
                    this.node.addAttribute(new AXmlAttribute<String>(tname, resourceId, type, wrapper.raw, ns, false));
                }
            } else if (type == 18) {
                if (obj instanceof Boolean) {
                    this.node.addAttribute(new AXmlAttribute<Boolean>(tname, resourceId, type, (Boolean)obj, ns, false));
                } else {
                    if (!(obj instanceof ValueWrapper)) throw new RuntimeException("Unsupported value type");
                    wrapper = (ValueWrapper)obj;
                    this.node.addAttribute(new AXmlAttribute<Boolean>(tname, resourceId, type, Boolean.valueOf(wrapper.raw), ns, false));
                }
            } else if (type == 4) {
                if (!(obj instanceof Integer)) throw new RuntimeException("Unsupported value type");
                float floatVal = Float.intBitsToFloat((Integer)obj);
                this.node.addAttribute(new AXmlAttribute<Float>(tname, resourceId, type, Float.valueOf(floatVal), ns, false));
            } else if (type == 5) {
                if (!(obj instanceof Integer)) throw new RuntimeException("Unsupported value type");
                AXmlComplexValue complexValue = this.parseComplexValue((Integer)obj);
                this.node.addAttribute(new AXmlAttribute<AXmlComplexValue>(tname, resourceId, type, complexValue, ns, false));
            } else if (type == 28) {
                if (!(obj instanceof Integer)) throw new RuntimeException("Unsupported value type");
                int color = (Integer)obj;
                int bb = color & 0xFF;
                int gg = (color & 0xFF00) >> 8;
                int rr = (color & 0xFF0000) >> 16;
                int aa = (color & 0xFF000000) >> 24;
                colorVal2 = new AXmlColorValue(aa, rr, gg, bb);
                this.node.addAttribute(new AXmlAttribute<AXmlColorValue>(tname, resourceId, type, colorVal2, ns, false));
            } else if (type == 30) {
                if (!(obj instanceof Integer)) throw new RuntimeException("Unsupported value type");
                int color = (Integer)obj;
                int b = color & 0xF0;
                int g = color & 0xF0;
                int r = (color & 0xF00) >> 4;
                int a = (color & 0xF000) >> 8;
                colorVal2 = new AXmlColorValue(a, r, g, b);
                this.node.addAttribute(new AXmlAttribute<AXmlColorValue>(tname, resourceId, type, colorVal2, ns, false));
            } else if (type == 29) {
                if (!(obj instanceof Integer)) throw new RuntimeException("Unsupported value type");
                int color = (Integer)obj;
                int bb = color & 0xFF;
                int gg = (color & 0xFF00) >> 8;
                int rr = (color & 0xFF0000) >> 16;
                colorVal = new AXmlColorValue(rr, gg, bb);
                this.node.addAttribute(new AXmlAttribute<AXmlColorValue>(tname, resourceId, type, colorVal, ns, false));
            } else if (type == 31) {
                if (!(obj instanceof Integer)) throw new RuntimeException("Unsupported value type");
                int color = (Integer)obj;
                int b = color & 0xF0;
                int g = color & 0xF0;
                int r = (color & 0xF00) >> 4;
                colorVal = new AXmlColorValue(r, g, b);
                this.node.addAttribute(new AXmlAttribute<AXmlColorValue>(tname, resourceId, type, colorVal, ns, false));
            }
            super.attr(ns, name, resourceId, type, obj);
        }

        private AXmlComplexValue parseComplexValue(int complexValue) {
            int unitVal = complexValue >> 0;
            AXmlComplexValue.Unit complexUnit = this.parseComplexUnit(unitVal &= 0xF);
            int radixVal = complexValue >> 4;
            int mantissa = complexValue >> 8;
            return new AXmlComplexValue(complexUnit, mantissa &= 0xFFFFFF, radixVal &= 3);
        }

        private AXmlComplexValue.Unit parseComplexUnit(int unitVal) {
            switch (unitVal) {
                case 1: {
                    return AXmlComplexValue.Unit.DIP;
                }
                case 4: {
                    return AXmlComplexValue.Unit.IN;
                }
                case 5: {
                    return AXmlComplexValue.Unit.MM;
                }
                case 3: {
                    return AXmlComplexValue.Unit.PT;
                }
                case 0: {
                    return AXmlComplexValue.Unit.PX;
                }
                case 2: {
                    return AXmlComplexValue.Unit.SP;
                }
            }
            throw new RuntimeException(String.format("Unknown complex unit %d", unitVal));
        }

        public NodeVisitor child(String ns, String name) {
            AXmlNode childNode = new AXmlNode(name == null ? null : name.trim(), ns == null ? null : ns.trim(), this.node);
            if (name != null) {
                AXML20Parser.this.addPointer(name, childNode);
            }
            return new MyNodeVisitor(childNode);
        }

        public void end() {
            AXML20Parser.this.document.setRootNode(this.node);
        }

        public void ns(String prefix, String uri, int line) {
            AXML20Parser.this.document.addNamespace(new AXmlNamespace(prefix, uri, line));
        }

        public void text(int lineNumber, String value) {
            this.node.setText(value);
            super.text(lineNumber, value);
        }
    }
}

