/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.callbacks.filters;

import java.util.Set;
import soot.FastHierarchy;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.jimple.infoflow.android.callbacks.filters.AbstractCallbackFilter;
import soot.jimple.infoflow.android.entryPointCreators.AndroidEntryPointConstants;

public class ApplicationCallbackFilter
extends AbstractCallbackFilter {
    private final String applicationClass;
    private RefType activityLifecycleCallbacks;
    private RefType provideAssistDataListener;
    private RefType componentCallbacks;
    private RefType componentCallbacks2;

    public ApplicationCallbackFilter(Set<SootClass> entrypoints) {
        this(ApplicationCallbackFilter.getApplicationClass(entrypoints));
    }

    private static String getApplicationClass(Set<SootClass> entrypoints) {
        SootClass scApplication = Scene.v().getSootClassUnsafe("android.app.Application");
        for (SootClass sc : entrypoints) {
            if (sc == null || scApplication == null || !Scene.v().getOrMakeFastHierarchy().canStoreType((Type)sc.getType(), (Type)scApplication.getType())) continue;
            return sc.getName();
        }
        return null;
    }

    public ApplicationCallbackFilter(String applicationClass) {
        this.applicationClass = applicationClass;
        this.reset();
    }

    @Override
    public boolean accepts(SootClass component, SootClass callbackHandler) {
        RefType callbackType;
        FastHierarchy fh;
        return this.applicationClass == null || !component.getName().equals(this.applicationClass) || callbackHandler.getName().equals(this.applicationClass) || (fh = Scene.v().getOrMakeFastHierarchy()).canStoreType((Type)(callbackType = callbackHandler.getType()), (Type)this.activityLifecycleCallbacks) || fh.canStoreType((Type)callbackType, (Type)this.provideAssistDataListener) || fh.canStoreType((Type)callbackType, (Type)this.componentCallbacks);
    }

    @Override
    public void reset() {
        this.activityLifecycleCallbacks = RefType.v((String)"android.app.Application$ActivityLifecycleCallbacks");
        this.provideAssistDataListener = RefType.v((String)"android.app.Application$OnProvideAssistDataListener");
        this.componentCallbacks = RefType.v((String)"android.content.ComponentCallbacks");
        this.componentCallbacks2 = RefType.v((String)"android.content.ComponentCallbacks2");
    }

    @Override
    public boolean accepts(SootClass component, SootMethod callback) {
        if (component.getName().equals(this.applicationClass)) {
            return true;
        }
        String subSig = callback.getSubSignature();
        FastHierarchy fh = Scene.v().getOrMakeFastHierarchy();
        RefType callbackType = callback.getDeclaringClass().getType();
        if (AndroidEntryPointConstants.getActivityLifecycleCallbackMethods().contains(subSig)) {
            return fh.canStoreType((Type)callbackType, (Type)this.activityLifecycleCallbacks);
        }
        if (AndroidEntryPointConstants.getComponentCallbackMethods().contains(subSig)) {
            return fh.canStoreType((Type)callbackType, (Type)this.componentCallbacks);
        }
        if (AndroidEntryPointConstants.getComponentCallback2Methods().contains(subSig)) {
            return fh.canStoreType((Type)callbackType, (Type)this.componentCallbacks2);
        }
        return true;
    }
}

