/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.callbacks.filters;

import soot.MethodOrMethodContext;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.jimple.infoflow.android.callbacks.filters.AbstractCallbackFilter;

public class UnreachableConstructorFilter
extends AbstractCallbackFilter {
    @Override
    public boolean accepts(SootClass component, SootClass callbackHandler) {
        if (this.reachableMethods == null) {
            return true;
        }
        if (component == callbackHandler) {
            return true;
        }
        RefType fragmentType = RefType.v((String)"android.app.Fragment");
        boolean isFragment = Scene.v().getFastHierarchy().canStoreType((Type)callbackHandler.getType(), (Type)fragmentType);
        if (isFragment) {
            return true;
        }
        SootClass curHandler = callbackHandler;
        while (curHandler.isInnerClass()) {
            SootClass outerClass = curHandler.getOuterClass();
            if (component == outerClass) {
                return true;
            }
            if (curHandler == outerClass) break;
            curHandler = outerClass;
        }
        boolean hasConstructor = false;
        for (SootMethod sm : callbackHandler.getMethods()) {
            if (!sm.isConstructor() || !this.reachableMethods.contains((MethodOrMethodContext)sm)) continue;
            hasConstructor = true;
            break;
        }
        return hasConstructor;
    }

    @Override
    public boolean accepts(SootClass component, SootMethod callback) {
        return true;
    }

    @Override
    public void reset() {
    }
}

