/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.data;

import java.util.Set;
import soot.RefType;
import soot.SootClass;
import soot.Type;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.data.FlowDroidMemoryManager;

public class AndroidMemoryManager
extends FlowDroidMemoryManager {
    private final Set<SootClass> components;
    private boolean componentFilterApplied = false;

    public AndroidMemoryManager(boolean tracingEnabled, FlowDroidMemoryManager.PathDataErasureMode erasePathData, Set<SootClass> components) {
        super(tracingEnabled, erasePathData);
        this.components = components;
    }

    public Abstraction handleMemoryObject(Abstraction obj) {
        if ((obj = super.handleMemoryObject(obj)) != null && obj.getAccessPath().getTaintSubFields()) {
            Type runtimeType;
            Type tp;
            if (obj.getAccessPath().isLocal()) {
                tp = obj.getAccessPath().getPlainValue().getType();
                runtimeType = obj.getAccessPath().getBaseType();
                if (this.isComponentType(tp) || this.isComponentType(runtimeType) || this.isFilteredSystemType(tp) || this.isFilteredSystemType(runtimeType)) {
                    this.componentFilterApplied = true;
                    return null;
                }
            }
            if (obj.getAccessPath().isInstanceFieldRef()) {
                tp = obj.getAccessPath().getLastField().getType();
                runtimeType = obj.getAccessPath().getLastFieldType();
                if (this.isComponentType(tp) || this.isComponentType(runtimeType) || this.isFilteredSystemType(tp) || this.isFilteredSystemType(runtimeType)) {
                    this.componentFilterApplied = true;
                    return null;
                }
            }
        }
        return obj;
    }

    private boolean isFilteredSystemType(Type tp) {
        return false;
    }

    private boolean isComponentType(Type tp) {
        RefType rt;
        return tp != null && tp instanceof RefType && this.components.contains((rt = (RefType)tp).getSootClass());
    }

    public boolean getComponentFilterApplied() {
        return this.componentFilterApplied;
    }
}

