/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.data;

import soot.jimple.infoflow.sourcesSinks.definitions.ISourceSinkCategory;

public class CategoryDefinition
implements ISourceSinkCategory {
    private CATEGORY systemCategory = null;
    private String customCategory;
    private String customDescription;
    public static final CategoryDefinition NO_CATEGORY = new CategoryDefinition(CATEGORY.NO_CATEGORY);

    public CategoryDefinition(CATEGORY systemCategory) {
        this(systemCategory, null);
    }

    public CategoryDefinition(CATEGORY systemCategory, String customCategory) {
        this(systemCategory, customCategory, null);
    }

    public CategoryDefinition(CATEGORY systemCategory, String customCategory, String customDescription) {
        this.systemCategory = systemCategory;
        this.customCategory = customCategory;
        this.customDescription = customDescription;
    }

    public CATEGORY getSystemCategory() {
        return this.systemCategory;
    }

    public void setSystemCategory(CATEGORY systemCategory) {
        this.systemCategory = systemCategory;
    }

    public String getCustomCategory() {
        return this.customCategory;
    }

    public void setCustomCategory(String customCategory) {
        this.customCategory = customCategory;
    }

    public String getCustomDescription() {
        return this.customDescription;
    }

    public void setCustomDescription(String customDescription) {
        this.customDescription = customDescription;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.customCategory == null ? 0 : this.customCategory.hashCode());
        result = 31 * result + (this.customDescription == null ? 0 : this.customDescription.hashCode());
        result = 31 * result + (this.systemCategory == null ? 0 : this.systemCategory.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CategoryDefinition other = (CategoryDefinition)obj;
        if (this.customCategory == null ? other.customCategory != null : !this.customCategory.equals(other.customCategory)) {
            return false;
        }
        if (this.customDescription == null ? other.customDescription != null : !this.customDescription.equals(other.customDescription)) {
            return false;
        }
        return this.systemCategory == other.systemCategory;
    }

    public String toString() {
        if (this.customCategory == null || this.customCategory.isEmpty()) {
            if (this.systemCategory != null) {
                return this.systemCategory.toString();
            }
            return "<invalid>";
        }
        return this.customCategory;
    }

    public String getHumanReadableDescription() {
        if (this.customCategory != null && !this.customCategory.isEmpty()) {
            if (this.customDescription != null && !this.customDescription.isEmpty()) {
                return this.customDescription;
            }
            return this.customCategory;
        }
        if (this.systemCategory != null) {
            switch (this.systemCategory) {
                case ALL: {
                    return "All Categories";
                }
                case NO_CATEGORY: {
                    return "No Category";
                }
                case HARDWARE_INFO: {
                    return "Hardware Information";
                }
                case UNIQUE_IDENTIFIER: {
                    return "Unique Identifier";
                }
                case LOCATION_INFORMATION: {
                    return "Location Information";
                }
                case NETWORK_INFORMATION: {
                    return "Network Information";
                }
                case ACCOUNT_INFORMATION: {
                    return "Account Information";
                }
                case EMAIL_INFORMATION: {
                    return "E-Mail Information";
                }
                case FILE_INFORMATION: {
                    return "File Information";
                }
                case BLUETOOTH_INFORMATION: {
                    return "Bluetooth Information";
                }
                case VOIP_INFORMATION: {
                    return "Voice-over-IP Information";
                }
                case DATABASE_INFORMATION: {
                    return "Database Information";
                }
                case PHONE_INFORMATION: {
                    return "Phone Information";
                }
                case PHONE_CONNECTION: {
                    return "Phone (Line) Connection";
                }
                case INTER_APP_COMMUNICATION: {
                    return "Inter-App Communication";
                }
                case VOIP: {
                    return "Voice-over-IP";
                }
                case PHONE_STATE: {
                    return "Phone State";
                }
                case EMAIL: {
                    return "E-Mail";
                }
                case BLUETOOTH: {
                    return "Bluetooth";
                }
                case ACCOUNT_SETTINGS: {
                    return "Account Settings";
                }
                case VIDEO: {
                    return "Video";
                }
                case SYNCHRONIZATION_DATA: {
                    return "Synchronization Data";
                }
                case NETWORK: {
                    return "Network";
                }
                case EMAIL_SETTINGS: {
                    return "E-Mail Settings";
                }
                case FILE: {
                    return "File";
                }
                case LOG: {
                    return "Log Files";
                }
                case AUDIO: {
                    return "Audio";
                }
                case SMS_MMS: {
                    return "SMS / MMS";
                }
                case CONTACT_INFORMATION: {
                    return "Contact Information";
                }
                case CALENDAR_INFORMATION: {
                    return "Calendar Information";
                }
                case SYSTEM_SETTINGS: {
                    return "System Settings";
                }
                case IMAGE: {
                    return "Image";
                }
                case BROWSER_INFORMATION: {
                    return "Browser Information";
                }
                case NFC: {
                    return "NFC";
                }
            }
            return "<invalid system category>";
        }
        return "<invalid>";
    }

    public CategoryDefinition getIdOnlyDescription() {
        return new CategoryDefinition(this.systemCategory, this.customCategory);
    }

    public String getID() {
        if (this.systemCategory == null || this.systemCategory == CATEGORY.NO_CATEGORY) {
            return this.customCategory;
        }
        return this.systemCategory.name();
    }

    public static enum CATEGORY {
        ALL,
        NO_CATEGORY,
        HARDWARE_INFO,
        UNIQUE_IDENTIFIER,
        LOCATION_INFORMATION,
        NETWORK_INFORMATION,
        ACCOUNT_INFORMATION,
        EMAIL_INFORMATION,
        FILE_INFORMATION,
        BLUETOOTH_INFORMATION,
        VOIP_INFORMATION,
        DATABASE_INFORMATION,
        PHONE_INFORMATION,
        PHONE_CONNECTION,
        INTER_APP_COMMUNICATION,
        VOIP,
        PHONE_STATE,
        EMAIL,
        BLUETOOTH,
        ACCOUNT_SETTINGS,
        VIDEO,
        SYNCHRONIZATION_DATA,
        NETWORK,
        EMAIL_SETTINGS,
        FILE,
        LOG,
        AUDIO,
        SMS_MMS,
        CONTACT_INFORMATION,
        CALENDAR_INFORMATION,
        SYSTEM_SETTINGS,
        IMAGE,
        BROWSER_INFORMATION,
        NFC;

    }
}

