/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.data.parsers;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import soot.jimple.infoflow.android.data.AndroidMethod;
import soot.jimple.infoflow.android.data.CategoryDefinition;
import soot.jimple.infoflow.data.SootMethodAndClass;
import soot.jimple.infoflow.sourcesSinks.definitions.ISourceSinkCategory;
import soot.jimple.infoflow.sourcesSinks.definitions.ISourceSinkDefinition;
import soot.jimple.infoflow.sourcesSinks.definitions.MethodSourceSinkDefinition;
import soot.jimple.infoflow.sourcesSinks.definitions.SourceSinkType;

public class CategorizedAndroidSourceSinkParser {
    private Set<CategoryDefinition> categories;
    private final String fileName;
    private SourceSinkType sourceSinkType;
    private final String regex = "^<(.+):\\s*(.+)\\s+(.+)\\s*\\((.*)\\)>.+?\\((.+)\\)$";

    public CategorizedAndroidSourceSinkParser(Set<CategoryDefinition> categories, String filename, SourceSinkType sourceSinkType) {
        this.categories = categories;
        this.fileName = filename;
        this.sourceSinkType = sourceSinkType;
    }

    public Set<ISourceSinkDefinition> parse() throws IOException {
        HashSet<ISourceSinkDefinition> definitions = new HashSet<ISourceSinkDefinition>();
        CategoryDefinition allCats = new CategoryDefinition(CategoryDefinition.CATEGORY.ALL);
        boolean loadAllCategories = this.categories.contains(allCats);
        BufferedReader rdr = this.readFile();
        if (rdr == null) {
            throw new RuntimeException("Could not read source/sink file");
        }
        String line = null;
        Pattern p = Pattern.compile("^<(.+):\\s*(.+)\\s+(.+)\\s*\\((.*)\\)>.+?\\((.+)\\)$");
        while ((line = rdr.readLine()) != null) {
            Matcher m = p.matcher(line);
            if (!m.find()) continue;
            CategoryDefinition.CATEGORY strCat = CategoryDefinition.CATEGORY.valueOf(m.group(5));
            CategoryDefinition cat = new CategoryDefinition(strCat);
            if (!loadAllCategories && !this.categories.contains(cat)) continue;
            AndroidMethod method = this.parseMethod(m);
            method.setSourceSinkType(this.sourceSinkType);
            MethodSourceSinkDefinition def = new MethodSourceSinkDefinition((SootMethodAndClass)method);
            def.setCategory((ISourceSinkCategory)cat);
            definitions.add((ISourceSinkDefinition)def);
        }
        try {
            if (rdr != null) {
                rdr.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return definitions;
    }

    private BufferedReader readFile() {
        FileReader fr = null;
        BufferedReader br = null;
        try {
            fr = new FileReader(this.fileName);
            br = new BufferedReader(fr);
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        return br;
    }

    private AndroidMethod parseMethod(Matcher m) {
        String params;
        assert (m.group(1) != null && m.group(2) != null && m.group(3) != null && m.group(4) != null);
        int groupIdx = 1;
        String className = m.group(groupIdx++).trim();
        String returnType = m.group(groupIdx++).trim();
        String methodName = m.group(groupIdx++).trim();
        ArrayList<String> methodParameters = new ArrayList<String>();
        if (!(params = m.group(groupIdx++).trim()).isEmpty()) {
            for (String parameter : params.split(",")) {
                methodParameters.add(parameter.trim());
            }
        }
        return new AndroidMethod(methodName, methodParameters, returnType, className);
    }
}

