/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.entryPointCreators;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import soot.Local;
import soot.SootClass;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.Jimple;
import soot.jimple.NopStmt;
import soot.jimple.Stmt;
import soot.jimple.infoflow.android.entryPointCreators.AndroidEntryPointConstants;
import soot.jimple.infoflow.android.entryPointCreators.AndroidEntryPointUtils;
import soot.jimple.infoflow.android.manifest.IManifestHandler;
import soot.jimple.infoflow.entryPointCreators.BaseEntryPointCreator;
import soot.jimple.infoflow.util.SystemClassHandler;

public abstract class AbstractAndroidEntryPointCreator
extends BaseEntryPointCreator {
    protected AndroidEntryPointUtils entryPointUtils = null;
    protected IManifestHandler manifest;

    public AbstractAndroidEntryPointCreator(IManifestHandler manifest) {
        this.manifest = manifest;
    }

    public SootMethod createDummyMain() {
        this.entryPointUtils = new AndroidEntryPointUtils();
        return super.createDummyMain();
    }

    protected Stmt searchAndBuildMethod(String subsignature, SootClass currentClass, Local classLocal) {
        return this.searchAndBuildMethod(subsignature, currentClass, classLocal, Collections.emptySet());
    }

    protected Stmt searchAndBuildMethod(String subsignature, SootClass currentClass, Local classLocal, Set<SootClass> parentClasses) {
        if (currentClass == null || classLocal == null) {
            return null;
        }
        SootMethod method = this.findMethod(currentClass, subsignature);
        if (method == null) {
            this.logger.warn("Could not find Android entry point method: {}", (Object)subsignature);
            return null;
        }
        if (AndroidEntryPointConstants.isLifecycleClass(method.getDeclaringClass().getName())) {
            return null;
        }
        if (SystemClassHandler.v().isClassInSystemPackage(method.getDeclaringClass().getName())) {
            return null;
        }
        assert (method.isStatic() || classLocal != null) : "Class local was null for non-static method " + method.getSignature();
        return this.buildMethodCall(method, classLocal, parentClasses);
    }

    protected boolean createPlainMethodCall(Local classLocal, SootMethod currentMethod) {
        if (AndroidEntryPointConstants.getServiceLifecycleMethods().contains(currentMethod.getSubSignature())) {
            return false;
        }
        NopStmt beforeStmt = Jimple.v().newNopStmt();
        NopStmt thenStmt = Jimple.v().newNopStmt();
        this.body.getUnits().add((Unit)beforeStmt);
        this.createIfStmt((Unit)thenStmt);
        this.buildMethodCall(currentMethod, classLocal);
        this.body.getUnits().add((Unit)thenStmt);
        this.createIfStmt((Unit)beforeStmt);
        return true;
    }

    public void setEntryPointUtils(AndroidEntryPointUtils entryPointUtils) {
        this.entryPointUtils = entryPointUtils;
    }

    protected void createClassInstances(Collection<SootClass> classes) {
        for (SootClass callbackClass : classes) {
            NopStmt thenStmt = Jimple.v().newNopStmt();
            this.createIfStmt((Unit)thenStmt);
            Local l = (Local)this.localVarsForClasses.get(callbackClass);
            if (l == null && (l = this.generateClassConstructor(callbackClass)) != null) {
                this.localVarsForClasses.put(callbackClass, l);
            }
            this.body.getUnits().add((Unit)thenStmt);
        }
    }
}

