/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.iccta;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.Local;
import soot.LocalGenerator;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.Stmt;
import soot.jimple.infoflow.android.entryPointCreators.components.ComponentEntryPointCollection;
import soot.jimple.infoflow.android.iccta.Ic3Provider;
import soot.jimple.infoflow.android.iccta.IccLink;
import soot.jimple.infoflow.android.iccta.IccRedirectionCreator;
import soot.jimple.infoflow.android.iccta.MessageHandler;
import soot.jimple.infoflow.entryPointCreators.SimulatedCodeElementTag;
import soot.jimple.infoflow.handlers.PreAnalysisHandler;
import soot.tagkit.Tag;
import soot.util.Chain;
import soot.util.HashMultiMap;
import soot.util.MultiMap;

public class IccInstrumenter
implements PreAnalysisHandler {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final String iccModel;
    protected final SootClass dummyMainClass;
    protected final ComponentEntryPointCollection componentToEntryPoint;
    protected IccRedirectionCreator redirectionCreator = null;
    protected final SootMethod smMessengerSend;
    protected final Set<SootMethod> processedMethods = new HashSet<SootMethod>();
    protected final MultiMap<Body, Unit> instrumentedUnits = new HashMultiMap();

    public IccInstrumenter(String iccModel, SootClass dummyMainClass, ComponentEntryPointCollection componentToEntryPoint) {
        this.iccModel = iccModel;
        this.dummyMainClass = dummyMainClass;
        this.componentToEntryPoint = componentToEntryPoint;
        this.smMessengerSend = Scene.v().grabMethod("<android.os.Messenger: void send(android.os.Message)>");
    }

    public void onBeforeCallgraphConstruction() {
        this.logger.info("[IccTA] Launching IccTA Transformer...");
        this.logger.info("[IccTA] Loading the ICC Model...");
        Ic3Provider provider = new Ic3Provider(this.iccModel);
        List<IccLink> iccLinks = provider.getIccLinks();
        this.logger.info("[IccTA] ...End Loading the ICC Model");
        if (this.redirectionCreator == null) {
            this.redirectionCreator = new IccRedirectionCreator(this.dummyMainClass, this.componentToEntryPoint);
        } else {
            this.redirectionCreator.undoInstrumentation();
        }
        this.logger.info("[IccTA] Lauching ICC Redirection Creation...");
        for (IccLink link : iccLinks) {
            if (link.fromU == null) continue;
            this.redirectionCreator.redirectToDestination(link);
        }
        this.undoInstrumentation();
        this.instrumentMessenger();
        this.processedMethods.clear();
        this.logger.info("[IccTA] ...End ICC Redirection Creation");
    }

    protected void undoInstrumentation() {
        for (Body body : this.instrumentedUnits.keySet()) {
            for (Unit u : this.instrumentedUnits.get((Object)body)) {
                body.getUnits().remove((Object)u);
            }
        }
        this.instrumentedUnits.clear();
    }

    protected void instrumentMessenger() {
        this.logger.info("Launching Messenger Transformer...");
        Chain applicationClasses = Scene.v().getApplicationClasses();
        Iterator iter = applicationClasses.snapshotIterator();
        while (iter.hasNext()) {
            SootClass sootClass = (SootClass)iter.next();
            ArrayList methodCopyList = new ArrayList(sootClass.getMethods());
            for (SootMethod sootMethod : methodCopyList) {
                if (!sootMethod.isConcrete()) continue;
                Body body = sootMethod.retrieveActiveBody();
                LocalGenerator lg = Scene.v().createLocalGenerator(body);
                if (!this.processedMethods.add(sootMethod)) continue;
                Iterator unitIter = body.getUnits().snapshotIterator();
                while (unitIter.hasNext()) {
                    SootMethod callee;
                    Stmt stmt = (Stmt)unitIter.next();
                    if (!stmt.containsInvokeExpr() || (callee = stmt.getInvokeExpr().getMethod()) != this.smMessengerSend) continue;
                    Set<SootClass> handlers = MessageHandler.v().getAllHandlers();
                    for (SootClass handler : handlers) {
                        Local handlerLocal = lg.generateLocal((Type)handler.getType());
                        AssignStmt newU = Jimple.v().newAssignStmt((Value)handlerLocal, (Value)Jimple.v().newNewExpr(handler.getType()));
                        newU.addTag((Tag)SimulatedCodeElementTag.TAG);
                        body.getUnits().insertAfter((Unit)newU, (Unit)stmt);
                        this.instrumentedUnits.put((Object)body, (Object)newU);
                        SootMethod initMethod = handler.getMethod("void <init>()");
                        InvokeStmt initU = Jimple.v().newInvokeStmt((Value)Jimple.v().newSpecialInvokeExpr(handlerLocal, initMethod.makeRef()));
                        initU.addTag((Tag)SimulatedCodeElementTag.TAG);
                        body.getUnits().insertAfter((Unit)initU, (Unit)newU);
                        this.instrumentedUnits.put((Object)body, (Object)initU);
                        SootMethod hmMethod = handler.getMethod("void handleMessage(android.os.Message)");
                        InvokeStmt callHMU = Jimple.v().newInvokeStmt((Value)Jimple.v().newVirtualInvokeExpr(handlerLocal, hmMethod.makeRef(), stmt.getInvokeExpr().getArg(0)));
                        callHMU.addTag((Tag)SimulatedCodeElementTag.TAG);
                        body.getUnits().insertAfter((Unit)callHMU, (Unit)initU);
                        this.instrumentedUnits.put((Object)body, (Object)callHMU);
                    }
                }
                body.validate();
            }
        }
    }

    public void onAfterCallgraphConstruction() {
    }
}

