/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.iccta;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.Local;
import soot.LocalGenerator;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.Type;
import soot.Unit;
import soot.UnitPatchingChain;
import soot.Value;
import soot.ValueBox;
import soot.VoidType;
import soot.jimple.AssignStmt;
import soot.jimple.IdentityStmt;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.IntConstant;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.NullConstant;
import soot.jimple.Stmt;
import soot.jimple.VirtualInvokeExpr;
import soot.jimple.infoflow.android.entryPointCreators.components.ActivityEntryPointInfo;
import soot.jimple.infoflow.android.entryPointCreators.components.ComponentEntryPointCollection;
import soot.jimple.infoflow.android.entryPointCreators.components.ServiceEntryPointInfo;
import soot.jimple.infoflow.android.iccta.IccLink;
import soot.jimple.infoflow.entryPointCreators.SimulatedCodeElementTag;
import soot.jimple.infoflow.util.SystemClassHandler;
import soot.tagkit.Tag;
import soot.util.HashMultiMap;
import soot.util.MultiMap;
import soot.util.NumberedString;

public class IccRedirectionCreator {
    private static int num = 0;
    private static final Logger logger = LoggerFactory.getLogger(IccRedirectionCreator.class);
    private final RefType INTENT_TYPE = RefType.v((String)"android.content.Intent");
    private final RefType IBINDER_TYPE = RefType.v((String)"android.os.IBinder");
    protected final Map<String, SootMethod> source2RedirectMethod = new HashMap<String, SootMethod>();
    protected final MultiMap<Body, Unit> instrumentedUnits = new HashMultiMap();
    protected final SootClass dummyMainClass;
    protected final ComponentEntryPointCollection componentToEntryPoint;
    protected final NumberedString subsigStartActivityForResult;
    protected IRedirectorCallInserted instrumentationCallback = null;

    public IccRedirectionCreator(SootClass dummyMainClass, ComponentEntryPointCollection componentToEntryPoint) {
        this.componentToEntryPoint = componentToEntryPoint;
        this.dummyMainClass = dummyMainClass;
        this.subsigStartActivityForResult = Scene.v().getSubSigNumberer().findOrAdd("void startActivityForResult(android.content.Intent,int)");
    }

    public void redirectToDestination(IccLink link) {
        if (link.getDestinationC().isPhantom()) {
            return;
        }
        if (SystemClassHandler.v().isClassInSystemPackage(link.getFromSM().getDeclaringClass().getName())) {
            return;
        }
        SootMethod redirectSM = this.getRedirectMethod(link);
        if (redirectSM == null) {
            return;
        }
        this.insertRedirectMethodCallAfterIccMethod(link, redirectSM);
    }

    protected SootMethod getRedirectMethod(IccLink link) {
        SootClass instrumentedDestinationSC = link.getDestinationC();
        if (!this.componentToEntryPoint.hasEntryPointForComponent(instrumentedDestinationSC)) {
            return null;
        }
        SootMethod redirectMethod = this.source2RedirectMethod.get(link.toString());
        if (redirectMethod == null) {
            RefType rt;
            Value v;
            RefType rt2;
            InstanceInvokeExpr iiexpr;
            Type tp;
            Value expr;
            String source = link.toString();
            Stmt stmt = (Stmt)link.getFromU();
            if (stmt.containsInvokeExpr() && (stmt.getInvokeExpr().getMethod().getName().equals("startActivityForResult") ? (expr = stmt.getInvokeExprBox().getValue()) instanceof InstanceInvokeExpr && (tp = (iiexpr = (InstanceInvokeExpr)expr).getBase().getType()) instanceof RefType && (redirectMethod = this.generateRedirectMethodForStartActivityForResult((rt2 = (RefType)tp).getSootClass(), instrumentedDestinationSC)) == null : (stmt.getInvokeExpr().getMethod().getName().equals("bindService") ? (v = stmt.getInvokeExpr().getArg(1)).getType() instanceof RefType && (redirectMethod = this.generateRedirectMethodForBindService((rt = (RefType)v.getType()).getSootClass(), instrumentedDestinationSC)) == null : (redirectMethod = this.generateRedirectMethod(instrumentedDestinationSC)) == null))) {
                return null;
            }
            if (redirectMethod == null) {
                throw new RuntimeException("Wrong IccLink [" + link.toString() + "]");
            }
            this.source2RedirectMethod.put(source, redirectMethod);
        }
        return redirectMethod;
    }

    protected SootMethod generateRedirectMethodForStartActivityForResult(SootClass originActivity, SootClass destComp) {
        String newSM_name = "redirector" + num++;
        ArrayList<RefType> newSM_parameters = new ArrayList<RefType>();
        newSM_parameters.add(originActivity.getType());
        newSM_parameters.add(this.INTENT_TYPE);
        SootMethod newSM = Scene.v().makeSootMethod(newSM_name, newSM_parameters, (Type)VoidType.v(), 9);
        this.dummyMainClass.addMethod(newSM);
        JimpleBody b = Jimple.v().newBody(newSM);
        newSM.setActiveBody((Body)b);
        newSM.addTag((Tag)SimulatedCodeElementTag.TAG);
        LocalGenerator lg = Scene.v().createLocalGenerator((Body)b);
        Local originActivityParameterLocal = lg.generateLocal((Type)originActivity.getType());
        IdentityStmt originActivityParameterU = Jimple.v().newIdentityStmt((Value)originActivityParameterLocal, (Value)Jimple.v().newParameterRef((Type)originActivity.getType(), 0));
        b.getUnits().add((Unit)originActivityParameterU);
        Local intentParameterLocal = lg.generateLocal((Type)this.INTENT_TYPE);
        b.getUnits().add((Unit)Jimple.v().newIdentityStmt((Value)intentParameterLocal, (Value)Jimple.v().newParameterRef((Type)this.INTENT_TYPE, 1)));
        Local componentLocal = lg.generateLocal((Type)destComp.getType());
        ActivityEntryPointInfo entryPointInfo = (ActivityEntryPointInfo)this.componentToEntryPoint.get(destComp);
        SootMethod targetDummyMain = this.componentToEntryPoint.getEntryPoint(destComp);
        if (targetDummyMain == null) {
            throw new RuntimeException(String.format("Destination component %s has no dummy main method", destComp.getName()));
        }
        b.getUnits().add((Unit)Jimple.v().newAssignStmt((Value)componentLocal, (Value)Jimple.v().newStaticInvokeExpr(targetDummyMain.makeRef(), Collections.singletonList(intentParameterLocal))));
        Local arIntentLocal = lg.generateLocal((Type)this.INTENT_TYPE);
        b.getUnits().add((Unit)Jimple.v().newAssignStmt((Value)arIntentLocal, (Value)Jimple.v().newInstanceFieldRef((Value)componentLocal, entryPointInfo.getResultIntentField().makeRef())));
        SootMethod method = originActivity.getMethodUnsafe("void onActivityResult(int,int,android.content.Intent)");
        if (method != null) {
            ArrayList<Object> args = new ArrayList<Object>();
            args.add(IntConstant.v((int)-1));
            args.add(IntConstant.v((int)-1));
            args.add(arIntentLocal);
            b.getUnits().add((Unit)Jimple.v().newInvokeStmt((Value)Jimple.v().newVirtualInvokeExpr(originActivityParameterLocal, method.makeRef(), args)));
        }
        b.getUnits().add((Unit)Jimple.v().newReturnVoidStmt());
        return newSM;
    }

    protected SootMethod generateRedirectMethod(SootClass wrapper) {
        SootMethod targetDummyMain = this.componentToEntryPoint.getEntryPoint(wrapper);
        if (targetDummyMain == null) {
            logger.warn("Destination component {} has no dummy main method", (Object)wrapper.getName());
            return null;
        }
        String newSM_name = "redirector" + num++;
        SootMethod newSM = Scene.v().makeSootMethod(newSM_name, Collections.singletonList(this.INTENT_TYPE), (Type)VoidType.v(), 9);
        newSM.addTag((Tag)SimulatedCodeElementTag.TAG);
        this.dummyMainClass.addMethod(newSM);
        JimpleBody b = Jimple.v().newBody(newSM);
        newSM.setActiveBody((Body)b);
        LocalGenerator lg = Scene.v().createLocalGenerator((Body)b);
        Local intentParameterLocal = lg.generateLocal((Type)this.INTENT_TYPE);
        b.getUnits().add((Unit)Jimple.v().newIdentityStmt((Value)intentParameterLocal, (Value)Jimple.v().newParameterRef((Type)this.INTENT_TYPE, 0)));
        b.getUnits().add((Unit)Jimple.v().newInvokeStmt((Value)Jimple.v().newStaticInvokeExpr(targetDummyMain.makeRef(), Collections.singletonList(intentParameterLocal))));
        b.getUnits().add((Unit)Jimple.v().newReturnVoidStmt());
        return newSM;
    }

    protected SootMethod generateRedirectMethodForStartActivity(SootClass wrapper) {
        SootMethod targetDummyMain = this.componentToEntryPoint.getEntryPoint(wrapper);
        if (targetDummyMain == null) {
            logger.warn("Destination component {} has no dummy main method", (Object)wrapper.getName());
            return null;
        }
        String newSM_name = "redirector" + num++;
        SootMethod newSM = Scene.v().makeSootMethod(newSM_name, Collections.singletonList(this.INTENT_TYPE), (Type)VoidType.v(), 9);
        newSM.addTag((Tag)SimulatedCodeElementTag.TAG);
        this.dummyMainClass.addMethod(newSM);
        JimpleBody b = Jimple.v().newBody(newSM);
        newSM.setActiveBody((Body)b);
        LocalGenerator lg = Scene.v().createLocalGenerator((Body)b);
        Local intentParameterLocal = lg.generateLocal((Type)this.INTENT_TYPE);
        b.getUnits().add((Unit)Jimple.v().newIdentityStmt((Value)intentParameterLocal, (Value)Jimple.v().newParameterRef((Type)this.INTENT_TYPE, 0)));
        b.getUnits().add((Unit)Jimple.v().newInvokeStmt((Value)Jimple.v().newStaticInvokeExpr(targetDummyMain.makeRef(), Collections.singletonList(intentParameterLocal))));
        b.getUnits().add((Unit)Jimple.v().newReturnVoidStmt());
        return newSM;
    }

    protected SootMethod generateRedirectMethodForBindService(SootClass serviceConnection, SootClass destComp) {
        ServiceEntryPointInfo entryPointInfo = (ServiceEntryPointInfo)this.componentToEntryPoint.get(destComp);
        if (entryPointInfo == null) {
            logger.warn("Destination component {} has no dummy main method", (Object)destComp.getName());
            return null;
        }
        SootMethod targetDummyMain = entryPointInfo.getEntryPoint();
        if (targetDummyMain == null) {
            logger.warn("Destination component {} has no dummy main method", (Object)destComp.getName());
            return null;
        }
        String newSM_name = "redirector" + num++;
        ArrayList<RefType> newSM_parameters = new ArrayList<RefType>();
        newSM_parameters.add(serviceConnection.getType());
        newSM_parameters.add(this.INTENT_TYPE);
        SootMethod newSM = Scene.v().makeSootMethod(newSM_name, newSM_parameters, (Type)VoidType.v(), 9);
        newSM.addTag((Tag)SimulatedCodeElementTag.TAG);
        this.dummyMainClass.addMethod(newSM);
        JimpleBody b = Jimple.v().newBody(newSM);
        newSM.setActiveBody((Body)b);
        LocalGenerator lg = Scene.v().createLocalGenerator((Body)b);
        Local originActivityParameterLocal = lg.generateLocal((Type)serviceConnection.getType());
        b.getUnits().add((Unit)Jimple.v().newIdentityStmt((Value)originActivityParameterLocal, (Value)Jimple.v().newParameterRef((Type)serviceConnection.getType(), 0)));
        Local intentParameterLocal = lg.generateLocal((Type)this.INTENT_TYPE);
        b.getUnits().add((Unit)Jimple.v().newIdentityStmt((Value)intentParameterLocal, (Value)Jimple.v().newParameterRef((Type)this.INTENT_TYPE, 1)));
        Local componentLocal = lg.generateLocal((Type)destComp.getType());
        b.getUnits().add((Unit)Jimple.v().newAssignStmt((Value)componentLocal, (Value)Jimple.v().newStaticInvokeExpr(targetDummyMain.makeRef(), Collections.singletonList(intentParameterLocal))));
        Local ibinderLocal = lg.generateLocal((Type)this.IBINDER_TYPE);
        b.getUnits().add((Unit)Jimple.v().newAssignStmt((Value)ibinderLocal, (Value)Jimple.v().newInstanceFieldRef((Value)componentLocal, entryPointInfo.getBinderField().makeRef())));
        ArrayList<RefType> paramTypes = new ArrayList<RefType>();
        paramTypes.add(RefType.v((String)"android.content.ComponentName"));
        paramTypes.add(RefType.v((String)"android.os.IBinder"));
        SootMethod method = serviceConnection.getMethod("onServiceConnected", paramTypes);
        Local iLocal1 = lg.generateLocal((Type)RefType.v((String)"android.content.ComponentName"));
        b.getUnits().add((Unit)Jimple.v().newAssignStmt((Value)iLocal1, (Value)NullConstant.v()));
        ArrayList<Local> args = new ArrayList<Local>();
        args.add(iLocal1);
        args.add(ibinderLocal);
        SootClass sc = Scene.v().getSootClass(originActivityParameterLocal.getType().toString());
        Object invoke = sc.isInterface() ? Jimple.v().newInterfaceInvokeExpr(originActivityParameterLocal, method.makeRef(), args) : Jimple.v().newVirtualInvokeExpr(originActivityParameterLocal, method.makeRef(), args);
        b.getUnits().add((Unit)Jimple.v().newInvokeStmt((Value)invoke));
        b.getUnits().add((Unit)Jimple.v().newReturnVoidStmt());
        return newSM;
    }

    protected SootMethod generateRedirectMethodForContentProvider(Stmt iccStmt, SootClass destProvider) {
        SootMethod iccMethod = iccStmt.getInvokeExpr().getMethod();
        String newSM_name = "redirector" + num++;
        SootMethod newSM = Scene.v().makeSootMethod(newSM_name, iccMethod.getParameterTypes(), iccMethod.getReturnType(), 9);
        newSM.addTag((Tag)SimulatedCodeElementTag.TAG);
        this.dummyMainClass.addMethod(newSM);
        JimpleBody b = Jimple.v().newBody(newSM);
        newSM.setActiveBody((Body)b);
        LocalGenerator lg = Scene.v().createLocalGenerator((Body)b);
        ArrayList<Local> locals = new ArrayList<Local>();
        for (int i = 0; i < iccMethod.getParameterCount(); ++i) {
            Type type = iccMethod.getParameterType(i);
            Local local = lg.generateLocal(type);
            locals.add(local);
            b.getUnits().add((Unit)Jimple.v().newIdentityStmt((Value)local, (Value)Jimple.v().newParameterRef(type, i)));
        }
        Local al = lg.generateLocal((Type)destProvider.getType());
        b.getUnits().add((Unit)Jimple.v().newAssignStmt((Value)al, (Value)Jimple.v().newNewExpr(destProvider.getType())));
        List parameters = new ArrayList();
        ArrayList args = new ArrayList();
        SootMethod method = destProvider.getMethod("<init>", parameters, (Type)VoidType.v());
        b.getUnits().add((Unit)Jimple.v().newInvokeStmt((Value)Jimple.v().newSpecialInvokeExpr(al, method.makeRef(), args)));
        Local rtLocal = lg.generateLocal(iccMethod.getReturnType());
        parameters = iccMethod.getParameterTypes();
        method = destProvider.getMethodByName(iccMethod.getName());
        VirtualInvokeExpr invoke = Jimple.v().newVirtualInvokeExpr(al, method.makeRef(), locals);
        b.getUnits().add((Unit)Jimple.v().newAssignStmt((Value)rtLocal, (Value)invoke));
        b.getUnits().add((Unit)Jimple.v().newReturnStmt((Value)rtLocal));
        return newSM;
    }

    protected void insertRedirectMethodCallAfterIccMethod(IccLink link, SootMethod redirectMethod) {
        Value arg0;
        Stmt fromStmt = (Stmt)link.getFromU();
        if (fromStmt == null || !fromStmt.containsInvokeExpr()) {
            return;
        }
        SootMethod callee = fromStmt.getInvokeExpr().getMethod();
        ArrayList<Value> args = new ArrayList<Value>();
        if (callee.getNumberedSubSignature().equals((Object)this.subsigStartActivityForResult)) {
            InstanceInvokeExpr iiexpr = (InstanceInvokeExpr)fromStmt.getInvokeExpr();
            args.add(iiexpr.getBase());
            args.add(iiexpr.getArg(0));
        } else if (fromStmt.toString().contains("bindService")) {
            arg0 = fromStmt.getInvokeExpr().getArg(0);
            Value arg1 = fromStmt.getInvokeExpr().getArg(1);
            args.add(arg1);
            args.add(arg0);
        } else {
            if (fromStmt.getInvokeExpr().getArgCount() == 0) {
                return;
            }
            arg0 = fromStmt.getInvokeExpr().getArg(0);
            args.add(arg0);
        }
        if (redirectMethod == null) {
            return;
        }
        InvokeStmt redirectCallU = Jimple.v().newInvokeStmt((Value)Jimple.v().newStaticInvokeExpr(redirectMethod.makeRef(), args));
        Body body = link.getFromSM().retrieveActiveBody();
        UnitPatchingChain units = body.getUnits();
        IccRedirectionCreator.copyTags(link.getFromU(), (Unit)redirectCallU);
        redirectCallU.addTag((Tag)SimulatedCodeElementTag.TAG);
        units.insertAfter((Unit)redirectCallU, link.getFromU());
        this.instrumentedUnits.put((Object)body, (Object)redirectCallU);
        if (this.instrumentationCallback != null) {
            this.instrumentationCallback.onRedirectorCallInserted(link, (Stmt)redirectCallU, redirectMethod);
        }
        NumberedString subsig = Scene.v().getSubSigNumberer().find("android.content.Intent createChooser(android.content.Intent,java.lang.CharSequence)");
        SootClass clazz = Scene.v().getSootClassUnsafe("android.content.Intent");
        if (subsig != null && clazz != null) {
            Iterator iter = units.snapshotIterator();
            while (iter.hasNext()) {
                InvokeExpr expr;
                SootMethodRef mr;
                Stmt stmt = (Stmt)iter.next();
                if (!stmt.containsInvokeExpr() || !(mr = (expr = stmt.getInvokeExpr()).getMethodRef()).getDeclaringClass().equals(clazz) || !mr.getSubSignature().equals((Object)subsig)) continue;
                List vbs = stmt.getUseAndDefBoxes();
                AssignStmt assignU = Jimple.v().newAssignStmt(((ValueBox)vbs.get(0)).getValue(), ((ValueBox)vbs.get(1)).getValue());
                IccRedirectionCreator.copyTags((Unit)stmt, (Unit)assignU);
                assignU.addTag((Tag)SimulatedCodeElementTag.TAG);
                units.insertAfter((Unit)assignU, (Unit)stmt);
                this.instrumentedUnits.put((Object)body, (Object)assignU);
            }
        }
    }

    protected static void copyTags(Unit from, Unit to) {
        List tags = from.getTags();
        for (Tag tag : tags) {
            to.removeTag(tag.getName());
            to.addTag(tag);
        }
    }

    public void undoInstrumentation() {
        for (SootMethod sm : this.source2RedirectMethod.values()) {
            sm.getDeclaringClass().removeMethod(sm);
        }
        for (Body body : this.instrumentedUnits.keySet()) {
            for (Unit u : this.instrumentedUnits.get((Object)body)) {
                body.getUnits().remove((Object)u);
            }
        }
        this.instrumentedUnits.clear();
        this.source2RedirectMethod.clear();
    }

    public void setInstrumentationCallback(IRedirectorCallInserted instrumentationCallback) {
        this.instrumentationCallback = instrumentationCallback;
    }

    public static interface IRedirectorCallInserted {
        public void onRedirectorCallInserted(IccLink var1, Stmt var2, SootMethod var3);
    }
}

