/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.iccta;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import soot.jimple.infoflow.android.iccta.App;
import soot.jimple.infoflow.android.iccta.EmptyIntent;
import soot.jimple.infoflow.android.iccta.Intent;

class LoggingPoint {
    private String callerMethodSignature;
    private String calleeMethodSignature;
    private int stmtSequence;
    private Set<Intent> intents = new HashSet<Intent>();
    int id;
    private App app;
    private boolean sealed;
    public String extraInformation;

    public LoggingPoint(App app) {
        this.app = app;
    }

    public void seal() {
        this.sealed = true;
        for (Intent i : this.getIntents()) {
            i.seal();
        }
    }

    public String getCallerMethodSignature() {
        return this.callerMethodSignature;
    }

    public void setCallerMethodSignature(String callerMethodSignature) {
        this.callerMethodSignature = callerMethodSignature;
    }

    public String getCalleeMethodSignature() {
        return this.calleeMethodSignature;
    }

    public void setCalleeMethodSignature(String calleeMethodSignature) {
        this.calleeMethodSignature = calleeMethodSignature;
    }

    public int getStmtSequence() {
        return this.stmtSequence;
    }

    public void setStmtSequence(int stmtSequence) {
        this.stmtSequence = stmtSequence;
    }

    public Set<Intent> getIntents() {
        if (this.sealed) {
            return Collections.unmodifiableSet(this.intents);
        }
        return this.intents;
    }

    public void setIntents(Set<Intent> intents) {
        if (this.sealed) {
            throw new IllegalStateException();
        }
        this.intents = intents;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LoggingPoint other = (LoggingPoint)obj;
        if (this.calleeMethodSignature == null ? other.calleeMethodSignature != null : !this.calleeMethodSignature.equals(other.calleeMethodSignature)) {
            return false;
        }
        if (this.callerMethodSignature == null ? other.callerMethodSignature != null : !this.callerMethodSignature.equals(other.callerMethodSignature)) {
            return false;
        }
        if (this.stmtSequence != other.stmtSequence) {
            return false;
        }
        if (this.app == other.app) {
            return this.id == other.id;
        }
        return true;
    }

    public String toString() {
        return String.valueOf(this.id);
    }

    public boolean equalsSimilar(LoggingPoint pointDest) {
        String shortenedA = this.getCalleeMethodSignature().substring(this.getCalleeMethodSignature().indexOf(":"));
        String shortenedB = pointDest.getCalleeMethodSignature().substring(pointDest.getCalleeMethodSignature().indexOf(":"));
        boolean b = this.getCallerMethodSignature().equals(pointDest.getCallerMethodSignature()) && shortenedA.equals(shortenedB);
        return b;
    }

    public boolean hasResults() {
        boolean noResult = this.getIntents().isEmpty() || this.getIntents().size() == 1 && this.getIntents().iterator().next() instanceof EmptyIntent;
        return !noResult;
    }
}

