/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.resources;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.jimple.infoflow.android.axml.ApkHandler;
import soot.jimple.infoflow.android.resources.AbstractResourceParser;
import soot.jimple.infoflow.android.resources.IResourceHandler;

public class ARSCFileParser
extends AbstractResourceParser {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected static final int RES_STRING_POOL_TYPE = 1;
    protected static final int RES_TABLE_TYPE = 2;
    protected static final int RES_TABLE_PACKAGE_TYPE = 512;
    protected static final int RES_TABLE_TYPE_SPEC_TYPE = 514;
    protected static final int RES_TABLE_TYPE_TYPE = 513;
    protected static final int SORTED_FLAG = 1;
    protected static final int UTF8_FLAG = 256;
    protected static final int SPEC_PUBLIC = 0x40000000;
    protected static final int TYPE_NULL = 0;
    protected static final int TYPE_REFERENCE = 1;
    protected static final int TYPE_ATTRIBUTE = 2;
    protected static final int TYPE_STRING = 3;
    protected static final int TYPE_FLOAT = 4;
    protected static final int TYPE_DIMENSION = 5;
    protected static final int TYPE_FRACTION = 6;
    protected static final int TYPE_FIRST_INT = 16;
    protected static final int TYPE_INT_DEC = 16;
    protected static final int TYPE_INT_HEX = 17;
    protected static final int TYPE_INT_BOOLEAN = 18;
    protected static final int TYPE_FIRST_COLOR_INT = 28;
    protected static final int TYPE_INT_COLOR_ARGB8 = 28;
    protected static final int TYPE_INT_COLOR_RGB8 = 29;
    protected static final int TYPE_INT_COLOR_ARGB4 = 30;
    protected static final int TYPE_INT_COLOR_RGB4 = 31;
    protected static final int TYPE_LAST_COLOR_INT = 31;
    protected static final int TYPE_LAST_INT = 31;
    protected static final int ATTR_TYPE = 0x1000000;
    protected static final int ATTR_MIN = 0x1000001;
    protected static final int ATTR_MAX = 0x1000002;
    protected static final int ATTR_L10N = 0x1000003;
    protected static final int ATTR_OTHER = 0x1000004;
    protected static final int ATTR_ZERO = 0x1000005;
    protected static final int ATTR_ONE = 0x1000006;
    protected static final int ATTR_TWO = 0x1000007;
    protected static final int ATTR_FEW = 0x1000008;
    protected static final int ATTR_MANY = 0x1000009;
    protected static final int NO_ENTRY = -1;
    protected static final int COMPLEX_UNIT_SHIFT = 0;
    protected static final int COMPLEX_UNIT_MASK = 15;
    protected static final int COMPLEX_UNIT_PX = 0;
    protected static final int COMPLEX_UNIT_DIP = 1;
    protected static final int COMPLEX_UNIT_SP = 2;
    protected static final int COMPLEX_UNIT_PT = 3;
    protected static final int COMPLEX_UNIT_IN = 4;
    protected static final int COMPLEX_UNIT_MM = 5;
    protected static final int COMPLEX_UNIT_FRACTION = 0;
    protected static final int COMPLEX_UNIT_FRACTION_PARENT = 1;
    protected static final int COMPLEX_RADIX_SHIFT = 4;
    protected static final int COMPLEX_RADIX_MASK = 3;
    protected static final int COMPLEX_RADIX_23p0 = 0;
    protected static final int COMPLEX_RADIX_16p7 = 1;
    protected static final int COMPLEX_RADIX_8p15 = 2;
    protected static final int COMPLEX_RADIX_0p23 = 3;
    protected static final int COMPLEX_MANTISSA_SHIFT = 8;
    protected static final int COMPLEX_MANTISSA_MASK = 0xFFFFFF;
    protected static final float MANTISSA_MULT = 0.00390625f;
    protected static final float[] RADIX_MULTS = new float[]{0.00390625f, 3.0517578E-5f, 1.1920929E-7f, 4.656613E-10f};
    public static final int FLAG_COMPLEX = 1;
    public static final int FLAG_PUBLIC = 2;
    private final Map<Integer, String> stringTable = new HashMap<Integer, String>();
    private final List<ResPackage> packages = new ArrayList<ResPackage>();

    public void parse(String apkFile) throws IOException {
        this.handleAndroidResourceFiles(apkFile, null, new IResourceHandler(){

            @Override
            public void handleResourceFile(String fileName, Set<String> fileNameFilter, InputStream stream) {
                try {
                    if (fileName.equals("resources.arsc")) {
                        ARSCFileParser.this.parse(stream);
                    }
                }
                catch (IOException ex) {
                    ARSCFileParser.this.logger.error("Could not read resource file", (Throwable)ex);
                }
            }
        });
    }

    public void parse(InputStream stream) throws IOException {
        this.readResourceHeader(stream);
    }

    private void readResourceHeader(InputStream stream) throws IOException {
        int bytesRead;
        int BLOCK_SIZE = 2048;
        ResTable_Header resourceHeader = new ResTable_Header();
        this.readChunkHeader(stream, resourceHeader.header);
        resourceHeader.packageCount = this.readUInt32(stream);
        this.logger.debug(String.format("Package Groups (%d)", resourceHeader.packageCount));
        int remainingSize = resourceHeader.header.size - resourceHeader.header.headerSize;
        if (remainingSize <= 0) {
            return;
        }
        byte[] remainingData = new byte[remainingSize];
        for (int totalBytesRead = 0; totalBytesRead < remainingSize; totalBytesRead += bytesRead) {
            byte[] block = new byte[Math.min(2048, remainingSize - totalBytesRead)];
            bytesRead = stream.read(block);
            if (bytesRead < 0) {
                this.logger.error("Could not read block from resource file");
                return;
            }
            System.arraycopy(block, 0, remainingData, totalBytesRead, bytesRead);
        }
        int offset = 0;
        int beforeBlock = 0;
        int packageCtr = 0;
        HashMap<Integer, String> keyStrings = new HashMap<Integer, String>();
        HashMap<Integer, String> typeStrings = new HashMap<Integer, String>();
        while (offset < remainingData.length - 1) {
            beforeBlock = offset;
            ResChunk_Header nextChunkHeader = new ResChunk_Header();
            offset = this.readChunkHeader(nextChunkHeader, remainingData, offset);
            if (nextChunkHeader.type == 1) {
                ResStringPool_Header stringPoolHeader = new ResStringPool_Header();
                stringPoolHeader.header = nextChunkHeader;
                offset = this.parseStringPoolHeader(stringPoolHeader, remainingData, offset);
                offset = this.readStringTable(remainingData, offset, beforeBlock, stringPoolHeader, this.stringTable);
                assert (this.stringTable.size() == stringPoolHeader.stringCount);
            } else if (nextChunkHeader.type == 512) {
                int keyStringsOffset;
                int typeStringsOffset;
                ResTable_Package packageTable = new ResTable_Package();
                packageTable.header = nextChunkHeader;
                offset = this.parsePackageTable(packageTable, remainingData, offset);
                this.logger.debug(String.format("\tPackage %s id=%d name=%s", packageCtr, packageTable.id, packageTable.name));
                int endOfRecord = beforeBlock + nextChunkHeader.size;
                ResPackage resPackage = new ResPackage();
                this.packages.add(resPackage);
                resPackage.packageId = packageTable.id;
                resPackage.packageName = packageTable.name;
                int beforeStringBlock = typeStringsOffset = beforeBlock + packageTable.typeStrings;
                ResChunk_Header typePoolHeader = new ResChunk_Header();
                typeStringsOffset = this.readChunkHeader(typePoolHeader, remainingData, typeStringsOffset);
                if (typePoolHeader.type != 1) {
                    throw new RuntimeException("Unexpected block type for package type strings");
                }
                ResStringPool_Header typePool = new ResStringPool_Header();
                typePool.header = typePoolHeader;
                typeStringsOffset = this.parseStringPoolHeader(typePool, remainingData, typeStringsOffset);
                this.readStringTable(remainingData, typeStringsOffset, beforeStringBlock, typePool, typeStrings);
                beforeStringBlock = keyStringsOffset = beforeBlock + packageTable.keyStrings;
                ResChunk_Header keyPoolHeader = new ResChunk_Header();
                keyStringsOffset = this.readChunkHeader(keyPoolHeader, remainingData, keyStringsOffset);
                if (keyPoolHeader.type != 1) {
                    throw new RuntimeException("Unexpected block type for package key strings");
                }
                ResStringPool_Header keyPool = new ResStringPool_Header();
                keyPool.header = keyPoolHeader;
                keyStringsOffset = this.parseStringPoolHeader(keyPool, remainingData, keyStringsOffset);
                this.readStringTable(remainingData, keyStringsOffset, beforeStringBlock, keyPool, keyStrings);
                offset = beforeStringBlock + keyPoolHeader.size;
                while (offset < endOfRecord) {
                    ResChunk_Header innerHeader = new ResChunk_Header();
                    int beforeInnerBlock = offset;
                    offset = this.readChunkHeader(innerHeader, remainingData, offset);
                    if (innerHeader.type == 514) {
                        ResTable_TypeSpec typeSpecTable = new ResTable_TypeSpec();
                        typeSpecTable.header = innerHeader;
                        offset = this.readTypeSpecTable(typeSpecTable, remainingData, offset);
                        assert (offset == beforeInnerBlock + typeSpecTable.header.headerSize);
                        ResType tp = new ResType();
                        tp.id = typeSpecTable.id;
                        tp.typeName = (String)typeStrings.get(typeSpecTable.id - 1);
                        resPackage.types.add(tp);
                    } else if (innerHeader.type == 513) {
                        ResTable_Type typeTable = new ResTable_Type();
                        typeTable.header = innerHeader;
                        offset = this.readTypeTable(typeTable, remainingData, offset);
                        assert (offset == beforeInnerBlock + typeTable.header.headerSize);
                        ResType resType = null;
                        for (ResType rt : resPackage.types) {
                            if (rt.id != typeTable.id) continue;
                            resType = rt;
                            break;
                        }
                        if (resType == null) {
                            throw new RuntimeException("Reference to undeclared type found");
                        }
                        ResConfig config = new ResConfig();
                        config.config = typeTable.config;
                        resType.configurations.add(config);
                        int resourceIdx = 0;
                        for (int i = 0; i < typeTable.entryCount; ++i) {
                            AbstractResource res;
                            int entryOffset = this.readUInt32(remainingData, offset);
                            offset += 4;
                            if (entryOffset == -1) {
                                ++resourceIdx;
                                continue;
                            }
                            ResTable_Entry entry = this.readEntryTable(remainingData, entryOffset += beforeInnerBlock + typeTable.entriesStart);
                            entryOffset += entry.size;
                            if (entry.flagsComplex) {
                                ComplexResource cmpRes;
                                res = cmpRes = new ComplexResource(resType.typeName);
                                for (int j = 0; j < ((ResTable_Map_Entry)entry).count; ++j) {
                                    ResTable_Map map = new ResTable_Map();
                                    entryOffset = this.readComplexValue(map, remainingData, entryOffset);
                                    String mapName = map.name + "";
                                    AbstractResource value = this.parseValue(map.value);
                                    if (resType.typeName != null && resType.typeName.equals("array") && value instanceof StringResource) {
                                        AbstractResource existingResource = (AbstractResource)cmpRes.value.get(mapName);
                                        if (existingResource == null) {
                                            existingResource = new ArrayResource();
                                            cmpRes.value.put(mapName, existingResource);
                                        }
                                        if (!(existingResource instanceof ArrayResource)) continue;
                                        ((ArrayResource)existingResource).add(value);
                                        continue;
                                    }
                                    cmpRes.value.put(mapName, value);
                                }
                            } else {
                                Res_Value val = new Res_Value();
                                entryOffset = this.readValue(val, remainingData, entryOffset);
                                res = this.parseValue(val);
                                if (res == null) {
                                    this.logger.error(String.format("Could not parse resource %s of type 0x%x, skipping entry", keyStrings.get(entry.key), val.dataType));
                                    continue;
                                }
                            }
                            if (keyStrings.containsKey(entry.key)) {
                                res.resourceName = (String)keyStrings.get(entry.key);
                            } else {
                                res.resourceName = "<INVALID RESOURCE>";
                            }
                            if (res.resourceID <= 0) {
                                res.resourceID = (packageTable.id << 24) + (typeTable.id << 16) + resourceIdx;
                            }
                            this.logger.debug("resource added: {}", (Object)res);
                            config.resources.add(res);
                            ++resourceIdx;
                        }
                    }
                    offset = beforeInnerBlock + innerHeader.size;
                }
                if (this.logger.isTraceEnabled()) {
                    for (ResType resType : resPackage.types) {
                        this.logger.trace("\t\tType {} ({}), configCount={}, entryCount={}", new Object[]{resType.typeName, resType.id - 1, resType.configurations.size(), resType.configurations.size() > 0 ? ((ResConfig)resType.configurations.get(0)).resources.size() : 0});
                        for (ResConfig resConfig : resType.configurations) {
                            this.logger.trace("\t\t\tconfig");
                            for (AbstractResource res : resConfig.resources) {
                                this.logger.trace("\t\t\t\tresource {}: {}", (Object)Integer.toHexString(res.resourceID), (Object)res.resourceName);
                            }
                        }
                    }
                }
                ++packageCtr;
            }
            offset = beforeBlock + nextChunkHeader.size;
            remainingSize -= nextChunkHeader.size;
        }
    }

    protected boolean isAttribute(ResTable_Map map) {
        return map.name == 0x1000000 || map.name == 0x1000001 || map.name == 0x1000002 || map.name == 0x1000003 || map.name == 0x1000004 || map.name == 0x1000005 || map.name == 0x1000006 || map.name == 0x1000007 || map.name == 0x1000008 || map.name == 0x1000009;
    }

    protected static float complexToFloat(int complex) {
        return (float)(complex & 0xFFFFFF00) * RADIX_MULTS[complex >> 4 & 3];
    }

    private AbstractResource parseValue(Res_Value val) {
        AbstractResource res;
        switch (val.dataType) {
            case 0: {
                res = new NullResource();
                break;
            }
            case 1: {
                res = new ReferenceResource(val.data);
                break;
            }
            case 2: {
                res = new AttributeResource(val.data);
                break;
            }
            case 3: {
                res = new StringResource(this.stringTable.get(val.data));
                break;
            }
            case 16: 
            case 17: {
                res = new IntegerResource(val.data);
                break;
            }
            case 18: {
                res = new BooleanResource(val.data);
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                res = new ColorResource(val.data & 0xFFFFFFFF, val.data & 0xFF, val.data & 0xFF, val.data & 0xFF);
                break;
            }
            case 5: {
                res = new DimensionResource(val.data & 0xF, val.data >> 0);
                break;
            }
            case 4: {
                res = new FloatResource(Float.intBitsToFloat(val.data));
                break;
            }
            case 6: {
                int fracType = val.data >> 0 & 0xF;
                float data = ARSCFileParser.complexToFloat(val.data);
                if (fracType == 0) {
                    res = new FractionResource(FractionType.Fraction, data);
                    break;
                }
                res = new FractionResource(FractionType.FractionParent, data);
                break;
            }
            default: {
                this.logger.warn(String.format("Unsupported data type: 0x%x", val.dataType));
                return null;
            }
        }
        return res;
    }

    private int readComplexValue(ResTable_Map map, byte[] remainingData, int offset) throws IOException {
        map.name = this.readUInt32(remainingData, offset);
        return this.readValue(map.value, remainingData, offset += 4);
    }

    private int readValue(Res_Value val, byte[] remainingData, int offset) throws IOException {
        int initialOffset = offset;
        val.size = this.readUInt16(remainingData, offset);
        offset += 2;
        if (val.size > 8) {
            return 0;
        }
        val.res0 = this.readUInt8(remainingData, offset);
        if (val.res0 != 0) {
            throw new RuntimeException("File format error, res0 was not zero");
        }
        val.dataType = this.readUInt8(remainingData, ++offset);
        val.data = this.readUInt32(remainingData, ++offset);
        assert ((offset += 4) == initialOffset + val.size);
        return offset;
    }

    private ResTable_Entry readEntryTable(byte[] data, int offset) throws IOException {
        ResTable_Entry entry;
        int size = this.readUInt16(data, offset);
        offset += 2;
        if (size == 8) {
            entry = new ResTable_Entry();
        } else if (size == 16) {
            entry = new ResTable_Map_Entry();
        } else {
            throw new RuntimeException("Unknown entry type");
        }
        entry.size = size;
        int flags = this.readUInt16(data, offset);
        entry.flagsComplex = (flags & 1) == 1;
        entry.flagsPublic = (flags & 2) == 2;
        entry.key = this.readUInt32(data, offset += 2);
        offset += 4;
        if (entry instanceof ResTable_Map_Entry) {
            ResTable_Map_Entry mapEntry = (ResTable_Map_Entry)entry;
            mapEntry.parent = this.readUInt32(data, offset);
            mapEntry.count = this.readUInt32(data, offset += 4);
            offset += 4;
        }
        return entry;
    }

    private int readTypeTable(ResTable_Type typeTable, byte[] data, int offset) throws IOException {
        typeTable.id = this.readUInt8(data, offset);
        typeTable.res0 = this.readUInt8(data, ++offset);
        if (typeTable.res0 != 0) {
            throw new RuntimeException("File format error, res0 was not zero");
        }
        typeTable.res1 = this.readUInt16(data, ++offset);
        if (typeTable.res1 != 0) {
            throw new RuntimeException("File format error, res1 was not zero");
        }
        typeTable.entryCount = this.readUInt32(data, offset += 2);
        typeTable.entriesStart = this.readUInt32(data, offset += 4);
        return this.readConfigTable(typeTable.config, data, offset += 4);
    }

    private int readConfigTable(ResTable_Config config, byte[] data, int offset) throws IOException {
        int i;
        config.size = this.readUInt32(data, offset);
        config.mmc = this.readUInt16(data, offset += 4);
        config.mnc = this.readUInt16(data, offset += 2);
        config.language[0] = (char)data[offset += 2];
        config.language[1] = (char)data[offset + 1];
        config.country[0] = (char)data[offset += 2];
        config.country[1] = (char)data[offset + 1];
        config.orientation = this.readUInt8(data, offset += 2);
        config.touchscreen = this.readUInt8(data, ++offset);
        config.density = this.readUInt16(data, ++offset);
        config.keyboard = this.readUInt8(data, offset += 2);
        config.navigation = this.readUInt8(data, ++offset);
        config.inputFlags = this.readUInt8(data, ++offset);
        config.inputPad0 = this.readUInt8(data, ++offset);
        config.screenWidth = this.readUInt16(data, ++offset);
        config.screenHeight = this.readUInt16(data, offset += 2);
        config.sdkVersion = this.readUInt16(data, offset += 2);
        config.minorVersion = this.readUInt16(data, offset += 2);
        offset += 2;
        if (config.size <= 28) {
            return offset;
        }
        config.screenLayout = this.readUInt8(data, offset);
        config.uiMode = this.readUInt8(data, ++offset);
        config.smallestScreenWidthDp = this.readUInt16(data, ++offset);
        offset += 2;
        if (config.size <= 32) {
            return offset;
        }
        config.screenWidthDp = this.readUInt16(data, offset);
        config.screenHeightDp = this.readUInt16(data, offset += 2);
        offset += 2;
        if (config.size <= 36) {
            return offset;
        }
        for (i = 0; i < 4; ++i) {
            config.localeScript[i] = (char)data[offset + i];
        }
        offset += 4;
        if (config.size <= 40) {
            return offset;
        }
        for (i = 0; i < 8; ++i) {
            config.localeVariant[i] = (char)data[offset + i];
        }
        offset += 8;
        if (config.size <= 48) {
            return offset;
        }
        int remainingSize = config.size - 48;
        if (remainingSize > 0) {
            byte[] remainingBytes = new byte[remainingSize];
            System.arraycopy(data, offset, remainingBytes, 0, remainingSize);
            BigInteger remainingData = new BigInteger(1, remainingBytes);
            if (!remainingData.equals(BigInteger.ZERO)) {
                this.logger.debug("Excessive {} non-null bytes in ResTable_Config ignored", (Object)remainingSize);
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("remaining data: 0x" + remainingData.toString(16));
                }
            }
            offset += remainingSize;
        }
        return offset;
    }

    private int readTypeSpecTable(ResTable_TypeSpec typeSpecTable, byte[] data, int offset) throws IOException {
        typeSpecTable.id = this.readUInt8(data, offset);
        typeSpecTable.res0 = this.readUInt8(data, ++offset);
        ++offset;
        if (typeSpecTable.res0 != 0) {
            throw new RuntimeException("File format violation, res0 was not zero");
        }
        typeSpecTable.res1 = this.readUInt16(data, offset);
        offset += 2;
        if (typeSpecTable.res1 != 0) {
            throw new RuntimeException("File format violation, res1 was not zero");
        }
        typeSpecTable.entryCount = this.readUInt32(data, offset);
        return offset += 4;
    }

    private int readStringTable(byte[] remainingData, int offset, int blockStart, ResStringPool_Header stringPoolHeader, Map<Integer, String> stringList) throws IOException {
        for (int i = 0; i < stringPoolHeader.stringCount; ++i) {
            int stringIdx = this.readUInt32(remainingData, offset);
            offset += 4;
            String str = "";
            str = stringPoolHeader.flagsUTF8 ? this.readStringUTF8(remainingData, stringIdx).trim() : this.readString(remainingData, stringIdx += stringPoolHeader.stringsStart + blockStart).trim();
            stringList.put(i, str);
        }
        return offset;
    }

    private int parsePackageTable(ResTable_Package packageTable, byte[] data, int offset) throws IOException {
        packageTable.id = this.readUInt32(data, offset);
        offset += 4;
        StringBuilder bld = new StringBuilder();
        for (int i = 0; i < 128; ++i) {
            int curChar = this.readUInt16(data, offset);
            bld.append((char)curChar);
            offset += 2;
        }
        packageTable.name = bld.toString().trim();
        packageTable.typeStrings = this.readUInt32(data, offset);
        packageTable.lastPublicType = this.readUInt32(data, offset += 4);
        packageTable.keyStrings = this.readUInt32(data, offset += 4);
        packageTable.lastPublicKey = this.readUInt32(data, offset += 4);
        return offset += 4;
    }

    private String readString(byte[] remainingData, int stringIdx) throws IOException {
        int strLen = this.readUInt16(remainingData, stringIdx);
        if (strLen == 0) {
            return "";
        }
        byte[] str = new byte[strLen * 2];
        System.arraycopy(remainingData, stringIdx += 2, str, 0, strLen * 2);
        return new String(remainingData, stringIdx, strLen * 2, "UTF-16LE");
    }

    private String readStringUTF8(byte[] remainingData, int stringIdx) throws IOException {
        int strLen = this.readUInt8(remainingData, stringIdx + 1);
        String str = new String(remainingData, stringIdx += 2, strLen, "UTF-8");
        return str;
    }

    private int parseStringPoolHeader(ResStringPool_Header stringPoolHeader, byte[] data, int offset) throws IOException {
        stringPoolHeader.stringCount = this.readUInt32(data, offset);
        stringPoolHeader.styleCount = this.readUInt32(data, offset + 4);
        int flags = this.readUInt32(data, offset + 8);
        stringPoolHeader.flagsSorted = (flags & 1) == 1;
        stringPoolHeader.flagsUTF8 = (flags & 0x100) == 256;
        stringPoolHeader.stringsStart = this.readUInt32(data, offset + 12);
        stringPoolHeader.stylesStart = this.readUInt32(data, offset + 16);
        return offset + 20;
    }

    private void readChunkHeader(InputStream stream, ResChunk_Header nextChunkHeader) throws IOException {
        byte[] header = new byte[8];
        stream.read(header);
        this.readChunkHeader(nextChunkHeader, header, 0);
    }

    private int readChunkHeader(ResChunk_Header nextChunkHeader, byte[] data, int offset) throws IOException {
        nextChunkHeader.type = this.readUInt16(data, offset);
        nextChunkHeader.headerSize = this.readUInt16(data, offset += 2);
        nextChunkHeader.size = this.readUInt32(data, offset += 2);
        return offset += 4;
    }

    private int readUInt8(byte[] uint16, int offset) throws IOException {
        int b0 = uint16[0 + offset] & 0xFF;
        return b0;
    }

    private int readUInt16(byte[] uint16, int offset) throws IOException {
        int b0 = uint16[0 + offset] & 0xFF;
        int b1 = uint16[1 + offset] & 0xFF;
        return (b1 << 8) + b0;
    }

    private int readUInt32(InputStream stream) throws IOException {
        byte[] uint32 = new byte[4];
        stream.read(uint32);
        return this.readUInt32(uint32, 0);
    }

    private int readUInt32(byte[] uint32, int offset) throws IOException {
        int b0 = uint32[0 + offset] & 0xFF;
        int b1 = uint32[1 + offset] & 0xFF;
        int b2 = uint32[2 + offset] & 0xFF;
        int b3 = uint32[3 + offset] & 0xFF;
        return (Math.abs(b3) << 24) + (Math.abs(b2) << 16) + (Math.abs(b1) << 8) + Math.abs(b0);
    }

    public Map<Integer, String> getGlobalStringPool() {
        return this.stringTable;
    }

    public List<ResPackage> getPackages() {
        return this.packages;
    }

    public ResPackage getPackage(int pkgID, String pkgName) {
        return this.packages.stream().filter(p -> ((ResPackage)p).packageId == pkgID && ((ResPackage)p).packageName.equals(pkgName)).findFirst().orElse(null);
    }

    public AbstractResource findResource(int resourceId) {
        ResourceId id = this.parseResourceId(resourceId);
        for (ResPackage resPackage : this.packages) {
            if (resPackage.packageId != id.packageId) continue;
            for (ResType resType : resPackage.types) {
                if (resType.id != id.typeId) continue;
                return resType.getFirstResource(resourceId);
            }
        }
        return null;
    }

    public List<AbstractResource> findAllResources(int resourceId) {
        ArrayList<AbstractResource> resourceList = new ArrayList<AbstractResource>();
        ResourceId id = this.parseResourceId(resourceId);
        for (ResPackage resPackage : this.packages) {
            if (resPackage.packageId != id.packageId) continue;
            for (ResType resType : resPackage.types) {
                if (resType.id != id.typeId) continue;
                resourceList.addAll(resType.getAllResources(resourceId));
            }
        }
        return resourceList;
    }

    public ResType findResourceType(int resourceId) {
        ResourceId id = this.parseResourceId(resourceId);
        for (ResPackage resPackage : this.packages) {
            if (resPackage.packageId != id.packageId) continue;
            for (ResType resType : resPackage.types) {
                if (resType.id != id.typeId) continue;
                return resType;
            }
        }
        return null;
    }

    public ResourceId parseResourceId(int resourceId) {
        return new ResourceId((resourceId & 0xFF000000) >> 24, (resourceId & 0xFF0000) >> 16, resourceId & 0xFFFF);
    }

    public AbstractResource findResourceByName(String type, String resourceName) {
        for (ResPackage resPackage : this.packages) {
            ResType resType = resPackage.getResourceType(type);
            if (resType == null) continue;
            for (AbstractResource res : resType.getAllResources()) {
                if (!res.resourceName.equals(resourceName)) continue;
                return res;
            }
        }
        return null;
    }

    public String findStringResource(String resourceName) {
        AbstractResource res = this.findResourceByName("string", resourceName);
        if (res instanceof StringResource) {
            StringResource stringRes = (StringResource)res;
            return stringRes.value;
        }
        return null;
    }

    public List<AbstractResource> findResourcesByType(String type) {
        ArrayList<AbstractResource> resourceList = new ArrayList<AbstractResource>();
        for (ResPackage resPackage : this.packages) {
            ResType resType = resPackage.getResourceType(type);
            if (resType == null) continue;
            resourceList.addAll(resType.getAllResources());
        }
        return resourceList;
    }

    public static ARSCFileParser getInstance(File apkFile) throws IOException {
        ARSCFileParser parser = new ARSCFileParser();
        try (ApkHandler handler = new ApkHandler(apkFile);
             InputStream is = handler.getInputStream("resources.arsc");){
            if (is == null) {
                ARSCFileParser aRSCFileParser = null;
                return aRSCFileParser;
            }
            parser.parse(is);
        }
        return parser;
    }

    public void addAll(ARSCFileParser otherParser) {
        for (ResPackage pkg : otherParser.packages) {
            ResPackage existingPackage = this.getPackage(pkg.packageId, pkg.packageName);
            if (existingPackage == null) {
                this.packages.add(pkg);
                continue;
            }
            existingPackage.addAll(pkg);
        }
        this.stringTable.putAll(otherParser.stringTable);
    }

    public static class ResourceId {
        private int packageId;
        private int typeId;
        private int itemIndex;

        public ResourceId(int packageId, int typeId, int itemIndex) {
            this.packageId = packageId;
            this.typeId = typeId;
            this.itemIndex = itemIndex;
        }

        public int getPackageId() {
            return this.packageId;
        }

        public int getTypeId() {
            return this.typeId;
        }

        public int getItemIndex() {
            return this.itemIndex;
        }

        public String toString() {
            return "Package " + this.packageId + ", type " + this.typeId + ", item " + this.itemIndex;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.itemIndex;
            result = 31 * result + this.packageId;
            result = 31 * result + this.typeId;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ResourceId other = (ResourceId)obj;
            if (this.itemIndex != other.itemIndex) {
                return false;
            }
            if (this.packageId != other.packageId) {
                return false;
            }
            return this.typeId == other.typeId;
        }
    }

    protected static class ResTable_Map {
        int name;
        Res_Value value = new Res_Value();

        protected ResTable_Map() {
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.name;
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ResTable_Map other = (ResTable_Map)obj;
            if (this.name != other.name) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }
    }

    protected static class Res_Value {
        int size;
        int res0;
        int dataType;
        int data;

        protected Res_Value() {
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.data;
            result = 31 * result + this.dataType;
            result = 31 * result + this.res0;
            result = 31 * result + this.size;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Res_Value other = (Res_Value)obj;
            if (this.data != other.data) {
                return false;
            }
            if (this.dataType != other.dataType) {
                return false;
            }
            if (this.res0 != other.res0) {
                return false;
            }
            return this.size == other.size;
        }
    }

    protected static class ResTable_Map_Entry
    extends ResTable_Entry {
        int parent;
        int count;

        protected ResTable_Map_Entry() {
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + this.count;
            result = 31 * result + this.parent;
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ResTable_Map_Entry other = (ResTable_Map_Entry)obj;
            if (this.count != other.count) {
                return false;
            }
            return this.parent == other.parent;
        }
    }

    protected static class ResTable_Entry {
        int size;
        boolean flagsComplex;
        boolean flagsPublic;
        int key;

        protected ResTable_Entry() {
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.flagsComplex ? 1231 : 1237);
            result = 31 * result + (this.flagsPublic ? 1231 : 1237);
            result = 31 * result + this.key;
            result = 31 * result + this.size;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ResTable_Entry other = (ResTable_Entry)obj;
            if (this.flagsComplex != other.flagsComplex) {
                return false;
            }
            if (this.flagsPublic != other.flagsPublic) {
                return false;
            }
            if (this.key != other.key) {
                return false;
            }
            return this.size == other.size;
        }
    }

    public static class ResTable_Config {
        int size;
        int mmc;
        int mnc;
        char[] language = new char[2];
        char[] country = new char[2];
        int orientation;
        int touchscreen;
        int density;
        int keyboard;
        int navigation;
        int inputFlags;
        int inputPad0;
        int screenWidth;
        int screenHeight;
        int sdkVersion;
        int minorVersion;
        int screenLayout;
        int uiMode;
        int smallestScreenWidthDp;
        int screenWidthDp;
        int screenHeightDp;
        char[] localeScript = new char[4];
        char[] localeVariant = new char[8];

        public int getMmc() {
            return this.mmc;
        }

        public int getMnc() {
            return this.mnc;
        }

        public String getLanguage() {
            return new String(this.language);
        }

        public String getCountry() {
            return new String(this.country);
        }

        public int getOrientation() {
            return this.orientation;
        }

        public int getTouchscreen() {
            return this.touchscreen;
        }

        public int getDensity() {
            return this.density;
        }

        public int getKeyboard() {
            return this.keyboard;
        }

        public int getNavigation() {
            return this.navigation;
        }

        public int getInputFlags() {
            return this.inputFlags;
        }

        public int getInputPad0() {
            return this.inputPad0;
        }

        public int getScreenWidth() {
            return this.screenWidth;
        }

        public int getScreenHeight() {
            return this.screenHeight;
        }

        public int getSdkVersion() {
            return this.sdkVersion;
        }

        public int getMinorVersion() {
            return this.minorVersion;
        }

        public int getScreenLayout() {
            return this.screenLayout;
        }

        public int getUiMode() {
            return this.uiMode;
        }

        public int getSmallestScreenWidthDp() {
            return this.smallestScreenWidthDp;
        }

        public int getScreenWidthDp() {
            return this.screenWidthDp;
        }

        public int getScreenHeightDp() {
            return this.screenHeightDp;
        }

        public String getLocaleScript() {
            return new String(this.localeScript);
        }

        public String getLocaleVariant() {
            return new String(this.localeVariant);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.country);
            result = 31 * result + this.density;
            result = 31 * result + this.inputFlags;
            result = 31 * result + this.inputPad0;
            result = 31 * result + this.keyboard;
            result = 31 * result + Arrays.hashCode(this.language);
            result = 31 * result + Arrays.hashCode(this.localeScript);
            result = 31 * result + Arrays.hashCode(this.localeVariant);
            result = 31 * result + this.minorVersion;
            result = 31 * result + this.mmc;
            result = 31 * result + this.mnc;
            result = 31 * result + this.navigation;
            result = 31 * result + this.orientation;
            result = 31 * result + this.screenHeight;
            result = 31 * result + this.screenHeightDp;
            result = 31 * result + this.screenLayout;
            result = 31 * result + this.screenWidth;
            result = 31 * result + this.screenWidthDp;
            result = 31 * result + this.sdkVersion;
            result = 31 * result + this.size;
            result = 31 * result + this.smallestScreenWidthDp;
            result = 31 * result + this.touchscreen;
            result = 31 * result + this.uiMode;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ResTable_Config other = (ResTable_Config)obj;
            if (!Arrays.equals(this.country, other.country)) {
                return false;
            }
            if (this.density != other.density) {
                return false;
            }
            if (this.inputFlags != other.inputFlags) {
                return false;
            }
            if (this.inputPad0 != other.inputPad0) {
                return false;
            }
            if (this.keyboard != other.keyboard) {
                return false;
            }
            if (!Arrays.equals(this.language, other.language)) {
                return false;
            }
            if (!Arrays.equals(this.localeScript, other.localeScript)) {
                return false;
            }
            if (!Arrays.equals(this.localeVariant, other.localeVariant)) {
                return false;
            }
            if (this.minorVersion != other.minorVersion) {
                return false;
            }
            if (this.mmc != other.mmc) {
                return false;
            }
            if (this.mnc != other.mnc) {
                return false;
            }
            if (this.navigation != other.navigation) {
                return false;
            }
            if (this.orientation != other.orientation) {
                return false;
            }
            if (this.screenHeight != other.screenHeight) {
                return false;
            }
            if (this.screenHeightDp != other.screenHeightDp) {
                return false;
            }
            if (this.screenLayout != other.screenLayout) {
                return false;
            }
            if (this.screenWidth != other.screenWidth) {
                return false;
            }
            if (this.screenWidthDp != other.screenWidthDp) {
                return false;
            }
            if (this.sdkVersion != other.sdkVersion) {
                return false;
            }
            if (this.size != other.size) {
                return false;
            }
            if (this.smallestScreenWidthDp != other.smallestScreenWidthDp) {
                return false;
            }
            if (this.touchscreen != other.touchscreen) {
                return false;
            }
            return this.uiMode == other.uiMode;
        }
    }

    protected static class ResTable_Type {
        ResChunk_Header header;
        int id;
        int res0;
        int res1;
        int entryCount;
        int entriesStart;
        ResTable_Config config = new ResTable_Config();

        protected ResTable_Type() {
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.config == null ? 0 : this.config.hashCode());
            result = 31 * result + this.entriesStart;
            result = 31 * result + this.entryCount;
            result = 31 * result + (this.header == null ? 0 : this.header.hashCode());
            result = 31 * result + this.id;
            result = 31 * result + this.res0;
            result = 31 * result + this.res1;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ResTable_Type other = (ResTable_Type)obj;
            if (this.config == null ? other.config != null : !this.config.equals(other.config)) {
                return false;
            }
            if (this.entriesStart != other.entriesStart) {
                return false;
            }
            if (this.entryCount != other.entryCount) {
                return false;
            }
            if (this.header == null ? other.header != null : !this.header.equals(other.header)) {
                return false;
            }
            if (this.id != other.id) {
                return false;
            }
            if (this.res0 != other.res0) {
                return false;
            }
            return this.res1 == other.res1;
        }
    }

    protected static class ResTable_TypeSpec {
        ResChunk_Header header;
        int id;
        int res0;
        int res1;
        int entryCount;

        protected ResTable_TypeSpec() {
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.entryCount;
            result = 31 * result + (this.header == null ? 0 : this.header.hashCode());
            result = 31 * result + this.id;
            result = 31 * result + this.res0;
            result = 31 * result + this.res1;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ResTable_TypeSpec other = (ResTable_TypeSpec)obj;
            if (this.entryCount != other.entryCount) {
                return false;
            }
            if (this.header == null ? other.header != null : !this.header.equals(other.header)) {
                return false;
            }
            if (this.id != other.id) {
                return false;
            }
            if (this.res0 != other.res0) {
                return false;
            }
            return this.res1 == other.res1;
        }
    }

    protected static class ResTable_Package {
        ResChunk_Header header;
        int id;
        String name;
        int typeStrings;
        int lastPublicType;
        int keyStrings;
        int lastPublicKey;

        protected ResTable_Package() {
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.header == null ? 0 : this.header.hashCode());
            result = 31 * result + this.id;
            result = 31 * result + this.keyStrings;
            result = 31 * result + this.lastPublicKey;
            result = 31 * result + this.lastPublicType;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + this.typeStrings;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ResTable_Package other = (ResTable_Package)obj;
            if (this.header == null ? other.header != null : !this.header.equals(other.header)) {
                return false;
            }
            if (this.id != other.id) {
                return false;
            }
            if (this.keyStrings != other.keyStrings) {
                return false;
            }
            if (this.lastPublicKey != other.lastPublicKey) {
                return false;
            }
            if (this.lastPublicType != other.lastPublicType) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return this.typeStrings == other.typeStrings;
        }
    }

    protected static class ResStringPool_Header {
        ResChunk_Header header;
        int stringCount;
        int styleCount;
        boolean flagsSorted;
        boolean flagsUTF8;
        int stringsStart;
        int stylesStart;

        protected ResStringPool_Header() {
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.flagsSorted ? 1231 : 1237);
            result = 31 * result + (this.flagsUTF8 ? 1231 : 1237);
            result = 31 * result + (this.header == null ? 0 : this.header.hashCode());
            result = 31 * result + this.stringCount;
            result = 31 * result + this.stringsStart;
            result = 31 * result + this.styleCount;
            result = 31 * result + this.stylesStart;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ResStringPool_Header other = (ResStringPool_Header)obj;
            if (this.flagsSorted != other.flagsSorted) {
                return false;
            }
            if (this.flagsUTF8 != other.flagsUTF8) {
                return false;
            }
            if (this.header == null ? other.header != null : !this.header.equals(other.header)) {
                return false;
            }
            if (this.stringCount != other.stringCount) {
                return false;
            }
            if (this.stringsStart != other.stringsStart) {
                return false;
            }
            if (this.styleCount != other.styleCount) {
                return false;
            }
            return this.stylesStart == other.stylesStart;
        }
    }

    protected static class ResChunk_Header {
        int type;
        int headerSize;
        int size;

        protected ResChunk_Header() {
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.headerSize;
            result = 31 * result + this.size;
            result = 31 * result + this.type;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ResChunk_Header other = (ResChunk_Header)obj;
            if (this.headerSize != other.headerSize) {
                return false;
            }
            if (this.size != other.size) {
                return false;
            }
            return this.type == other.type;
        }
    }

    protected static class ResTable_Header {
        ResChunk_Header header = new ResChunk_Header();
        int packageCount;

        protected ResTable_Header() {
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.header == null ? 0 : this.header.hashCode());
            result = 31 * result + this.packageCount;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ResTable_Header other = (ResTable_Header)obj;
            if (this.header == null ? other.header != null : !this.header.equals(other.header)) {
                return false;
            }
            return this.packageCount == other.packageCount;
        }
    }

    public static class ComplexResource
    extends AbstractResource {
        private final String resType;
        private final Map<String, AbstractResource> value;

        public ComplexResource(String resType) {
            this.resType = resType;
            this.value = new HashMap<String, AbstractResource>();
        }

        public ComplexResource(String resType, Map<String, AbstractResource> value) {
            this.resType = resType;
            this.value = value;
        }

        public Map<String, AbstractResource> getValue() {
            return this.value;
        }

        public String getResType() {
            return this.resType;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ComplexResource other = (ComplexResource)obj;
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }
    }

    public static class DimensionResource
    extends AbstractResource {
        private int value;
        private Dimension unit;

        public DimensionResource(int value, Dimension unit) {
            this.value = value;
            this.unit = unit;
        }

        DimensionResource(int dimension, int value) {
            this.value = value;
            switch (dimension) {
                case 0: {
                    this.unit = Dimension.PX;
                    break;
                }
                case 1: {
                    this.unit = Dimension.DIP;
                    break;
                }
                case 2: {
                    this.unit = Dimension.SP;
                    break;
                }
                case 3: {
                    this.unit = Dimension.PT;
                    break;
                }
                case 4: {
                    this.unit = Dimension.IN;
                    break;
                }
                case 5: {
                    this.unit = Dimension.MM;
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid dimension: " + dimension);
                }
            }
        }

        public int getValue() {
            return this.value;
        }

        public Dimension getUnit() {
            return this.unit;
        }

        public String toString() {
            return Integer.toString(this.value) + this.unit.toString().toLowerCase();
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.unit == null ? 0 : this.unit.hashCode());
            result = 31 * result + this.value;
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DimensionResource other = (DimensionResource)obj;
            if (this.unit != other.unit) {
                return false;
            }
            return this.value == other.value;
        }
    }

    public static enum Dimension {
        PX,
        DIP,
        SP,
        PT,
        IN,
        MM;

    }

    public static class FractionResource
    extends AbstractResource {
        private FractionType type;
        private float value;

        public FractionResource(FractionType type, float value) {
            this.type = type;
            this.value = value;
        }

        public FractionType getType() {
            return this.type;
        }

        public float getValue() {
            return this.value;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            result = 31 * result + Float.floatToIntBits(this.value);
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FractionResource other = (FractionResource)obj;
            if (this.type != other.type) {
                return false;
            }
            return Float.floatToIntBits(this.value) == Float.floatToIntBits(other.value);
        }
    }

    public static enum FractionType {
        Fraction,
        FractionParent;

    }

    public static class ArrayResource
    extends AbstractResource {
        private final List<AbstractResource> arrayElements;

        public ArrayResource() {
            this.arrayElements = new ArrayList<AbstractResource>();
        }

        public ArrayResource(List<AbstractResource> arrayElements) {
            this.arrayElements = arrayElements;
        }

        public void add(AbstractResource resource) {
            this.arrayElements.add(resource);
        }

        public String toString() {
            return this.arrayElements.toString();
        }

        public List<AbstractResource> getArrayElements() {
            return Collections.unmodifiableList(this.arrayElements);
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.arrayElements == null ? 0 : this.arrayElements.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ArrayResource other = (ArrayResource)obj;
            return !(this.arrayElements == null ? other.arrayElements != null : !this.arrayElements.equals(other.arrayElements));
        }
    }

    public static class ColorResource
    extends AbstractResource {
        private int a;
        private int r;
        private int g;
        private int b;

        public ColorResource(int a, int r, int g, int b) {
            this.a = a;
            this.r = r;
            this.g = g;
            this.b = b;
        }

        public int getA() {
            return this.a;
        }

        public int getR() {
            return this.r;
        }

        public int getG() {
            return this.g;
        }

        public int getB() {
            return this.b;
        }

        public int getARGB() {
            return this.a << 24 | this.r << 16 | this.g << 8 | this.b;
        }

        public String toString() {
            return String.format("#%02x%02x%02x%02x", this.a, this.r, this.g, this.b);
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.a;
            result = 31 * result + this.b;
            result = 31 * result + this.g;
            result = 31 * result + this.r;
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ColorResource other = (ColorResource)obj;
            if (this.a != other.a) {
                return false;
            }
            if (this.b != other.b) {
                return false;
            }
            if (this.g != other.g) {
                return false;
            }
            return this.r == other.r;
        }
    }

    public static class BooleanResource
    extends AbstractResource {
        private boolean value;

        public BooleanResource(int value) {
            this.value = value != 0;
        }

        public boolean getValue() {
            return this.value;
        }

        public String toString() {
            return Boolean.toString(this.value);
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.value ? 1231 : 1237);
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BooleanResource other = (BooleanResource)obj;
            return this.value == other.value;
        }
    }

    public static class FloatResource
    extends AbstractResource {
        private float value;

        public FloatResource(float value) {
            this.value = value;
        }

        public float getValue() {
            return this.value;
        }

        public String toString() {
            return Float.toString(this.value);
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Float.floatToIntBits(this.value);
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FloatResource other = (FloatResource)obj;
            return Float.floatToIntBits(this.value) == Float.floatToIntBits(other.value);
        }
    }

    public static class IntegerResource
    extends AbstractResource {
        private int value;

        public IntegerResource(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            return Integer.toString(this.value);
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.value;
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IntegerResource other = (IntegerResource)obj;
            return this.value == other.value;
        }
    }

    public static class StringResource
    extends AbstractResource {
        private String value;

        public StringResource(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.value;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StringResource other = (StringResource)obj;
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }
    }

    public static class AttributeResource
    extends AbstractResource {
        private int attributeID;

        public AttributeResource(int id) {
            this.attributeID = id;
        }

        public int getAttributeID() {
            return this.attributeID;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.attributeID;
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AttributeResource other = (AttributeResource)obj;
            return this.attributeID == other.attributeID;
        }
    }

    public static class ReferenceResource
    extends AbstractResource {
        private int referenceID;

        public ReferenceResource(int id) {
            this.referenceID = id;
        }

        public int getReferenceID() {
            return this.referenceID;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.referenceID;
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ReferenceResource other = (ReferenceResource)obj;
            return this.referenceID == other.referenceID;
        }
    }

    public static class NullResource
    extends AbstractResource {
    }

    public static abstract class AbstractResource {
        private String resourceName;
        private int resourceID;

        public String getResourceName() {
            return this.resourceName;
        }

        public int getResourceID() {
            return this.resourceID;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.resourceID;
            result = 31 * result + (this.resourceName == null ? 0 : this.resourceName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AbstractResource other = (AbstractResource)obj;
            if (this.resourceID != other.resourceID) {
                return false;
            }
            return !(this.resourceName == null ? other.resourceName != null : !this.resourceName.equals(other.resourceName));
        }
    }

    public static class ResConfig {
        private ResTable_Config config;
        private List<AbstractResource> resources = new ArrayList<AbstractResource>();

        public ResTable_Config getConfig() {
            return this.config;
        }

        private void addAll(ResConfig other) {
            this.resources.addAll(other.resources);
        }

        public List<AbstractResource> getResources() {
            return this.resources;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.config == null ? 0 : this.config.hashCode());
            result = 31 * result + (this.resources == null ? 0 : this.resources.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ResConfig other = (ResConfig)obj;
            if (this.config == null ? other.config != null : !this.config.equals(other.config)) {
                return false;
            }
            return !(this.resources == null ? other.resources != null : !this.resources.equals(other.resources));
        }
    }

    public static class ResType {
        private int id;
        private String typeName;
        private List<ResConfig> configurations = new ArrayList<ResConfig>();

        public String getTypeName() {
            return this.typeName;
        }

        private void addAll(ResType tp) {
            for (ResConfig config : tp.configurations) {
                ResConfig existingConfig = this.getConfiguration(config.getConfig());
                if (existingConfig == null) {
                    this.configurations.add(config);
                    continue;
                }
                existingConfig.addAll(config);
            }
        }

        public ResConfig getConfiguration(ResTable_Config config) {
            return this.configurations.stream().filter(c -> ((ResConfig)c).config.equals(config)).findFirst().orElse(null);
        }

        public List<ResConfig> getConfigurations() {
            return this.configurations;
        }

        public Collection<AbstractResource> getAllResources() {
            HashMap<String, AbstractResource> resources = new HashMap<String, AbstractResource>();
            for (ResConfig rc : this.configurations) {
                for (AbstractResource res : rc.getResources()) {
                    if (resources.containsKey(res.resourceName)) continue;
                    resources.put(res.resourceName, res);
                }
            }
            return resources.values();
        }

        public Collection<String> getAllResourceNames() {
            return this.configurations.stream().flatMap(c -> c.getResources().stream()).map(r -> r.getResourceName()).collect(Collectors.toSet());
        }

        public List<AbstractResource> getAllResources(int resourceID) {
            ArrayList<AbstractResource> resourceList = new ArrayList<AbstractResource>();
            for (ResConfig rc : this.configurations) {
                for (AbstractResource res : rc.getResources()) {
                    if (res.resourceID != resourceID) continue;
                    resourceList.add(res);
                }
            }
            return resourceList;
        }

        public AbstractResource getResourceByName(String resourceName) {
            for (ResConfig rc : this.configurations) {
                for (AbstractResource res : rc.getResources()) {
                    if (!res.getResourceName().equals(resourceName)) continue;
                    return res;
                }
            }
            return null;
        }

        public AbstractResource getFirstResource(String resourceName) {
            for (ResConfig rc : this.configurations) {
                for (AbstractResource res : rc.getResources()) {
                    if (!res.resourceName.equals(resourceName)) continue;
                    return res;
                }
            }
            return null;
        }

        public AbstractResource getFirstResource(int resourceID) {
            for (ResConfig rc : this.configurations) {
                for (AbstractResource res : rc.getResources()) {
                    if (res.resourceID != resourceID) continue;
                    return res;
                }
            }
            return null;
        }

        public String toString() {
            return this.typeName;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.configurations == null ? 0 : this.configurations.hashCode());
            result = 31 * result + this.id;
            result = 31 * result + (this.typeName == null ? 0 : this.typeName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ResType other = (ResType)obj;
            if (this.configurations == null ? other.configurations != null : !this.configurations.equals(other.configurations)) {
                return false;
            }
            if (this.id != other.id) {
                return false;
            }
            return !(this.typeName == null ? other.typeName != null : !this.typeName.equals(other.typeName));
        }
    }

    public static class ResPackage {
        private int packageId;
        private String packageName;
        private List<ResType> types = new ArrayList<ResType>();

        public int getPackageId() {
            return this.packageId;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public List<ResType> getDeclaredTypes() {
            return this.types;
        }

        public ResType getResourceType(String type) {
            for (ResType resType : this.types) {
                if (!resType.typeName.equals(type)) continue;
                return resType;
            }
            return null;
        }

        private void addAll(ResPackage other) {
            for (ResType tp : other.types) {
                ResType existingType = this.getType(tp.id, tp.typeName);
                if (existingType == null) {
                    this.types.add(tp);
                    continue;
                }
                existingType.addAll(tp);
            }
        }

        public ResType getType(int id, String typeName) {
            return this.types.stream().filter(t -> ((ResType)t).id == id && ((ResType)t).typeName.equals(typeName)).findFirst().orElse(null);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.packageId;
            result = 31 * result + (this.packageName == null ? 0 : this.packageName.hashCode());
            result = 31 * result + (this.types == null ? 0 : this.types.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ResPackage other = (ResPackage)obj;
            if (this.packageId != other.packageId) {
                return false;
            }
            if (this.packageName == null ? other.packageName != null : !this.packageName.equals(other.packageName)) {
                return false;
            }
            return !(this.types == null ? other.types != null : !this.types.equals(other.types));
        }
    }
}

